/*
 * Decompiled with CFR 0.152.
 */
package net.bitform.oilink;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.bitform.oilink.BasicIO;

public class ByteBufferToBasicIO
implements BasicIO {
    private final ByteBuffer bb;
    private final String fileName;

    ByteBufferToBasicIO(ByteBuffer byteBuffer) {
        this.bb = byteBuffer;
        this.fileName = null;
    }

    ByteBufferToBasicIO(ByteBuffer byteBuffer, String string) {
        this.bb = byteBuffer;
        this.fileName = string;
    }

    @Override
    public void open() {
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public int readAt(long l, ByteBuffer byteBuffer) throws IOException {
        if (l < 0L || l > (long)this.bb.capacity()) {
            throw new IllegalArgumentException("position parameter out of range");
        }
        this.bb.limit(this.bb.capacity());
        this.bb.position((int)l);
        int n = 0;
        if (this.bb.remaining() > byteBuffer.remaining()) {
            n = byteBuffer.remaining();
            this.bb.limit(this.bb.position() + byteBuffer.remaining());
        } else {
            n = this.bb.remaining();
        }
        byteBuffer.put(this.bb);
        return n;
    }

    @Override
    public void writeAt(long l, ByteBuffer byteBuffer) throws IOException {
        throw new IllegalArgumentException("writeAt not allowed on fixed length ByteBuffer");
    }

    @Override
    public long getSize() throws IOException {
        return this.bb.capacity();
    }

    @Override
    public void close() {
    }

    @Override
    public File getUnderlyingFile() {
        return null;
    }

    @Override
    public String getUnderlyingFileName() {
        return this.fileName;
    }
}

