/*
 * Decompiled with CFR 0.152.
 */
package net.bitform.oilink;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class OILinkMonitor
extends Thread {
    private IdentityHashMap<Thread, ThreadMonitorInfo> threadMap = new IdentityHashMap();
    private static ArrayList<ProcessMonitorInfo> processList = new ArrayList();
    private boolean monitorDone = false;
    private Thread monitorThread;
    private static OILinkMonitor monitor = null;
    private static long processTimeout = 10000L;
    private int m_timetakenToCreateProcess = 0;

    private OILinkMonitor() {
        super("OILink process monitor");
        this.setDaemon(true);
    }

    public static synchronized void use() {
        if (monitor == null) {
            monitor = new OILinkMonitor();
            monitor.start();
        }
    }

    public static synchronized void updateTimeTakenInProcessCreation(int n) {
        if (monitor != null) {
            OILinkMonitor.monitor.m_timetakenToCreateProcess += n;
        }
    }

    public static synchronized boolean monitorRunning() {
        return monitor != null;
    }

    public static void setIdleProcessTimeout(long l) {
        processTimeout = l;
        OILinkMonitor.ResetIdleProcessesTimeout();
    }

    public static long getIdleProcessTimeout() {
        return processTimeout;
    }

    private static synchronized void ResetIdleProcessesTimeout() {
        for (ProcessMonitorInfo processMonitorInfo : processList) {
            processMonitorInfo.updateTimeout(processTimeout);
        }
    }

    private synchronized void interruptAllImp() {
        for (Thread thread : this.threadMap.keySet()) {
            ThreadMonitorInfo threadMonitorInfo = this.threadMap.get(thread);
            thread.interrupt();
            threadMonitorInfo.interrupted = true;
        }
    }

    public static synchronized void interruptAll() {
        if (monitor != null) {
            monitor.interruptAllImp();
        }
    }

    private synchronized void interruptMonitorImp() {
        this.interruptAllImp();
        this.endProcesses();
        this.monitorDone = true;
        this.monitorThread.interrupt();
        try {
            this.monitorThread.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        monitor = null;
    }

    public static synchronized void interruptMonitor() {
        if (monitor != null) {
            monitor.interruptMonitorImp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.monitorThread = Thread.currentThread();
        while (!this.monitorDone) {
            try {
                OILinkMonitor oILinkMonitor = this;
                synchronized (oILinkMonitor) {
                    this.wait(500L);
                    for (Thread thread : this.threadMap.keySet()) {
                        ThreadMonitorInfo threadMonitorInfo = this.threadMap.get(thread);
                        if (!threadMonitorInfo.hasTimeout || System.currentTimeMillis() <= threadMonitorInfo.endTime + (long)this.m_timetakenToCreateProcess) continue;
                        if (threadMonitorInfo.interrupted) {
                            thread.interrupt();
                            continue;
                        }
                        thread.interrupt();
                        threadMonitorInfo.interrupted = true;
                    }
                    Iterator<Object> iterator = processList.iterator();
                    while (iterator.hasNext()) {
                        ProcessMonitorInfo processMonitorInfo = (ProcessMonitorInfo)iterator.next();
                        if (!processMonitorInfo.hasTimeout || System.currentTimeMillis() <= processMonitorInfo.endTime) continue;
                        processMonitorInfo.owner.endProcess();
                        iterator.remove();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private synchronized void endProcesses() {
        Iterator<ProcessMonitorInfo> iterator = processList.iterator();
        while (iterator.hasNext()) {
            ProcessMonitorInfo processMonitorInfo = iterator.next();
            processMonitorInfo.owner.endProcess();
            iterator.remove();
        }
    }

    private synchronized ProcessOwner getProcessOwnerImp() {
        if (processList.size() == 0) {
            return null;
        }
        int n = processList.size() - 1;
        ProcessMonitorInfo processMonitorInfo = processList.get(n);
        processList.remove(n);
        return processMonitorInfo.owner;
    }

    private synchronized ProcessOwner getProcessOwnerImp(String string, String string2) {
        if (processList.size() == 0) {
            return null;
        }
        for (int i = processList.size() - 1; i > 0; --i) {
            ProcessMonitorInfo processMonitorInfo = processList.get(i);
            if (!processMonitorInfo.hasCredentials || !string.equals(processMonitorInfo.username)) continue;
            if (null == processMonitorInfo.password) {
                processList.remove(i);
                return processMonitorInfo.owner;
            }
            if (!string2.equals(processMonitorInfo.password)) continue;
            processList.remove(i);
            return processMonitorInfo.owner;
        }
        return null;
    }

    public static synchronized ProcessOwner getProcessOwner() {
        if (monitor == null) {
            return null;
        }
        return monitor.getProcessOwnerImp();
    }

    public static synchronized ProcessOwner getProcessOwner(String string, String string2) {
        if (monitor == null) {
            return null;
        }
        return monitor.getProcessOwnerImp(string, string2);
    }

    private synchronized void addProcessOwnerImp(ProcessOwner processOwner) {
        processList.add(new ProcessMonitorInfo(processOwner, processTimeout));
    }

    private synchronized void addProcessOwnerImp(ProcessOwner processOwner, String string, String string2) {
        processList.add(new ProcessMonitorInfo(processOwner, processTimeout, string, string2));
    }

    public static synchronized void addProcessOwner(ProcessOwner processOwner) {
        if (monitor == null) {
            return;
        }
        monitor.addProcessOwnerImp(processOwner);
    }

    public static synchronized void addProcessOwner(ProcessOwner processOwner, String string, String string2) {
        if (monitor == null) {
            return;
        }
        monitor.addProcessOwnerImp(processOwner, string, string2);
    }

    private synchronized void beforeProcessImp(long l) {
        Thread thread = Thread.currentThread();
        if (this.threadMap.containsKey(thread)) {
            throw new RuntimeException("Thread monitor saw a request start before other request was finished in the same thread");
        }
        this.threadMap.put(thread, new ThreadMonitorInfo(l));
    }

    public static synchronized void beforeProcess(long l) {
        if (monitor == null) {
            return;
        }
        monitor.beforeProcessImp(l);
    }

    private synchronized boolean afterProcessImp() {
        Thread thread = Thread.currentThread();
        ThreadMonitorInfo threadMonitorInfo = this.threadMap.get(thread);
        if (threadMonitorInfo == null) {
            throw new RuntimeException("Thread monitor saw a request finish but it had no information about the request");
        }
        Thread.interrupted();
        this.threadMap.remove(thread);
        return threadMonitorInfo.interrupted;
    }

    public static synchronized boolean afterProcess() {
        if (monitor == null) {
            return true;
        }
        return monitor.afterProcessImp();
    }

    private class ProcessMonitorInfo {
        long startTime;
        long endTime;
        boolean hasTimeout;
        final ProcessOwner owner;
        final boolean hasCredentials;
        final String username;
        final String password;

        ProcessMonitorInfo(ProcessOwner processOwner, long l) {
            this.owner = processOwner;
            this.updateTimeout(l);
            this.hasCredentials = false;
            this.username = null;
            this.password = null;
        }

        ProcessMonitorInfo(ProcessOwner processOwner, long l, String string, String string2) {
            this.owner = processOwner;
            this.updateTimeout(l);
            this.hasCredentials = true;
            this.username = string;
            this.password = string2;
        }

        public void updateTimeout(long l) {
            this.startTime = System.currentTimeMillis();
            this.endTime = this.startTime + l;
            this.hasTimeout = l != 0L;
        }
    }

    private class ThreadMonitorInfo {
        final long startTime = System.currentTimeMillis();
        final long endTime;
        final boolean hasTimeout;
        boolean interrupted;

        ThreadMonitorInfo(long l) {
            this.endTime = this.startTime + l;
            this.interrupted = false;
            this.hasTimeout = l != 0L;
        }
    }

    public static interface ProcessOwner {
        public void endProcess();
    }
}

