/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein;

import com.oracle.outsidein.Callback;
import com.oracle.outsidein.Document;
import com.oracle.outsidein.DocumentImpl;
import com.oracle.outsidein.ExportStatus;
import com.oracle.outsidein.Exporter;
import com.oracle.outsidein.FileFormat;
import com.oracle.outsidein.OILinkCallbackHandler;
import com.oracle.outsidein.OutsideInException;
import com.oracle.outsidein.annotations.RedactAnnotation;
import com.oracle.outsidein.options.OptionImpl;
import com.oracle.outsidein.options.Options;
import com.oracle.outsidein.options.OptionsCache;
import com.oracle.outsidein.options.OptionsCacheImpl;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.bitform.oilink.OIHandle;
import net.bitform.oilink.OILinkCallback;
import net.bitform.oilink.OILinkErrorCode;
import net.bitform.oilink.OILinkMessages;
import net.bitform.oilink.OILinkTimeoutException;

class ExporterImpl
extends DocumentImpl
implements Exporter {
    private OIHandle m_hExport;
    private ExportStatus m_exportStatus = null;

    ExporterImpl() throws OutsideInException {
        this.m_hExport = null;
        this.m_srcInfo.m_exportTimeout = 10000;
        this.m_cumulativeInfo.m_exportTimeout = 10000;
    }

    ExporterImpl(String string, String string2) throws OutsideInException {
        super(string, string2);
        this.m_hExport = null;
        this.m_srcInfo.m_exportTimeout = 10000;
        this.m_cumulativeInfo.m_exportTimeout = 10000;
    }

    ExporterImpl(Exporter exporter) throws OutsideInException {
        super(exporter);
        this.m_hExport = null;
        this.m_srcInfo.m_exportTimeout = 10000;
        this.m_cumulativeInfo.m_exportTimeout = 10000;
    }

    private ExporterImpl(ExporterImpl exporterImpl, Document.SubObjectTypeValue subObjectTypeValue, int n, int n2, int n3, int n4) throws OutsideInException {
        super(exporterImpl, subObjectTypeValue, n, n2, n3, n4);
    }

    private ExporterImpl(ExporterImpl exporterImpl, int n, Document.SubDocumentIdentifierTypeValue subDocumentIdentifierTypeValue) throws OutsideInException {
        super(exporterImpl, n, subDocumentIdentifierTypeValue);
    }

    private ExporterImpl(ExporterImpl exporterImpl, int n) throws OutsideInException {
        super(exporterImpl, n);
    }

    private ExporterImpl(ExporterImpl exporterImpl, int n, int n2, int n3) throws OutsideInException {
        super(exporterImpl, n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exporter newSubObjectExporter(Document.SubObjectTypeValue subObjectTypeValue, int n, int n2, int n3, int n4) throws OutsideInException {
        try {
            this.beforeProcess(this.m_cumulativeInfo.m_exportTimeout);
            this.verifyInputOpened();
            ExporterImpl exporterImpl = new ExporterImpl(this, subObjectTypeValue, n, n2, n3, n4);
            return exporterImpl;
        }
        finally {
            this.afterProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exporter newSubDocumentExporter(int n, Document.SubDocumentIdentifierTypeValue subDocumentIdentifierTypeValue) throws OutsideInException {
        try {
            this.beforeProcess(this.m_cumulativeInfo.m_exportTimeout);
            this.verifyInputOpened();
            ExporterImpl exporterImpl = new ExporterImpl(this, n, subDocumentIdentifierTypeValue);
            return exporterImpl;
        }
        finally {
            this.afterProcess();
        }
    }

    @Override
    public Exporter newArchiveNodeExporter(int n) throws OutsideInException {
        try {
            this.beforeProcess(this.m_cumulativeInfo.m_exportTimeout);
            this.verifyInputOpened();
            ExporterImpl exporterImpl = new ExporterImpl(this, n);
            return exporterImpl;
        }
        finally {
            this.afterProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exporter newArchiveNodeExporter(int n, int n2, int n3) throws OutsideInException {
        if (!this.m_cumulativeInfo.bOpenForNonSequentialAccess) {
            throw new OutsideInException("Error : Opening for Nonsequential access is not set");
        }
        try {
            this.beforeProcess(this.m_cumulativeInfo.m_exportTimeout);
            this.verifyInputOpened();
            ExporterImpl exporterImpl = new ExporterImpl(this, n, n2, n3);
            return exporterImpl;
        }
        finally {
            this.afterProcess();
        }
    }

    private void openOutput(int n, Callback callback) throws OutsideInException, OILinkTimeoutException {
        try {
            if (this.m_dstFile != null && !this.m_dstFile.getCanonicalFile().getParentFile().exists()) {
                throw new OutsideInException("Destination directory " + this.m_dstFile.getCanonicalFile().getParent() + " does not exist");
            }
            this.setOptions(this.oil, this.m_hDoc, OptionImpl.OptionScopeValue.OUTPUT);
            this.m_hExport = this.m_dstFile != null ? this.oil.EXOpenExport(this.m_hDoc, n, this.m_dstFile, (OILinkCallback)new OILinkCallbackHandler(callback)) : this.oil.EXOpenExport(this.m_hDoc, n, this.m_dstRedirect, (OILinkCallback)new OILinkCallbackHandler(callback));
        }
        catch (OILinkTimeoutException oILinkTimeoutException) {
            throw oILinkTimeoutException;
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
    }

    @Override
    protected void verifyInputOpened() throws OutsideInException {
        if (this.bNextFile) {
            if (null == this.oil || !this.oil.isAlive()) {
                throw new OutsideInException("OILink process has stopped running.");
            }
            this.setOptions(this.oil, null, OptionImpl.OptionScopeValue.GLOBAL);
            if (this.m_bDoOpenInput) {
                this.m_bDoOpenInput = false;
                if (null == this.m_hExport) {
                    throw new OutsideInException("Exporter must be run on initial source file before addSourceFile()");
                }
                this.oil.setCallback(new OILinkCallbackHandler(this.m_cumulativeInfo.callback));
                try {
                    if (null != this.m_srcInfo.format) {
                        if (this.m_srcInfo.file != null) {
                            this.oil.DAOpenNextDocument(this.m_hExport, this.m_srcInfo.file, this.m_srcInfo.format.getId());
                        } else {
                            this.oil.DAOpenNextDocument(this.m_hExport, this.m_srcInfo.redirect, this.m_srcInfo.format.getId());
                        }
                    } else if (this.m_srcInfo.file != null) {
                        this.oil.DAOpenNextDocument(this.m_hExport, this.m_srcInfo.file);
                    } else {
                        this.oil.DAOpenNextDocument(this.m_hExport, this.m_srcInfo.redirect);
                    }
                }
                catch (IOException iOException) {
                    throw new OutsideInException(iOException.getMessage(), iOException);
                }
            }
            this.setOptions(this.oil, this.m_hDoc, OptionImpl.OptionScopeValue.INPUT);
        } else {
            super.verifyInputOpened();
        }
    }

    protected void verifyInputAndOutputOpened() throws OutsideInException, OILinkTimeoutException {
        if (null != this.m_hExport) {
            try {
                if (this.oil != null && this.oil.isAlive()) {
                    this.oil.EXCloseExport(this.m_hExport);
                }
            }
            catch (IOException iOException) {
                throw new OutsideInException(iOException.getMessage(), iOException);
            }
            finally {
                this.m_hExport = null;
            }
        }
        this.verifyInputOpened();
        this.openOutput(this.m_dstFileId.getId(), this.m_cumulativeInfo.callback);
    }

    protected void setKeyValuePairs() throws OutsideInException {
        if (null == this.m_srcInfo.m_keyValuePairs) {
            return;
        }
        if (null == this.oil || !this.oil.isAlive()) {
            throw new OutsideInException("Failed to set key/value pair. OILink process is not running.");
        }
        try {
            this.oil.EXAddKeyValuePairs(this.m_hExport, this.m_srcInfo.m_keyValuePairs);
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void export() throws OutsideInException {
        this.export(false);
    }

    @Override
    public void export(boolean bl) throws OutsideInException {
        if (this.m_docType != DocumentImpl.DOCTYPE.PARENTDOC) {
            this.runExport(this.m_srcInfo);
            try {
                this.closeExport();
                if (!bl) {
                    this.closeDocHandle();
                }
            }
            catch (IOException iOException) {
                throw new OutsideInException(iOException.getMessage(), iOException);
            }
            this.increaseOILinkAge(1);
            return;
        }
        if (this.m_srcInfoList.size() > 0) {
            this.m_cumulativeInfo = new OptionsCacheImpl.SourceFileInfo(this);
        }
        this.bNextFile = false;
        for (OptionsCacheImpl.SourceFileInfo sourceFileInfo : this.m_srcInfoList) {
            this.m_cumulativeInfo.inheritSourceFileInfo(sourceFileInfo);
            if (this.m_srcInfoList.size() > 1) {
                this.m_bDoOpenInput = true;
            }
            this.runExport(sourceFileInfo);
            this.bNextFile = true;
            this.increaseOILinkAge(1);
        }
        try {
            this.closeExport();
            if (!bl) {
                this.closeDocHandle();
            }
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
    }

    private void runExport(OptionsCacheImpl.SourceFileInfo sourceFileInfo) throws OutsideInException {
        this.m_srcInfo = sourceFileInfo;
        OILinkMessages.EXRunExportResponse eXRunExportResponse = null;
        try {
            this.beforeProcess(this.m_cumulativeInfo.m_exportTimeout);
            if (!this.bNextFile) {
                this.m_exportStatus = null;
                this.verifyInputAndOutputOpened();
            } else {
                this.verifyInputOpened();
                this.setOptions(this.oil, this.m_hDoc, OptionImpl.OptionScopeValue.OUTPUT);
            }
            this.setKeyValuePairs();
            if (this.m_templatefile != null) {
                this.oil.DASetOption(this.m_hExport, 3, this.m_templatefile);
            }
            if (this.m_srcInfo.m_stampimages != null) {
                this.oil.SetHiliteStampImages(this.m_hDoc, this.m_srcInfo.m_stampimages);
            }
            if (this.m_srcInfo.m_hilites != null) {
                this.oil.SetHilites(this.m_hExport, this.m_srcInfo.m_hilites);
            }
            if (this.m_srcInfo.m_highlightJsonDataList != null) {
                for (String object : this.m_srcInfo.m_highlightJsonDataList) {
                    this.oil.EXApplyHilites(this.m_hExport, object);
                }
            }
            if (this.m_srcInfo.m_redactions != null) {
                for (RedactAnnotation redactAnnotation : this.m_srcInfo.m_redactions) {
                    this.oil.EXRedactText(this.m_hExport, redactAnnotation.getStartCharCount(), redactAnnotation.getEndCharCount(), redactAnnotation.getLabel());
                }
            }
            if ((eXRunExportResponse = this.oil.EXRunExport(this.m_hExport)) != null) {
                if (this.m_exportStatus != null) {
                    this.m_exportStatus.addStatus(eXRunExportResponse);
                } else {
                    this.m_exportStatus = new ExportStatus(eXRunExportResponse);
                }
            }
        }
        catch (OILinkTimeoutException iOException) {
            try {
                this.resetOILinkProcess(false);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw new OutsideInException("The transform exceeded the export timeout and was interrupted", iOException);
        }
        catch (OILinkErrorCode oILinkErrorCode) {
            this.handleOILinkError(oILinkErrorCode);
            throw new OutsideInException(oILinkErrorCode.getMessage(), oILinkErrorCode);
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
        finally {
            this.afterProcess();
        }
    }

    @Override
    public ExportStatus getExportStatus() {
        return this.m_exportStatus;
    }

    @Override
    public OptionsCache setExportTimeout(int n) {
        this.m_srcInfo.m_exportTimeout = n;
        this.m_cumulativeInfo.m_exportTimeout = n;
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.ExportTimeoutOption);
        return this;
    }

    @Override
    public void addKeyValuePairs(Map<String, String> map) {
        if (null == map) {
            this.m_srcInfo.m_keyValuePairs = null;
            this.m_cumulativeInfo.m_keyValuePairs = null;
        } else {
            if (null == this.m_srcInfo.m_keyValuePairs) {
                this.m_srcInfo.m_keyValuePairs = new HashMap<String, String>();
            }
            this.m_srcInfo.m_keyValuePairs.putAll(map);
            if (null == this.m_cumulativeInfo.m_keyValuePairs) {
                this.m_cumulativeInfo.m_keyValuePairs = new HashMap<String, String>();
            }
            this.m_cumulativeInfo.m_keyValuePairs.putAll(map);
        }
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.KeyValuePairsOption);
    }

    @Override
    public long getPageCount(FileFormat fileFormat) throws OutsideInException {
        long l = 0L;
        try {
            this.beforeProcess(this.m_cumulativeInfo.m_exportTimeout);
            super.verifyInputOpened();
            this.setOptions(this.oil, this.m_hDoc, OptionImpl.OptionScopeValue.OUTPUT);
            l = this.oil.EXCountPages(this.m_hDoc, fileFormat.getId());
        }
        catch (IOException iOException) {
            throw new OutsideInException("Failed to obtain the page count.", iOException);
        }
        finally {
            this.afterProcess();
        }
        this.increaseOILinkAge(1);
        return l;
    }

    @Override
    public void close() throws IOException {
        this.closeExport();
        super.close();
    }

    private void closeExport() throws IOException {
        try {
            this.beforeProcess(this.m_cumulativeInfo.m_exportTimeout);
            if (this.oil != null && this.oil.isAlive() && null != this.m_hExport) {
                this.oil.EXCloseExport(this.m_hExport);
            }
        }
        catch (OILinkTimeoutException oILinkTimeoutException) {
            try {
                this.resetOILinkProcess(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException("The transform exceeded the export timeout and was interrupted", oILinkTimeoutException);
        }
        catch (OILinkErrorCode oILinkErrorCode) {
            this.handleOILinkError(oILinkErrorCode);
            throw new IOException(oILinkErrorCode.getMessage(), oILinkErrorCode);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage(), iOException);
        }
        finally {
            this.afterProcess();
            this.m_hExport = null;
        }
    }

    @Override
    protected void resetOILinkProcess(boolean bl) throws IOException {
        if (bl) {
            this.closeExport();
        }
        super.resetOILinkProcess(bl);
        this.m_hExport = null;
    }

    @Override
    public void setPageInformationRequired(EnumSet<Exporter.PageInformationValues> enumSet) throws OutsideInException {
        long l = 0L;
        for (Exporter.PageInformationValues pageInformationValues : enumSet) {
            l |= (long)pageInformationValues.value;
        }
        try {
            this.beforeProcess(this.m_cumulativeInfo.m_exportTimeout);
            this.verifyOILinkRunning();
            this.oil.DASetOption((OIHandle)null, 1001, l);
        }
        catch (IOException iOException) {
            throw new OutsideInException("Failed to set Page Information Requirements.", iOException);
        }
        finally {
            this.afterProcess();
        }
    }
}

