/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.bitform.oilink.OITVersion;

public class OutsideInVersion {
    String m_versionString;
    Date m_buildDateTime;
    Map<VersionID, String> m_versionComponents = null;

    OutsideInVersion(OITVersion oITVersion) {
        this.m_versionString = oITVersion.getVersionString();
        this.m_buildDateTime = oITVersion.getBuildDateTime();
        String[] stringArray = this.m_versionString.split("\\.");
        if (VersionID.values().length == stringArray.length) {
            this.m_versionComponents = new HashMap<VersionID, String>();
            this.m_versionComponents.put(VersionID.MAJORVERSION, stringArray[0]);
            this.m_versionComponents.put(VersionID.MINORVERSION, stringArray[1]);
            this.m_versionComponents.put(VersionID.DOTVERSION, stringArray[2]);
            this.m_versionComponents.put(VersionID.PATCHVERSION, stringArray[3]);
            this.m_versionComponents.put(VersionID.BUILDVERSION, stringArray[4]);
        }
    }

    public String toString() {
        return "Version: " + this.getMajorVersion() + "." + this.getMinorVersion() + "." + this.getDotVersion() + ", BuildDateTime: " + this.m_buildDateTime.toString();
    }

    public String getVersion() {
        return this.getMajorVersion() + "." + this.getMinorVersion() + "." + this.getDotVersion();
    }

    public int getMajorVersion() {
        return this.getVersionComponent(VersionID.MAJORVERSION);
    }

    public int getMinorVersion() {
        return this.getVersionComponent(VersionID.MINORVERSION);
    }

    public int getDotVersion() {
        return this.getVersionComponent(VersionID.DOTVERSION);
    }

    int getPatchVersion() {
        return this.getVersionComponent(VersionID.PATCHVERSION);
    }

    int getBuildVersion() {
        return this.getVersionComponent(VersionID.BUILDVERSION);
    }

    public Date getBuildDateTime() {
        return this.m_buildDateTime;
    }

    private int getVersionComponent(VersionID versionID) {
        if (this.m_versionComponents == null) {
            return 0;
        }
        return Integer.parseInt(this.m_versionComponents.get((Object)versionID));
    }

    private static enum VersionID {
        MAJORVERSION,
        MINORVERSION,
        DOTVERSION,
        PATCHVERSION,
        BUILDVERSION;

    }
}

