/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein;

import com.oracle.outsidein.ArchiveNode;
import com.oracle.outsidein.Document;
import com.oracle.outsidein.FileFormat;
import com.oracle.outsidein.OILinkCallbackHandler;
import com.oracle.outsidein.OILinkNotificationHandler;
import com.oracle.outsidein.ObjectInfo;
import com.oracle.outsidein.OutsideInException;
import com.oracle.outsidein.SeekableByteChannel6;
import com.oracle.outsidein.annotations.HighlightAreaAnnotation;
import com.oracle.outsidein.annotations.HighlightTextAnnotation;
import com.oracle.outsidein.annotations.RedactAnnotation;
import com.oracle.outsidein.annotations.StampAnnotation;
import com.oracle.outsidein.options.OptionImpl;
import com.oracle.outsidein.options.Options;
import com.oracle.outsidein.options.OptionsCache;
import com.oracle.outsidein.options.OptionsCacheImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.Map;
import net.bitform.oilink.FileToBasicIO;
import net.bitform.oilink.OIHandle;
import net.bitform.oilink.OILink;
import net.bitform.oilink.OILinkErrorCode;
import net.bitform.oilink.OILinkMessages;
import net.bitform.oilink.OILinkMonitor;
import net.bitform.oilink.OILinkStatus;

class DocumentImpl
extends OptionsCacheImpl
implements Document {
    protected OIHandle m_hDoc;
    protected DOCTYPE m_docType;
    protected OILinkMessages.DAGetTreeResponse m_curTree;
    private static final int OILINK_RESET_THRESHOLD = 200;
    private boolean m_bHasCredentials;
    private String m_username;
    private String m_password;
    private static final int OPENDOCUMENT_ARCHIVEONLY = 0x4000000;
    protected static final int FIXED_TIMEOUT = 10000;
    protected OILink oil;
    OILinkNotificationHandler m_oilNotifyHandler = null;
    int m_processReferenceCounter = 0;

    private void init() throws OutsideInException {
        this.m_docType = DOCTYPE.PARENTDOC;
        this.m_bDoOpenInput = false;
        OILinkStatus oILinkStatus = OILink.init();
        if (!oILinkStatus.isAvailable()) {
            throw new OutsideInException(oILinkStatus.getProblem());
        }
        OILinkMonitor.use();
    }

    DocumentImpl() throws OutsideInException {
        this.m_bHasCredentials = false;
        this.m_username = null;
        this.m_password = null;
        this.m_srcInfo.m_documentOperationTimeout = 10000;
        this.m_cumulativeInfo.m_documentOperationTimeout = 10000;
        this.init();
    }

    DocumentImpl(String string, String string2) throws OutsideInException {
        this.m_bHasCredentials = true;
        this.m_username = string;
        this.m_password = string2;
        this.m_srcInfo.m_documentOperationTimeout = 10000;
        this.m_cumulativeInfo.m_documentOperationTimeout = 10000;
        this.init();
    }

    DocumentImpl(Document document) throws OutsideInException {
        super((OptionsCacheImpl)((Object)document));
        DocumentImpl documentImpl = (DocumentImpl)document;
        this.m_bHasCredentials = documentImpl.m_bHasCredentials;
        this.m_username = documentImpl.m_username;
        this.m_password = documentImpl.m_password;
        this.m_srcInfo.m_documentOperationTimeout = 10000;
        this.m_cumulativeInfo.m_documentOperationTimeout = 10000;
        this.init();
    }

    protected DocumentImpl(DocumentImpl documentImpl, Document.SubObjectTypeValue subObjectTypeValue, int n, int n2, int n3, int n4) throws OutsideInException {
        super(documentImpl);
        this.oil = documentImpl.oil;
        this.m_bHasCredentials = documentImpl.m_bHasCredentials;
        this.m_username = documentImpl.m_username;
        this.m_password = documentImpl.m_password;
        try {
            this.m_hDoc = this.oil.DAOpenDocumentObject(documentImpl.m_hDoc, subObjectTypeValue.value, n, n2, n3, n4);
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
        this.m_bDoOpenInput = false;
        this.m_docType = DOCTYPE.OBJECT;
        this.setOptions(this.oil, this.m_hDoc, OptionImpl.OptionScopeValue.INPUT);
    }

    protected DocumentImpl(DocumentImpl documentImpl, int n, Document.SubDocumentIdentifierTypeValue subDocumentIdentifierTypeValue) throws OutsideInException {
        super(documentImpl);
        this.oil = documentImpl.oil;
        this.m_bHasCredentials = documentImpl.m_bHasCredentials;
        this.m_username = documentImpl.m_username;
        this.m_password = documentImpl.m_password;
        try {
            this.m_hDoc = this.oil.DAOpenSubdocumentById(documentImpl.m_hDoc, n, subDocumentIdentifierTypeValue.value);
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
        this.m_bDoOpenInput = false;
        this.m_docType = DOCTYPE.SUBDOC;
        this.setOptions(this.oil, this.m_hDoc, OptionImpl.OptionScopeValue.INPUT);
    }

    protected DocumentImpl(DocumentImpl documentImpl, int n) throws OutsideInException {
        super(documentImpl);
        this.oil = documentImpl.oil;
        this.m_bHasCredentials = documentImpl.m_bHasCredentials;
        this.m_username = documentImpl.m_username;
        this.m_password = documentImpl.m_password;
        try {
            this.m_hDoc = this.oil.DAOpenTreeRecord(documentImpl.m_hDoc, n);
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
        this.m_bDoOpenInput = false;
        this.m_docType = DOCTYPE.TREENODE;
        this.setOptions(this.oil, this.m_hDoc, OptionImpl.OptionScopeValue.INPUT);
    }

    protected DocumentImpl(DocumentImpl documentImpl, int n, int n2, int n3) throws OutsideInException {
        super(documentImpl);
        this.oil = documentImpl.oil;
        this.m_bHasCredentials = documentImpl.m_bHasCredentials;
        this.m_username = documentImpl.m_username;
        this.m_password = documentImpl.m_password;
        try {
            this.m_hDoc = this.oil.DAOpenTreeRecord(documentImpl.m_hDoc, n, n2, n3);
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
        this.m_bDoOpenInput = false;
        this.m_docType = DOCTYPE.TREENODE;
        this.setOptions(this.oil, this.m_hDoc, OptionImpl.OptionScopeValue.INPUT);
    }

    public void closeDocHandle() throws IOException {
        if (this.oil != null && this.oil.isAlive() && null != this.m_hDoc) {
            switch (this.m_docType) {
                case SUBDOC: 
                case OBJECT: 
                case PARENTDOC: {
                    this.oil.DACloseDocument(this.m_hDoc);
                    break;
                }
                case TREENODE: {
                    this.oil.DACloseTreeRecord(this.m_hDoc);
                    break;
                }
            }
        }
        this.m_hDoc = null;
        this.m_bDoOpenInput = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.m_oilNotifyHandler != null) {
            this.m_oilNotifyHandler.cleanupTempFiles();
        }
        try {
            this.beforeProcess(this.m_srcInfo.m_documentOperationTimeout);
            this.closeDocHandle();
        }
        finally {
            this.afterProcess();
            if (this.oil != null && this.oil.isAlive() && DOCTYPE.PARENTDOC == this.m_docType) {
                this.oil.resetNotifier();
                this.m_oilNotifyHandler = null;
                if (this.m_bHasCredentials) {
                    OILinkMonitor.addProcessOwner(this.oil, this.m_username, this.m_password);
                } else {
                    OILinkMonitor.addProcessOwner(this.oil);
                }
                this.oil = null;
            }
        }
    }

    protected void handleOILinkError(OILinkErrorCode oILinkErrorCode) {
        switch (oILinkErrorCode.getSccErr()) {
            case SYSTEM: 
            case ALLOCFAILED: 
            case OUTOFMEMORY: 
            case FILTERALLOCFAILED: {
                try {
                    this.resetOILinkProcess(true);
                }
                catch (IOException iOException) {}
                break;
            }
            case INVALID_STATE: 
            case EXCEPT_ACCESS_VIOLATION: {
                try {
                    this.resetOILinkProcess(false);
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetOILinkProcess(boolean bl) throws IOException {
        boolean bl2 = false;
        if (this.m_hDoc != null) {
            bl2 = true;
        }
        if (bl) {
            try {
                this.beforeProcess(this.m_srcInfo.m_documentOperationTimeout);
                this.closeDocHandle();
            }
            finally {
                this.afterProcess();
            }
        }
        if (this.oil != null && this.oil.isAlive()) {
            this.oil.endProcess();
        }
        this.m_bDoOpenInput = bl2;
        this.m_hDoc = null;
    }

    protected void increaseOILinkAge(int n) throws OutsideInException {
        this.oil.increaseAge(n);
        if (DOCTYPE.PARENTDOC == this.m_docType && this.oil != null && this.oil.getAge() >= OILink.getOILinkResetThreshold()) {
            try {
                this.resetOILinkProcess(true);
            }
            catch (IOException iOException) {
                throw new OutsideInException("Error resetting oilink process", iOException);
            }
        }
    }

    @Override
    public FileFormat getFileId(Document.FileIdInfoFlagValue fileIdInfoFlagValue) throws OutsideInException {
        try {
            this.beforeProcess(this.m_srcInfo.m_documentOperationTimeout);
            this.verifyInputOpened();
            if (Document.FileIdInfoFlagValue.RAWFI == fileIdInfoFlagValue) {
                FileFormat fileFormat = FileFormat.forId(this.oil.DAGetFileId((OIHandle)this.m_hDoc).rawId);
                return fileFormat;
            }
            FileFormat fileFormat = FileFormat.forId(this.oil.DAGetFileId((OIHandle)this.m_hDoc).normalId);
            return fileFormat;
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
        finally {
            this.afterProcess();
        }
    }

    @Override
    public int getArchiveNodeCount() throws OutsideInException {
        try {
            this.beforeProcess(this.m_srcInfo.m_documentOperationTimeout);
            this.verifyInputOpened();
            if (null == this.m_curTree) {
                this.m_curTree = this.oil.DAGetTree(this.m_hDoc);
            }
        }
        catch (OILinkErrorCode oILinkErrorCode) {
            int n = 0;
            return n;
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
        finally {
            this.afterProcess();
        }
        return this.m_curTree.getTreeNodesCount();
    }

    @Override
    public ArchiveNode getArchiveNode(int n) throws OutsideInException {
        ArchiveNode archiveNode = null;
        try {
            this.beforeProcess(this.m_srcInfo.m_documentOperationTimeout);
            this.verifyInputOpened();
            if (null == this.m_curTree) {
                this.m_curTree = this.oil.DAGetTree(this.m_hDoc);
            }
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
        finally {
            this.afterProcess();
        }
        OILinkMessages.DATreeNode dATreeNode = this.m_curTree.getTreeNodes(n);
        if (null != dATreeNode) {
            archiveNode = new ArchiveNode(n, dATreeNode.getName(), dATreeNode.getSize(), dATreeNode.getTime(), dATreeNode.getIsDirectory());
        }
        return archiveNode;
    }

    @Override
    public void saveArchiveNode(int n, File file) throws OutsideInException {
        try {
            this.beforeProcess(this.m_cumulativeInfo.m_exportTimeout);
            this.verifyInputOpened();
            this.oil.DASaveTreeRecord(this.m_hDoc, n, file);
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
        finally {
            this.afterProcess();
        }
        this.increaseOILinkAge(1);
    }

    @Override
    public void saveArchiveNode(int n, int n2, int n3, File file) throws OutsideInException {
        if (!this.m_cumulativeInfo.bOpenForNonSequentialAccess) {
            throw new OutsideInException("Error : Opening for nonsequential access is not set");
        }
        try {
            this.beforeProcess(this.m_cumulativeInfo.m_exportTimeout);
            this.verifyInputOpened();
            this.oil.DASaveTreeRecord(this.m_hDoc, n, n2, n3, file);
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
        finally {
            this.afterProcess();
        }
        this.increaseOILinkAge(1);
    }

    @Override
    public OptionsCache setSourceFile(File file) throws OutsideInException {
        this.m_bDoOpenInput = true;
        return super.setSourceFile(file);
    }

    @Override
    public OptionsCache setSourceFile(SeekableByteChannel6 seekableByteChannel6) throws OutsideInException {
        this.m_bDoOpenInput = true;
        return super.setSourceFile(seekableByteChannel6);
    }

    @Override
    public OptionsCache setSourceFile(SeekableByteChannel6 seekableByteChannel6, String string) throws OutsideInException {
        this.m_bDoOpenInput = true;
        return super.setSourceFile(seekableByteChannel6, string);
    }

    @Override
    public OptionsCache addSourceFile(File file) throws OutsideInException {
        this.m_bDoOpenInput = true;
        return super.addSourceFile(file);
    }

    @Override
    public OptionsCache addSourceFile(SeekableByteChannel6 seekableByteChannel6) throws OutsideInException {
        this.m_bDoOpenInput = true;
        return super.addSourceFile(seekableByteChannel6);
    }

    @Override
    public OptionsCache addSourceFile(SeekableByteChannel6 seekableByteChannel6, String string) throws OutsideInException {
        this.m_bDoOpenInput = true;
        return super.addSourceFile(seekableByteChannel6, string);
    }

    @Override
    public OptionsCache setSourceFormat(FileFormat fileFormat) {
        this.m_bDoOpenInput = true;
        return super.setSourceFormat(fileFormat);
    }

    @Override
    public OptionsCache setOpenForNonSequentialAccess(boolean bl) {
        super.setOpenForNonSequentialAccess(bl);
        this.m_bDoOpenInput = true;
        return this;
    }

    protected void verifyOILinkRunning() throws OutsideInException {
        if (null == this.oil || !this.oil.isAlive()) {
            if (this.m_hDoc != null) {
                this.m_bDoOpenInput = true;
            }
            this.m_hDoc = null;
            try {
                if (this.m_bHasCredentials) {
                    if (null == this.m_username) {
                        throw new OutsideInException("Username must not be null.");
                    }
                    this.oil = (OILink)OILinkMonitor.getProcessOwner(this.m_username, this.m_password);
                    if (null == this.oil) {
                        OILinkMonitor.updateTimeTakenInProcessCreation(this.m_srcInfo.m_processCreationTimeout);
                        this.oil = new OILink(this.m_username, this.m_password);
                    }
                } else {
                    this.oil = (OILink)OILinkMonitor.getProcessOwner();
                    if (null == this.oil) {
                        OILinkMonitor.updateTimeTakenInProcessCreation(this.m_srcInfo.m_processCreationTimeout);
                        this.oil = new OILink();
                    }
                }
                if (this.oil != null) {
                    this.m_oilNotifyHandler = new OILinkNotificationHandler();
                    this.oil.setNotifier(this.m_oilNotifyHandler);
                }
            }
            catch (IOException iOException) {
                throw new OutsideInException(iOException.getMessage(), iOException);
            }
        }
    }

    protected void verifyInputOpened() throws OutsideInException {
        this.verifyOILinkRunning();
        this.setOptions(this.oil, null, OptionImpl.OptionScopeValue.GLOBAL);
        this.setPasswordAndNotesId(this.oil, null);
        try {
            if (this.m_bDoOpenInput) {
                int n;
                this.m_bDoOpenInput = false;
                this.closeDocHandle();
                int n2 = n = this.m_cumulativeInfo.bOpenForNonSequentialAccess ? 0x4000000 : 0;
                if (null != this.m_srcInfo.format) {
                    n |= this.m_srcInfo.format.getId();
                }
                this.oil.setCallback(new OILinkCallbackHandler(this.m_cumulativeInfo.callback));
                this.m_hDoc = this.m_srcInfo.file != null ? this.oil.DAOpenDocument(this.m_srcInfo.file, n) : this.oil.DAOpenDocument(this.m_srcInfo.redirect, n);
            }
            if (null == this.m_hDoc) {
                throw new OutsideInException("No source file is open for operations");
            }
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
        this.setOptions(this.oil, this.m_hDoc, OptionImpl.OptionScopeValue.INPUT);
    }

    @Override
    public ObjectInfo getObjectInfo() throws OutsideInException {
        if (this.m_docType == DOCTYPE.OBJECT) {
            if (null == this.oil || !this.oil.isAlive()) {
                throw new OutsideInException("Failed to get object info. OILink process is not running.");
            }
            try {
                this.beforeProcess(this.m_srcInfo.m_documentOperationTimeout);
                OILinkMessages.DAGetObjectInfoResponse dAGetObjectInfoResponse = this.oil.DAGetObjectInfo(this.m_hDoc);
                if (dAGetObjectInfoResponse != null) {
                    ObjectInfo objectInfo = new ObjectInfo(dAGetObjectInfoResponse);
                    return objectInfo;
                }
            }
            catch (IOException iOException) {
                throw new OutsideInException(iOException.getMessage(), iOException);
            }
            finally {
                this.afterProcess();
            }
        }
        return null;
    }

    private void addHighlightProperties(OILinkMessages.Hilite.Builder builder, Map<String, String> map) {
        if (map != null) {
            for (String string : map.keySet()) {
                OILinkMessages.HiliteProperty.Builder builder2 = OILinkMessages.HiliteProperty.newBuilder().setName(string).setValue(map.get(string));
                builder.addProperties(builder2.build());
            }
        }
    }

    @Override
    public void addTextHighlight(HighlightTextAnnotation highlightTextAnnotation) {
        this.addTextHighlight(highlightTextAnnotation, null, null);
    }

    @Override
    public void addTextHighlight(HighlightTextAnnotation highlightTextAnnotation, String string) {
        this.addTextHighlight(highlightTextAnnotation, string, null);
    }

    @Override
    public void addTextHighlight(HighlightTextAnnotation highlightTextAnnotation, Map<String, String> map) {
        this.addTextHighlight(highlightTextAnnotation, null, map);
    }

    @Override
    public void addTextHighlight(HighlightTextAnnotation highlightTextAnnotation, String string, Map<String, String> map) {
        OILinkMessages.Hilite.Builder builder = OILinkMessages.Hilite.newBuilder();
        builder.setType(OILinkMessages.Hilite.HiliteType.TEXT);
        builder.setText(highlightTextAnnotation.getOILinkHiliteText());
        if (string != null) {
            builder.setCommentText(string);
        }
        this.addHighlightProperties(builder, map);
        this.m_srcInfo.m_hilites.add(builder.build());
    }

    @Override
    public void addAreaHighlight(HighlightAreaAnnotation highlightAreaAnnotation) {
        this.addAreaHighlight(highlightAreaAnnotation, null, null);
    }

    @Override
    public void addAreaHighlight(HighlightAreaAnnotation highlightAreaAnnotation, String string) {
        this.addAreaHighlight(highlightAreaAnnotation, string, null);
    }

    @Override
    public void addAreaHighlight(HighlightAreaAnnotation highlightAreaAnnotation, Map<String, String> map) {
        this.addAreaHighlight(highlightAreaAnnotation, null, map);
    }

    @Override
    public void addAreaHighlight(HighlightAreaAnnotation highlightAreaAnnotation, String string, Map<String, String> map) {
        OILinkMessages.Hilite.Builder builder = OILinkMessages.Hilite.newBuilder();
        builder.setType(OILinkMessages.Hilite.HiliteType.AREA);
        builder.setArea(highlightAreaAnnotation.getOILinkHiliteArea());
        if (string != null) {
            builder.setCommentText(string);
        }
        this.addHighlightProperties(builder, map);
        this.m_srcInfo.m_hilites.add(builder.build());
    }

    @Override
    public void addStampAnnotation(StampAnnotation stampAnnotation) {
        this.addStampAnnotation(stampAnnotation, null, null);
    }

    @Override
    public void addStampAnnotation(StampAnnotation stampAnnotation, String string) {
        this.addStampAnnotation(stampAnnotation, string, null);
    }

    @Override
    public void addStampAnnotation(StampAnnotation stampAnnotation, Map<String, String> map) {
        this.addStampAnnotation(stampAnnotation, null, map);
    }

    @Override
    public void addStampAnnotation(StampAnnotation stampAnnotation, String string, Map<String, String> map) {
        OILinkMessages.Hilite.Builder builder = OILinkMessages.Hilite.newBuilder();
        builder.setType(OILinkMessages.Hilite.HiliteType.STAMP);
        builder.setStamp(stampAnnotation.getOILinkHiliteStamp());
        if (string != null) {
            builder.setCommentText(string);
        }
        this.addHighlightProperties(builder, map);
        this.m_srcInfo.m_hilites.add(builder.build());
    }

    @Override
    public void addStampImageFile(Map<String, File> map) throws OutsideInException {
        this.verifyOILinkRunning();
        if (this.m_srcInfo.m_stampimages == null) {
            this.m_srcInfo.m_stampimages = new LinkedList<OILinkMessages.HiliteStampImage>();
        }
        for (String string : map.keySet()) {
            OILinkMessages.HiliteStampImage.Builder builder = OILinkMessages.HiliteStampImage.newBuilder();
            builder.setStampName(string);
            builder.setType(OILinkMessages.HiliteStampImage.HiliteStampImageType.FILE);
            try {
                FileToBasicIO fileToBasicIO = new FileToBasicIO(map.get(string), false);
                builder.setIoId(this.oil.getIoIdForFile(fileToBasicIO));
            }
            catch (IOException iOException) {
                throw new OutsideInException("Failed to set stamp image file for " + string + ": " + iOException.getMessage(), iOException);
            }
            this.m_srcInfo.m_stampimages.add(builder.build());
        }
    }

    @Override
    public void addStampImageURL(Map<String, URI> map) {
        if (this.m_srcInfo.m_stampimages == null) {
            this.m_srcInfo.m_stampimages = new LinkedList<OILinkMessages.HiliteStampImage>();
        }
        for (String string : map.keySet()) {
            OILinkMessages.HiliteStampImage.Builder builder = OILinkMessages.HiliteStampImage.newBuilder();
            builder.setStampName(string);
            builder.setType(OILinkMessages.HiliteStampImage.HiliteStampImageType.URL);
            builder.setUrl(map.get(string).toString());
            this.m_srcInfo.m_stampimages.add(builder.build());
        }
    }

    @Override
    public OptionsCache setDocumentOperationTimeout(int n) {
        this.m_srcInfo.m_documentOperationTimeout = n;
        this.m_cumulativeInfo.m_documentOperationTimeout = n;
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.DocumentOperationTimeoutOption);
        return this;
    }

    @Override
    public void applyHighlights(String string) {
        if (string != null) {
            if (null == this.m_srcInfo.m_highlightJsonDataList) {
                this.m_srcInfo.m_highlightJsonDataList = new LinkedList<String>();
            }
            this.m_srcInfo.m_highlightJsonDataList.add(string);
        }
    }

    @Override
    public void redactText(RedactAnnotation redactAnnotation) {
        if (this.m_srcInfo.m_redactions == null) {
            this.m_srcInfo.m_redactions = new LinkedList<RedactAnnotation>();
        }
        this.m_srcInfo.m_redactions.add(redactAnnotation);
    }

    protected void beforeProcess(long l) {
        if (this.m_processReferenceCounter == 0) {
            OILinkMonitor.beforeProcess(l);
        }
        ++this.m_processReferenceCounter;
    }

    protected void afterProcess() {
        --this.m_processReferenceCounter;
        if (this.m_processReferenceCounter == 0) {
            OILinkMonitor.afterProcess();
        }
    }

    static enum DOCTYPE {
        PARENTDOC,
        TREENODE,
        OBJECT,
        COPY,
        SUBDOC,
        UNKNOWN;

    }
}

