/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein;

import com.oracle.outsidein.Callback;
import com.oracle.outsidein.FileFormat;
import com.oracle.outsidein.SeekableByteChannel6;
import com.oracle.outsidein.SeekableByteChannel6ToBasicIO;
import java.io.File;
import java.io.IOException;
import net.bitform.oilink.OILinkCallback;
import net.bitform.oilink.OILinkMessages;

class OILinkCallbackHandler
extends OILinkCallback {
    Callback m_CBHandler = null;

    OILinkCallbackHandler(Callback callback) {
        this.m_CBHandler = callback;
    }

    @Override
    public OILinkCallback.CreateNewFileResponse createNewFile(int n, int n2, OILinkMessages.Association association, String string) throws IOException {
        if (null == this.m_CBHandler) {
            return null;
        }
        Callback.CreateNewFileResponse createNewFileResponse = this.m_CBHandler.createNewFile(FileFormat.forId(n), FileFormat.forId(n2), Callback.AssociationValue.forId(association.getNumber()), string);
        if (createNewFileResponse != null) {
            File file = createNewFileResponse.getSink();
            if (file != null) {
                return new OILinkCallback.CreateNewFileResponse((OILinkCallback)this, file, createNewFileResponse.getUrl());
            }
            return new OILinkCallback.CreateNewFileResponse((OILinkCallback)this, new SeekableByteChannel6ToBasicIO(createNewFileResponse.getRedirectedIO()), createNewFileResponse.getUrl());
        }
        return null;
    }

    @Override
    public void newFileInfo(int n, int n2, OILinkMessages.Association association, String string, String string2) throws IOException {
        if (null == this.m_CBHandler) {
            return;
        }
        this.m_CBHandler.newFileInfo(FileFormat.forId(n), FileFormat.forId(n2), Callback.AssociationValue.forId(association.getNumber()), string, string2);
    }

    @Override
    public OILinkCallback.OpenFileResponse openFile(OILinkMessages.OpenFileCallback.FileType fileType, String string) throws IOException {
        Callback.FileTypeValue fileTypeValue;
        if (null == this.m_CBHandler) {
            return null;
        }
        switch (fileType) {
            default: {
                fileTypeValue = Callback.FileTypeValue.INPUT;
                break;
            }
            case TEMPLATE: {
                fileTypeValue = Callback.FileTypeValue.TEMPLATE;
                break;
            }
            case OTHER: {
                fileTypeValue = Callback.FileTypeValue.OTHER;
                break;
            }
            case PATH: {
                fileTypeValue = Callback.FileTypeValue.PATH;
            }
        }
        Callback.OpenFileResponse openFileResponse = this.m_CBHandler.openFile(fileTypeValue, string);
        if (openFileResponse != null) {
            SeekableByteChannel6 seekableByteChannel6 = openFileResponse.getRedirectedIO();
            if (seekableByteChannel6 != null) {
                return new OILinkCallback.OpenFileResponse((OILinkCallback)this, new SeekableByteChannel6ToBasicIO(seekableByteChannel6));
            }
            return new OILinkCallback.OpenFileResponse((OILinkCallback)this, openFileResponse.getSink());
        }
        return null;
    }

    @Override
    public OILinkMessages.MarginText newPageResponse(long l) {
        if (null == this.m_CBHandler) {
            return null;
        }
        Callback.NewPageResponse newPageResponse = this.m_CBHandler.prepareNewPage(l);
        if (null == newPageResponse) {
            return null;
        }
        return newPageResponse.getMarginTextGPBData();
    }

    @Override
    public void pageInfoSlideNotes(long l, String[] stringArray) {
        if (this.m_CBHandler != null) {
            this.m_CBHandler.pageInfoSlideNotes(l, stringArray);
        }
    }

    @Override
    public void pageInfoVisibility(long l, Boolean bl) {
        if (this.m_CBHandler != null) {
            this.m_CBHandler.pageInfoVisibility(l, bl);
        }
    }

    @Override
    public OILinkCallback.CreateTempFileResponse createTempFile() throws IOException {
        SeekableByteChannel6 seekableByteChannel6;
        if (null == this.m_CBHandler) {
            return null;
        }
        Callback.CreateTempFileResponse createTempFileResponse = this.m_CBHandler.createTempFile();
        if (createTempFileResponse != null && (seekableByteChannel6 = createTempFileResponse.getRedirectedIO()) != null) {
            return new OILinkCallback.CreateTempFileResponse(this, new SeekableByteChannel6ToBasicIO(seekableByteChannel6));
        }
        return null;
    }

    @Override
    public void pageHasRedaction(long l) {
        if (this.m_CBHandler != null) {
            this.m_CBHandler.pageHasRedaction(l);
        }
    }
}

