

#define RTOS_EVID_MAX 68


#define RTOS_EVID_STR_FMT { \
/* 0x0000 */{"misc.c", "misc_init_must_be_in_tcm", 1914, "cpu freq %d Mhz, nand freq %d Mhz\n",},\
/* 0x0001 */{"misc.c", "pcie_check_compliance", 1019, "c ltssm %x app %x",},\
/* 0x0002 */{"misc.c", "pcie_link_enable", 1222, "LTSSM enable ltssm %x",},\
/* 0x0003 */{"misc.c", "pcie_ltssm_debug", 854, "LTSSM 0x58 %x 0x5c %x 0x60 %x",},\
/* 0x0004 */{"misc.c", "power_evt_handler", 720, "power drop %x",},\
/* 0x0005 */{"misc.c", "power_isr", 680, "power drop %x",},\
/* 0x0006 */{"misc.c", "power_isr", 691, "start power lost activities",},\
/* 0x0007 */{"misc.c", "power_isr", 694, "could not start power lost activities",},\
/* 0x0008 */{"misc.c", "preset_n_isr", 1382, "prest enter ltssm %x app %x",},\
/* 0x0009 */{"misc.c", "preset_n_isr", 1416, "exit ltssm %x app %x",},\
/* 0x000a */{"misc.c", "program_otp_data", 2093, "otp prog_done not clean.",},\
/* 0x000b */{"misc.c", "program_otp_data", 2139, "otp prog data offset %x fail, act/exp[%x/%x]",},\
/* 0x000c */{"misc.c", "program_otp_data", 2142, "otp prog data offset %x pass, act/org[%x/%x]",},\
/* 0x000d */{"misc.c", "read_otp_data", 2029, "otp prog_done not clean.",},\
/* 0x000e */{"misc.c", "uart_cmd_save_pub_key", 2196, "digest_no %d pub key is: %s",},\
/* 0x000f */{"pmu.c", "pmu_enter", 328, "PMU suspend failed %d.",},\
/* 0x0010 */{"pmu.c", "pmu_enter", 344, "PMU suspend Abort(%x).",},\
/* 0x0011 */{"pmu.c", "pmu_enter", 388, "PMU resume: sts 0x%x, cnt(%d)",},\
/* 0x0012 */{"pmu.c", "pmu_mode", 294, "%s:94(0x%x), 98(0x%x), 80(0x%x))",},\
/* 0x0013 */{"pmu.c", "pmu_mode", 301, "(M) -> 32'h94(0x%x), 32'h98(0x%x)",},\
/* 0x0014 */{"thermal.c", "thermal_throttle", 143, "thermal throttle %d -> %d",},\
/* 0x0015 */{"thermal.c", "thermal_throttle", 243, " CPU clk %d, NF clk %d, ECC clk %d",},\
/* 0x0016 */{"thermal.c", "ts_get", 498, "negative temp %d, cur_ts %d, ts_int.all %d ",},\
/* 0x0017 */{"thermal.c", "ts_isr", 329, "%x ts_dout = 0x%x %d degree",},\
/* 0x0018 */{"thermal.c", "ts_setup", 419, "thermal throttle restore",},\
/* 0x0019 */{"task.c", "task_ev_block", 226, "ts=%x,%d, count=%d, event=%p",},\
/* 0x001a */{"task.c", "task_ev_block", 242, "ts=%x,%d, count=%d, event=%p",},\
/* 0x001b */{"task.c", "task_ev_wake", 263, "ts=%x,%d, event=%p,%p",},\
/* 0x001c */{"task.c", "task_ev_wake", 276, "ts=%x,%d, count=%d",},\
/* 0x001d */{"task.c", "task_init", 58, "ts=%x,%d, stack=%x, size=%d",},\
/* 0x001e */{"task.c", "task_new", 96, "ts=%x,%d, stack=%x, size=%d",},\
/* 0x001f */{"task.c", "task_sleep", 207, "ts=%x,%d, ticks=%d, count=%d",},\
/* 0x0020 */{"task.c", "task_sleep", 218, "ts=%x,%d, ticks=%d, count=%d",},\
/* 0x0021 */{"irq.c", "_do_irq", 45, "irq with no source %x",},\
/* 0x0022 */{"rtos.c", "assert_panic", 159, "ASSERT: %s %d",},\
/* 0x0023 */{"rtos.c", "do_panic", 51, "panic %x\n",},\
/* 0x0024 */{"rtos.c", "exception_handler", 76, "===> Kernel CRASH!!!",},\
/* 0x0025 */{"rtos.c", "panic", 142, "...",},\
/* 0x0026 */{"rtos.c", "panic", 144, "(%s)",},\
/* 0x0027 */{"rtos.c", "sys_mem_init", 302, "%d: size=%d, start=0x%x",},\
/* 0x0028 */{"fsm.c", "_fsm_ctx_run", 74, "ctx %p, state %s(%d)",},\
/* 0x0029 */{"fsm.c", "_fsm_ctx_run", 77, "ctx %p, state %s(%d), res %d",},\
/* 0x002a */{"fsm.c", "fsm_ctx_init", 37, "ctx %p, state %p",},\
/* 0x002b */{"fsm.c", "fsm_queue_insert_head", 120, "fsm %p, ctx %p",},\
/* 0x002c */{"fsm.c", "fsm_queue_insert_tail", 126, "fsm %p, ctx %p",},\
/* 0x002d */{"fsm.c", "fsm_queue_remove_first", 137, "fsm %p, ctx %p",},\
/* 0x002e */{"fsm.c", "fsm_queue_remove_last", 148, "fsm %p, ctx %p",},\
/* 0x002f */{"fsm.c", "fsm_queue_run", 157, "fsm %p",},\
/* 0x0030 */{"pool.c", "pool_check_free", 47, "pl %p, e %p, %x/%x",},\
/* 0x0031 */{"pool.c", "pool_get", 107, "pl %p, e %p, next %p",},\
/* 0x0032 */{"pool.c", "pool_init", 66, "pl %p, base %p, size %d, esize %d, enum %d",},\
/* 0x0033 */{"pool.c", "pool_put", 123, "pl %p, base %p, end %p, %p",},\
/* 0x0034 */{"pool.c", "pool_put", 143, "pl %p, e %p, next %p",},\
/* 0x0035 */{"event.c", "evt_delay_resume", 163, "evt act %d",},\
/* 0x0036 */{"event.c", "evt_register", 75, "handler=%x, param=%x, index=%d",},\
/* 0x0037 */{"event.c", "evt_register", 79, "evt reg fail! handler=%x",},\
/* 0x0038 */{"event.c", "evt_set_cs", 127, "cookie error %d/%d",},\
/* 0x0039 */{"event.c", "evt_set_delay", 177, "evt delay %d %d",},\
/* 0x003a */{"event.c", "evt_task", 261, "evt_task spun for 10000 iterations, nr %d",},\
/* 0x003b */{"tmp102.c", "tmp102_init", 61, "smb_intr_sts: %x",},\
/* 0x003c */{"tmp102.c", "tmp102_read", 125, "TMP102 set ...",},\
/* 0x003d */{"tmp102.c", "tmp102_read", 146, "smb_intr_sts %x",},\
/* 0x003e */{"tmp102.c", "tmp102_read", 156, "TMP102 get ...",},\
/* 0x003f */{"tmp102.c", "tmp102_read", 159, "Data0: %x",},\
/* 0x0040 */{"tmp102.c", "tmp102_read", 161, "Data1: %x",},\
/* 0x0041 */{"tmp102.c", "tmp102_read", 166, "Temperature: %d c",},\
/* 0x0042 */{"stat_head.c", "stat_restore", 39, "new %x stat, sig %x error",},\
/* 0x0043 */{"stat_head.c", "stat_restore", 42, "src is NULL",},\
/* 0x0044 */{"stat_head.c", "stat_restore", 55, "stat %x upg %d(%d) -> %d(%d)",},\
};


#define FTL_EVID_MAX 582


#define FTL_EVID_STR_FMT { \
/* 0x0000 */{"defect_mgr.c", "defect_remap_rebuild", 239, "remap pair %d spb %d all defect",},\
/* 0x0001 */{"defect_mgr.c", "defect_remap_rebuild", 250, "rebuld %d remap pair",},\
/* 0x0002 */{"defect_mgr.c", "defect_version_check", 360, "defect version %d - %d (%d)",},\
/* 0x0003 */{"defect_mgr.c", "ftl_build_remap", 293, "no remap with intlv %d",},\
/* 0x0004 */{"defect_mgr.c", "ftl_build_remap", 335, "total %d remapped spb",},\
/* 0x0005 */{"defect_mgr.c", "ftl_defect_prune_for_mp", 839, "mp mask %x",},\
/* 0x0006 */{"defect_mgr.c", "ftl_drop_partial", 221, "total %d physical block drop",},\
/* 0x0007 */{"defect_mgr.c", "ftl_init_defect", 473, "Load Aging Defect Map Fail",},\
/* 0x0008 */{"defect_mgr.c", "ftl_scan_defect", 716, "partial defect SPB %d,",},\
/* 0x0009 */{"defect_mgr.c", "ftl_scan_defect", 720, " %x",},\
/* 0x000a */{"defect_mgr.c", "ins_grwn_err_info", 517, "grown defect multiple error %x %x",},\
/* 0x000b */{"defect_mgr.c", "ins_grwn_err_info", 524, "grown defect insert list fail %x %x",},\
/* 0x000c */{"defect_mgr.c", "remap_dump_main", 894, "f %x cnt %d itlv %d",},\
/* 0x000d */{"defect_mgr.c", "remap_dump_main", 923, "Interleave error \n",},\
/* 0x000e */{"defect_mgr.c", "spb_set_defect_blk", 597, "mark spb %d grown defect %x",},\
/* 0x000f */{"defect_mgr.c", "spb_set_defect_blk", 624, "search spb %d miss",},\
/* 0x0010 */{"format.c", "ftl_format", 68, "ftl format type %d",},\
/* 0x0011 */{"format.c", "ftl_format_done", 132, "ftl format done",},\
/* 0x0012 */{"ftl.c", "_ftl_put_req", 328, "ftl req 2s (%dms) id:0x%x op:0x%x, lda cnt:%d",},\
/* 0x0013 */{"ftl.c", "ftl_dbg_main", 1608, "trigger pool %d GC",},\
/* 0x0014 */{"ftl.c", "ftl_dbg_main", 1619, "no support",},\
/* 0x0015 */{"ftl.c", "ftl_dump", 1570, "fcmd %d",},\
/* 0x0016 */{"ftl.c", "ftl_flush_io_block", 631, "IO Block FTL flush start",},\
/* 0x0017 */{"ftl.c", "ftl_flush_io_block", 634, "ftl busy",},\
/* 0x0018 */{"ftl.c", "ftl_flush_io_block", 643, "IO Block FTL flush submit",},\
/* 0x0019 */{"ftl.c", "ftl_flush_io_block", 646, "IO Block FTL flush end",},\
/* 0x001a */{"ftl.c", "ftl_flush_pwr_loss", 658, "Power loss FTL flush start",},\
/* 0x001b */{"ftl.c", "ftl_flush_pwr_loss", 661, "ftl busy",},\
/* 0x001c */{"ftl.c", "ftl_flush_pwr_loss", 668, "Power loss FTL flush submit",},\
/* 0x001d */{"ftl.c", "ftl_flush_pwr_loss", 671, "Power loss FTL flush end",},\
/* 0x001e */{"ftl.c", "ftl_init", 981, "ftl init end %d",},\
/* 0x001f */{"ftl.c", "ftl_io_block_flush_cmpl", 502, "ftl flush completed",},\
/* 0x0020 */{"ftl.c", "ftl_io_block_flush_cmpl", 505, "dfs_flush() completed",},\
/* 0x0021 */{"ftl.c", "ftl_io_block_flush_cmpl", 508, "evlog_flush() completed",},\
/* 0x0022 */{"ftl.c", "ftl_is_busy", 572, "pmu flush",},\
/* 0x0023 */{"ftl.c", "ftl_pmu_flush_cmpl", 519, "ftl flush completed",},\
/* 0x0024 */{"ftl.c", "ftl_pmu_flush_cmpl", 522, "dfs_flush() completed",},\
/* 0x0025 */{"ftl.c", "ftl_pmu_flush_cmpl", 525, "evlog_flush() completed",},\
/* 0x0026 */{"ftl.c", "ftl_req_dump", 1740, "req id:0x%x k:%d ctag %d dtag %d off %d",},\
/* 0x0027 */{"ftl.c", "ftl_req_dump", 1747, "req id:0x%x k:%d ctag %d dtag %d off %d",},\
/* 0x0028 */{"ftl.c", "ftl_req_init", 1415, "max FTL req %d %d",},\
/* 0x0029 */{"ftl.c", "ftl_req_init", 1442, "meta size %d",},\
/* 0x002a */{"ftl.c", "ftl_req_status_dump", 1543, "ftl req free %d, simple free %d",},\
/* 0x002b */{"ftl.c", "ftl_req_status_dump", 1545, "ftl req hook bmp %x",},\
/* 0x002c */{"ftl.c", "ftl_shrink_capacity", 1506, "total du %d, disk_size_in_du %d",},\
/* 0x002d */{"ftl.c", "ftl_shrink_capacity", 1514, "disk_size_in_gb %d %d",},\
/* 0x002e */{"ftl.c", "ftl_spb_pool_init", 1248, "user spare %d slc req %d min %d",},\
/* 0x002f */{"ftl.c", "ftl_spb_pool_init", 1384, "pool %d type %d cnt %d/%d/%d ls %d",},\
/* 0x0030 */{"ftl.c", "ftl_spb_pool_init", 1390, "user pool %d, - GC(thr) (%d/%d/%d)",},\
/* 0x0031 */{"ftl.c", "ftl_spb_pool_init", 1394, "user pool %d, blk (%d/%d)",},\
/* 0x0032 */{"ftl.c", "ftl_spb_pool_init", 1401, "user pool 3, user_real_blk (%d)",},\
/* 0x0033 */{"ftl.c", "ftl_start", 476, "ftl start end, stop",},\
/* 0x0034 */{"ftl.c", "get_spare_cnt", 1129, "no max spare record",},\
/* 0x0035 */{"ftl.c", "user_write_timer_handler", 1791, "timer",},\
/* 0x0036 */{"ftl_dbg.c", "ftl_dbg_main", 750, "trigger pool %d GC",},\
/* 0x0037 */{"ftl_dbg.c", "ftl_dbg_main", 758, "weak gc %d->%d",},\
/* 0x0038 */{"ftl_dbg.c", "ftl_dbg_main", 768, "disturb gc %d->%d",},\
/* 0x0039 */{"ftl_dbg.c", "ftl_dbg_main", 778, "idle apst disable %d->%d",},\
/* 0x003a */{"ftl_dbg.c", "ftl_dbg_main", 807, "no support",},\
/* 0x003b */{"internal_ctx.c", "_internal_ctx_get", 136, "need %d but %d",},\
/* 0x003c */{"internal_ctx.c", "internal_ctx_set_pending_ils", 199, "ictx pend %d",},\
/* 0x003d */{"page_allocator.c", "page_allocator_active_spb_setup", 342, "setup pga %d[%d] spb %d %d-%d",},\
/* 0x003e */{"page_allocator.c", "page_allocator_close", 242, "not idle aspb %d %d %d",},\
/* 0x003f */{"page_allocator.c", "page_allocator_close", 248, "close aspb %d %d",},\
/* 0x0040 */{"page_allocator.c", "page_allocator_close_aspb", 475, "wait rsvd IO aspb %d",},\
/* 0x0041 */{"page_allocator.c", "page_allocator_close_aspb", 485, "RR force close %d",},\
/* 0x0042 */{"page_allocator.c", "page_allocator_close_aspb", 492, "wait %d idle",},\
/* 0x0043 */{"page_allocator.c", "page_allocator_dump", 555, "pga %d avl_cnt %d cur_slot %d f %x",},\
/* 0x0044 */{"page_allocator.c", "page_allocator_dump", 560, "spb[%d] w_ptr %d compl_cnt %d",},\
/* 0x0045 */{"page_allocator.c", "page_allocator_dump", 564, " id %d state %d f %x",},\
/* 0x0046 */{"spb_info.c", "spb_info_dump", 134, "%d e %d f %x p %d d %x %x",},\
/* 0x0047 */{"spb_info.c", "spb_info_dump", 153, "Pool %d avg %d max %d min %d",},\
/* 0x0048 */{"spb_info.c", "spb_info_dump_main", 168, "Invalid SPB id, range [0-%d]",},\
/* 0x0049 */{"user_ls.c", "user_valid_chk", 1303, "no mem",},\
/* 0x004a */{"user_ls.c", "user_valid_chk", 1323, "no mem to acc valid",},\
/* 0x004b */{"user_ls.c", "user_valid_chk", 1330, "scan issued",},\
/* 0x004c */{"user_ls.c", "valid_acc_done", 1259, "scan done",},\
/* 0x004d */{"wait.c", "wait_release", 78, "mutex resume %p",},\
/* 0x004e */{"gc.c", "gc_submit", 485, "gc_submit pool %d B/F?%x",},\
/* 0x004f */{"gc.c", "gc_submit", 488, "gc_submit",},\
/* 0x0050 */{"spb_manager.c", "chk_spb_status", 941, "good %d remap %d partial %d(%d) zombie %d",},\
/* 0x0051 */{"spb_manager.c", "spb_alloc_desc_flush", 2444, "spb alloc wait spb %d %d",},\
/* 0x0052 */{"spb_manager.c", "spb_alloc_desc_flush", 2476, "dangerous tlc %d big ec %d!!!",},\
/* 0x0053 */{"spb_manager.c", "spb_allocation_handler", 1303, "no spb for %d",},\
/* 0x0054 */{"spb_manager.c", "spb_allocation_handler", 1319, "fire erase cmd %d,ls %d",},\
/* 0x0055 */{"spb_manager.c", "spb_appl_dump", 2647, "qta:%d f:%x slc_p_id:%d nat_p_id:%d",},\
/* 0x0056 */{"spb_manager.c", "spb_appl_get_spb", 2188, "force cpbk to release xlc %d %d %d %d ret %d",},\
/* 0x0057 */{"spb_manager.c", "spb_appl_get_spb", 2202, "pool %d blk",},\
/* 0x0058 */{"spb_manager.c", "spb_appl_get_spb", 2225, "can %d busy",},\
/* 0x0059 */{"spb_manager.c", "spb_appl_get_spb", 2244, "pool %d blk",},\
/* 0x005a */{"spb_manager.c", "spb_appl_get_spb", 2249, "no SPB but must have, set read-only disk",},\
/* 0x005b */{"spb_manager.c", "spb_appl_get_spb", 2257, "pop pool %d spb %d free %d (%d %d)",},\
/* 0x005c */{"spb_manager.c", "spb_appl_get_spb", 2298, "pool %d blk",},\
/* 0x005d */{"spb_manager.c", "spb_appl_get_spb", 2317, "pool %d blk",},\
/* 0x005e */{"spb_manager.c", "spb_appl_get_spb", 2321, "no SPB but must have, set read-only disk",},\
/* 0x005f */{"spb_manager.c", "spb_appl_get_spb", 2330, "can %d busy",},\
/* 0x0060 */{"spb_manager.c", "spb_appl_get_spb", 2359, "pool %d blk",},\
/* 0x0061 */{"spb_manager.c", "spb_appl_get_spb", 2363, "no SPB but must have, set read-only disk",},\
/* 0x0062 */{"spb_manager.c", "spb_appl_get_spb", 2372, "appl id %d pool %d spb 0x%x free %d is_slc:%d ls %d",},\
/* 0x0063 */{"spb_manager.c", "spb_appl_register", 441, "ls %d link slc %d native %d",},\
/* 0x0064 */{"spb_manager.c", "spb_arrange_spb_to_pool", 1028, "pool %d, cap blk %d/%d ttl %d",},\
/* 0x0065 */{"spb_manager.c", "spb_arrange_spb_to_pool", 987, "skip spb %d-%d",},\
/* 0x0066 */{"spb_manager.c", "spb_arrange_spb_to_pool", 991, "skip spb %d remap",},\
/* 0x0067 */{"spb_manager.c", "spb_arrange_spb_to_pool", 995, "spb %d erase %d",},\
/* 0x0068 */{"spb_manager.c", "spb_chk_pool_gc", 1246, "GC %d %d trigger pool[%d] free %d",},\
/* 0x0069 */{"spb_manager.c", "spb_chk_set_read_only", 1922, "1: disk is read only. %d %d %d",},\
/* 0x006a */{"spb_manager.c", "spb_chk_set_read_only", 1932, "3: disk is read only. %d %d %d",},\
/* 0x006b */{"spb_manager.c", "spb_desc_flush_wait", 2401, "spb flush resume %d %d",},\
/* 0x006c */{"spb_manager.c", "spb_dump_main", 2846, " Inv SPB number, range [0-%d]",},\
/* 0x006d */{"spb_manager.c", "spb_manager_init", 795, "SPB cnt = %d",},\
/* 0x006e */{"spb_manager.c", "spb_manager_start", 822, "sys log spb %x flag %x",},\
/* 0x006f */{"spb_manager.c", "spb_manager_start", 830, "spb log spb %x flag %x",},\
/* 0x0070 */{"spb_manager.c", "spb_manager_start", 876, "a busy SPB was retired %d f %x",},\
/* 0x0071 */{"spb_manager.c", "spb_manager_start", 896, "pool %d free cnt %d ttl %d",},\
/* 0x0072 */{"spb_manager.c", "spb_manager_start", 900, "user slc pool free %d %d switch %d",},\
/* 0x0073 */{"spb_manager.c", "spb_meta_dump", 2676, "SPB %d D:%x %x cnt:%d",},\
/* 0x0074 */{"spb_manager.c", "spb_meta_dump", 2681, "get dtag error!",},\
/* 0x0075 */{"spb_manager.c", "spb_meta_dump", 2696, "type:%s du_cnt:%d",},\
/* 0x0076 */{"spb_manager.c", "spb_meta_dump", 2699, "from %d cnt %d",},\
/* 0x0077 */{"spb_manager.c", "spb_meta_dump", 2718, "%x is defect",},\
/* 0x0078 */{"spb_manager.c", "spb_meta_dump", 2722, "[%x](%x) %x %x %x",},\
/* 0x0079 */{"spb_manager.c", "spb_mgr_dump", 2625, "spb_cnt : %d",},\
/* 0x007a */{"spb_manager.c", "spb_mgr_dump", 2630, "tb[%d] f %x va_cnt %d r_cnt %d ls_id %d sn %x",},\
/* 0x007b */{"spb_manager.c", "spb_mgr_dump", 2636, "pool %d free %d ",},\
/* 0x007c */{"spb_manager.c", "spb_mgr_dump", 2640, "f %x cookies %d",},\
/* 0x007d */{"spb_manager.c", "spb_pool_gc_thr_merge", 1285, "pool %d - %d/%d/%d",},\
/* 0x007e */{"spb_manager.c", "spb_pool_recycle", 1767, "GC %d %d trigger pool[%d] free %d",},\
/* 0x007f */{"spb_manager.c", "spb_pool_recycle", 1784, "no GC req flag[%x], pool[%d]",},\
/* 0x0080 */{"spb_manager.c", "spb_pool_recycle", 1793, "pool(%d) no GC candidate min(%d)",},\
/* 0x0081 */{"spb_manager.c", "spb_pool_recycle_done", 1643, "STOP cont. GC pool %d flag %x",},\
/* 0x0082 */{"spb_manager.c", "spb_read_disturb_gc_done", 614, "no gc_req",},\
/* 0x0083 */{"spb_manager.c", "spb_read_disturb_gc_done", 618, "Read retention GC done %d",},\
/* 0x0084 */{"spb_manager.c", "spb_read_disturb_gc_done", 660, "ls not match %d %d",},\
/* 0x0085 */{"spb_manager.c", "spb_read_disturb_gc_trigger", 681, "no gc by shutdown",},\
/* 0x0086 */{"spb_manager.c", "spb_read_disturb_gc_trigger", 689, "SPB %d is doing copyback",},\
/* 0x0087 */{"spb_manager.c", "spb_read_disturb_gc_trigger", 706, "Now RD gc %d",},\
/* 0x0088 */{"spb_manager.c", "spb_rel_chk", 381, "spb rel chk %d",},\
/* 0x0089 */{"spb_manager.c", "spb_release", 454, "release SPB %d(%d) %x",},\
/* 0x008a */{"spb_manager.c", "spb_retire", 1947, "spb %d already retired",},\
/* 0x008b */{"spb_manager.c", "spb_retire", 1966, "spb retired %d pool %d blk %d, spb %d",},\
/* 0x008c */{"spb_manager.c", "spb_set_retire", 1870, "mark spb %d retire type %d",},\
/* 0x008d */{"spb_manager.c", "spb_set_weak", 1894, "mark read weak spb %d, retire %d",},\
/* 0x008e */{"spb_manager.c", "spb_valid_cnt_change", 545, "reset rd fail spb 0x%x vc to 1",},\
/* 0x008f */{"spb_manager.c", "spb_valid_cnt_change", 550, "vcnt err spb %d %d - %d",},\
/* 0x0090 */{"spb_manager.c", "spb_valid_cnt_reset", 497, "SPB %d v %d -> %d",},\
/* 0x0091 */{"spb_manager.c", "spb_valid_cnt_reset", 504, "F %x",},\
/* 0x0092 */{"spb_manager.c", "spb_valid_cnt_set", 518, "spb %d v %d -> %d",},\
/* 0x0093 */{"spb_manager.c", "spb_weak_xlc_gc_done", 1806, "weak xlc recycle done spb %d",},\
/* 0x0094 */{"spb_manager.c", "spb_weak_xlc_gc_trigger", 1856, "trigger weak xlc recycle spb %d pool %d",},\
/* 0x0095 */{"spb_manager.c", "spb_wear_level", 2048, "WL trigger, used epc min %d(%d), max %d(%d)",},\
/* 0x0096 */{"spb_manager.c", "spb_wear_level", 2051, "WL trigger, free epc min %d(%d), max %d(%d)",},\
/* 0x0097 */{"spb_manager.c", "spb_wear_level", 2065, "WL spb %d, epc %d, vc %d",},\
/* 0x0098 */{"convert.c", "cfsm_completion_flush", 499, "cfsm wait flush",},\
/* 0x0099 */{"ftl.c", "ftl_init", 967, "After shrink User disk: %d GB",},\
/* 0x009a */{"internal_ls.c", "internal_ls_desc_flush", 204, ">> spb %d %d %d",},\
/* 0x009b */{"internal_ls.c", "internal_ls_desc_flush", 208, "[%d] set spb %d, w %d f %d",},\
/* 0x009c */{"internal_ls.c", "internal_ls_dump", 379, "sn %d",},\
/* 0x009d */{"internal_ls.c", "internal_ls_dump", 381, " appl spd_id:%d quota:%d f:%x",},\
/* 0x009e */{"internal_ls.c", "internal_ls_dump", 386, " ls_id:%d slc_pool_id:%d nat_pool_id:%d",},\
/* 0x009f */{"internal_ls.c", "internal_ls_recovery_ready_spb", 336, "ls %d ready SPB %d, active %d %d",},\
/* 0x00a0 */{"internal_ls.c", "internal_ls_recovery_ready_spb", 354, "update inv_slot %d",},\
/* 0x00a1 */{"logical_space.c", "get_user_disk_sz", 288, "User disk: %d GB, lda %d",},\
/* 0x00a2 */{"logical_space.c", "logical_space_init", 88, "ls %d init capacity = %x",},\
/* 0x00a3 */{"logical_space.c", "logical_spaces_start", 208, "open system",},\
/* 0x00a4 */{"logical_space.c", "logical_spaces_start", 212, "system opened",},\
/* 0x00a5 */{"logical_space.c", "ls_dump", 336, "id %d io_blk_f %x cap %d f %x",},\
/* 0x00a6 */{"logical_space.c", "ls_dump", 343, "id:%d op:%d ctx:%d f:%d",},\
/* 0x00a7 */{"logical_space.c", "ls_dump", 346, " lrange type:%d, list_len:%d lda_cnt:%d",},\
/* 0x00a8 */{"logical_space.c", "ls_dump", 358, "slba[%d]%x%x cnt:%x",},\
/* 0x00a9 */{"logical_space.c", "ls_dump", 363, "lda[%d]:%x",},\
/* 0x00aa */{"logical_space.c", "ls_dump", 367, "lda:%x",},\
/* 0x00ab */{"logical_space.c", "ls_dump", 373, " gc spd_id %d ls_id %d",},\
/* 0x00ac */{"logical_space.c", "ls_dump", 375, " prior %d f %x",},\
/* 0x00ad */{"logical_space.c", "ls_dump_main", 395, "ls id invalid 0:user, 1:middle, 2:system",},\
/* 0x00ae */{"logical_space.c", "ls_make_dirty", 302, "make ls %d dirty",},\
/* 0x00af */{"logical_space.c", "ls_make_dirty_done", 322, "ls %d is dirty",},\
/* 0x00b0 */{"middle_ls.c", "middle_ls_reconstruction", 292, "mid sn %d",},\
/* 0x00b1 */{"middle_ls.c", "middle_ls_start", 179, "middle ls rebuild end",},\
/* 0x00b2 */{"system_ls.c", "system_critical_gc", 184, "sys cri GC %d st %d",},\
/* 0x00b3 */{"system_ls.c", "system_ls_reconstruction", 326, "system sn %d",},\
/* 0x00b4 */{"system_ls.c", "system_ls_start", 174, "system ls rebuild end",},\
/* 0x00b5 */{"user_ls.c", "user_convert_done", 973, "remove %d - %d %d",},\
/* 0x00b6 */{"user_ls.c", "user_convert_done_notify", 910, "cvrt done->%d-%d spb %d(%d)",},\
/* 0x00b7 */{"user_ls.c", "user_ls_dump", 1190, "sn %d f %x fc.gc.perf %d",},\
/* 0x00b8 */{"user_ls.c", "user_ls_dump", 1200, "aspb[%d][0] id %d fence %d p %d",},\
/* 0x00b9 */{"user_ls.c", "user_ls_dump", 1204, "aspb[%d][1] id %d fence %d p %d",},\
/* 0x00ba */{"user_ls.c", "user_ls_dump", 1208, "rdy_spb[%d]:%d",},\
/* 0x00bb */{"user_ls.c", "user_ls_spb_allocator", 569, "alloc %d for [%d][%d]",},\
/* 0x00bc */{"user_ls.c", "user_ls_start", 346, "spb id:0x%x fence:0x%x wr ptr:0x%x",},\
/* 0x00bd */{"user_ls.c", "user_ls_start", 350, "spb id:0x%x fence:0x%x wr ptr:0x%x",},\
/* 0x00be */{"user_ls.c", "user_ls_start", 354, "spb id:0x%x fence:0x%x wr ptr:0x%x",},\
/* 0x00bf */{"user_ls.c", "user_ls_start", 358, "spb id:0x%x fence:0x%x wr ptr:0x%x",},\
/* 0x00c0 */{"user_ls.c", "user_ls_start", 362, "sn:0x%x flag:0x%x ready spb:0x%x 0x%x",},\
/* 0x00c1 */{"user_ls.c", "user_ls_start", 367, "trim lba:0x%x count:0x%x range idx:0x%x sn:0x%x",},\
/* 0x00c2 */{"user_ls.c", "user_ls_start", 372, "trim lba:0x%x count:0x%x range idx:0x%x sn:0x%x",},\
/* 0x00c3 */{"user_ls.c", "user_ls_start", 403, "user rebuild start",},\
/* 0x00c4 */{"user_ls.c", "user_ls_start", 405, "user rebuild end",},\
/* 0x00c5 */{"user_ls_recon.c", "user_ls_reconstruction", 257, "user sn %d",},\
/* 0x00c6 */{"user_ls_recon.c", "user_recon_insert_map", 369, "lda %d skip %x by %x",},\
/* 0x00c7 */{"user_ls_trim.c", "user_trim_recon", 1397, "user sn %d",},\
/* 0x00c8 */{"lut.c", "l2pp_fast_load_done", 1279, "fast op %p aborted",},\
/* 0x00c9 */{"lut.c", "l2pp_load_done", 1197, "lut %d l2pp %d aborted",},\
/* 0x00ca */{"lut.c", "l2pp_single_load_done", 1335, "lut %d s l2pp %d",},\
/* 0x00cb */{"lut.c", "lut_dump", 913, "ap_id %d f %x fl_cmd_c %d l_c_c %d t_id %d",},\
/* 0x00cc */{"lut.c", "lut_fast_transaction_id_check", 481, "tid too old %d, %d",},\
/* 0x00cd */{"lut.c", "lut_l2pp_recycle", 887, "lut %d locked",},\
/* 0x00ce */{"lut.c", "lut_load_l2pps", 1073, "no mem to load l2pp %d",},\
/* 0x00cf */{"lut.c", "lut_op_push", 991, "lut %d op push load %d, again %d",},\
/* 0x00d0 */{"lut.c", "lut_save_l2pps", 1518, "no ctx to flush l2pp",},\
/* 0x00d1 */{"lut.c", "lut_scan", 372, "to be scanned count %d, idx %d",},\
/* 0x00d2 */{"lut.c", "lut_scan_lists", 832, "lut scan %d/%d",},\
/* 0x00d3 */{"lut.c", "lut_scan_load", 739, "scan load %d %x",},\
/* 0x00d4 */{"lut.c", "lut_single_lookup_list", 654, "pend to single l2pp %d",},\
/* 0x00d5 */{"lut.c", "lut_single_lookup_list", 701, "pend single %p",},\
/* 0x00d6 */{"lut.c", "lut_transaction_id_check", 500, "tid too old %d, %d",},\
/* 0x00d7 */{"lut.c", "lut_transaction_id_check", 512, "[%d] %x from umt",},\
/* 0x00d8 */{"lut.c", "lut_transaction_id_check", 542, "[%d] %x from hmb",},\
/* 0x00d9 */{"lut.c", "lut_update_lists", 1381, "update blocked",},\
/* 0x00da */{"lut_cache.c", "lut_cache_clr_low_wm", 222, "set lut cahce high wm %d",},\
/* 0x00db */{"lut_cache.c", "lut_cache_gc_urgt", 527, "Recycle dirty lut to meet demands",},\
/* 0x00dc */{"lut_cache.c", "lut_cache_set_low_wm", 216, "set lut cahce low wm %d",},\
/* 0x00dd */{"ftl.c", "ftl_mapping_chk", 438, "L %x errPDA",},\
/* 0x00de */{"erase.c", "erase_err_handling", 137, "erase err %x %x",},\
/* 0x00df */{"read.c", "read_err_handling", 101, "page %d, type %d, flags: ncl_cmd %x ftl_req %x",},\
/* 0x00e0 */{"read.c", "read_err_handling", 128, "SPB %d erase %d read cnt %d flag %x",},\
/* 0x00e1 */{"read.c", "read_err_handling", 94, "ls %d rd err %d-%x l %x, %x, ctag %d",},\
/* 0x00e2 */{"internal_ls.c", "internal_wait_sys_log_flush", 302, "ls %d wait sys log flush %p",},\
/* 0x00e3 */{"internal_ls_write.c", "internal_ls_gc_write_err", 122, "ils %d write error",},\
/* 0x00e4 */{"internal_ls_write.c", "internal_ls_write", 105, "Ls_id(%d) is out of system page resource",},\
/* 0x00e5 */{"internal_ls_write.c", "internal_ls_write_error", 234, "req %x ils %d write error %x %d",},\
/* 0x00e6 */{"internal_ls_write.c", "internal_ls_write_error", 264, "wait for aspb idle",},\
/* 0x00e7 */{"internal_ls_write.c", "internal_write_close_spb_flush_done", 199, "remove ils spb %d",},\
/* 0x00e8 */{"lock.c", "lock_lock", 182, "%p blocked %d %d",},\
/* 0x00e9 */{"lock.c", "lock_unlock", 206, "%p unblock",},\
/* 0x00ea */{"middle_ls_flush.c", "middle_flush_desc_flush", 185, "middle desc dirty flush",},\
/* 0x00eb */{"middle_ls_flush.c", "middle_flush_next_ls_flush_done", 230, "middle flush done",},\
/* 0x00ec */{"middle_ls_write.c", "middle_close_spb_flush", 340, "close middle active spb %d",},\
/* 0x00ed */{"middle_ls_write.c", "middle_force_close_spb_flush", 427, "force close m aspb %d",},\
/* 0x00ee */{"middle_ls_write.c", "middle_write_get_invalid_lda_cnt", 261, "mid -%d",},\
/* 0x00ef */{"system_ls_flush.c", "system_flush_desc_flush", 114, "sys desc dirty flush",},\
/* 0x00f0 */{"system_ls_flush.c", "system_flush_desc_flush_done", 136, "system flush done",},\
/* 0x00f1 */{"system_ls_write.c", "system_close_spb_flush", 219, "close system active spb %d",},\
/* 0x00f2 */{"system_ls_write.c", "system_close_spb_flush", 229, "flush system log",},\
/* 0x00f3 */{"system_ls_write.c", "system_force_close_spb_flush", 291, "write err close %d",},\
/* 0x00f4 */{"system_ls_write.c", "system_write_err_handling", 258, "aspb idle",},\
/* 0x00f5 */{"perf.c", "perf_mon_upd", 78, "new perf %d",},\
/* 0x00f6 */{"user_ls.c", "fc_timer_func", 1138, "abort weak gc because of too few free spb",},\
/* 0x00f7 */{"user_ls.c", "user_convert_done_notify", 935, " wr %d, fence %d",},\
/* 0x00f8 */{"user_ls.c", "user_convert_trigger", 816, "cvrt resume %x",},\
/* 0x00f9 */{"user_ls.c", "user_convert_trigger", 821, "GC need stop %x",},\
/* 0x00fa */{"user_ls.c", "user_convert_trigger", 841, "spb id:0x%x state:%d wr ptr:0x%x fence:0x%x vc:%d",},\
/* 0x00fb */{"user_ls.c", "user_convert_trigger", 864, "convert handles rd fail spb 0x%x",},\
/* 0x00fc */{"user_ls.c", "user_ls_flush_desc", 1037, "user sn %d",},\
/* 0x00fd */{"user_ls.c", "user_ls_flush_desc", 1061, "> ready_spb[%d] %d",},\
/* 0x00fe */{"user_ls.c", "user_ls_flush_desc", 1064, "> [%d][%d] spb %d %d, %d",},\
/* 0x00ff */{"user_ls.c", "user_ls_force_flush_rlut_done", 889, "force close convert",},\
/* 0x0100 */{"user_ls_flush.c", "complete_flush_req", 354, "flush 0 done, %d",},\
/* 0x0101 */{"user_ls_flush.c", "complete_flush_req", 357, "flush keep dirty %d",},\
/* 0x0102 */{"user_ls_flush.c", "user_flush", 197, "user flags %x %x %x",},\
/* 0x0103 */{"user_ls_read.c", "setup_ncl_info_list", 633, "%d L %x errPDA psag %d",},\
/* 0x0104 */{"user_ls_read.c", "user_read_submit_rapid_ncl", 489, "err lda %x ftl req flag %x",},\
/* 0x0105 */{"user_ls_trim.c", "_trim_range_hit", 285, "lda 0x%x pda 0x%x hit trim %d",},\
/* 0x0106 */{"user_ls_trim.c", "chk_if_blk_trim", 598, "trim 0x%x blocked %d %d %d",},\
/* 0x0107 */{"user_ls_trim.c", "flush_trim_info", 1018, "no lda to flush trim",},\
/* 0x0108 */{"user_ls_trim.c", "flush_trim_info", 1030, "fail to get dtag",},\
/* 0x0109 */{"user_ls_trim.c", "flush_trim_info", 1065, "trim 0x%x(%d) flush to lda %d",},\
/* 0x010a */{"user_ls_trim.c", "get_dtag_for_trim_flush", 997, "get dtag OK",},\
/* 0x010b */{"user_ls_trim.c", "trim_assign_ckpt", 583, "trim ckpt, spb %d, wr_ptr %d, sn %d, ls_sn %d",},\
/* 0x010c */{"user_ls_trim.c", "trim_convert_finish", 875, "all range trim done",},\
/* 0x010d */{"user_ls_trim.c", "trim_convert_finish", 878, "trim done[%d], lba:0x%x, cnt:0x%x",},\
/* 0x010e */{"user_ls_trim.c", "trim_flush_cmpl", 914, "trim 0x%x(%d) flushed %d -> 0x%x",},\
/* 0x010f */{"user_ls_trim.c", "trim_timer_handler", 1130, "trim %x no ckpt, skip flush",},\
/* 0x0110 */{"user_ls_trim.c", "update_trim_range", 431, "skip range [0x%x-0x%x]",},\
/* 0x0111 */{"user_ls_trim.c", "user_trim_external", 664, "trim 0x%x resume",},\
/* 0x0112 */{"user_ls_trim.c", "user_trim_flush_all", 1097, "trim %x no ckpt, skip flush",},\
/* 0x0113 */{"user_ls_trim.c", "user_trim_internal", 695, "internal trim block by %x",},\
/* 0x0114 */{"user_ls_trim.c", "user_trim_recon", 1248, "trim fence[%d]: %d %d [0x%x, 0x%x]",},\
/* 0x0115 */{"user_ls_trim.c", "user_trim_recon", 1268, "found trim %d at lda %d pda 0x%x",},\
/* 0x0116 */{"user_ls_trim.c", "user_trim_recon", 1271, "trim info range[%d]: [0x%x, 0x%x]",},\
/* 0x0117 */{"user_ls_trim.c", "user_trim_recon", 1290, "inv trim lda %d old %x, vld %d",},\
/* 0x0118 */{"user_ls_trim.c", "user_trim_recon", 1299, "found unfinished trim: sn %d at lda %d pda 0x%x",},\
/* 0x0119 */{"user_ls_trim.c", "user_trim_recon", 1302, "trim range[%d]: [0x%x, 0x%x]",},\
/* 0x011a */{"user_ls_trim.c", "user_trim_recon", 1324, "trim recon size > DTAG",},\
/* 0x011b */{"user_ls_trim.c", "user_trim_recon", 1332, "No mem for trim recon",},\
/* 0x011c */{"user_ls_trim.c", "user_trim_recon", 1336, "Dtag for trim recon %d",},\
/* 0x011d */{"user_ls_trim.c", "user_trim_trigger", 457, "switch to high pri trim",},\
/* 0x011e */{"user_ls_trim.c", "user_trim_trigger", 466, "restore trim %d",},\
/* 0x011f */{"user_ls_trim.c", "user_trim_trigger", 512, "wait to trigger in trim timer",},\
/* 0x0120 */{"user_ls_trim.c", "user_trim_trigger", 521, "trim trigger[%d] lba:0x%x, cnt:0x%x",},\
/* 0x0121 */{"user_ls_trim.c", "user_trim_trigger", 528, "trim all, nr_lba 0x%x, nr_range %d",},\
/* 0x0122 */{"user_ls_write.c", "print_pga_info", 192, "wr 0x%x order 0x%x received 0x%x",},\
/* 0x0123 */{"user_ls_write.c", "print_user_ls_info", 794, "user ls, blk f:0x%x, fc rev:%d",},\
/* 0x0124 */{"user_ls_write.c", "print_user_ls_info", 796, "user ls, apu recon:%d free:%d order:%d",},\
/* 0x0125 */{"user_ls_write.c", "user_write", 260, "user io block by %x",},\
/* 0x0126 */{"user_ls_write.c", "user_write", 307, "rlut entry reserved failed",},\
/* 0x0127 */{"user_ls_write.c", "user_write", 352, "just order",},\
/* 0x0128 */{"user_ls_write.c", "user_write_ctx_submit", 624, "ff, req id:0x%x pg cnt:%d lda:0x%x pda:0x%x cnt:%d",},\
/* 0x0129 */{"user_ls_write.c", "user_write_done", 452, "ftl req:0x%x startpda:0x%x page idx:%d",},\
/* 0x012a */{"user_ls_write.c", "user_write_done", 474, "end %d",},\
/* 0x012b */{"user_ls_write.c", "user_write_done", 489, "GC trigger convert again",},\
/* 0x012c */{"user_ls_write.c", "user_write_done", 503, "GC was stopped, and convert start",},\
/* 0x012d */{"user_ls_write.c", "user_write_err_handling", 734, "user write err %x, pda %x-%d, f %x",},\
/* 0x012e */{"user_ls_write.c", "user_write_err_handling", 762, "wait for u aspb idle",},\
/* 0x012f */{"user_ls_write.c", "user_write_update_map", 679, "req id:0x%x ctag:0x%x dtag:0x%x off:%d %x",},\
/* 0x0130 */{"convert.c", "cfsm_complete", 547, "convert done %d du/s %d ms",},\
/* 0x0131 */{"convert.c", "cfsm_get_resource", 357, "block by GC",},\
/* 0x0132 */{"convert.c", "convert_handle_rd_fail_spb", 293, "HW %x clear pda:%x L %x",},\
/* 0x0133 */{"convert.c", "convert_handle_rd_fail_spb", 310, "%x clear pda:%x",},\
/* 0x0134 */{"copyback.c", "copyback_abort", 953, "copyback abort xlc %d",},\
/* 0x0135 */{"copyback.c", "copyback_error_handling", 1096, "IDM %d err %x %x, IDM2 redo rnd %d iter %d",},\
/* 0x0136 */{"copyback.c", "copyback_error_handling", 1107, "IDM2 RD err %x %x, rnd %d iter %d",},\
/* 0x0137 */{"copyback.c", "copyback_error_handling", 1115, "IDM%d dtag cnt %d, err %x %x, redo rnd %d iter %d",},\
/* 0x0138 */{"copyback.c", "copyback_release_dtags", 1182, "cpbk dtag rel %d",},\
/* 0x0139 */{"copyback.c", "cpbk_fsm_merge_valid_count", 510, "copyback pend %p",},\
/* 0x013a */{"copyback.c", "cpbk_fsm_resource_check", 452, "IDM2 %x dtag cnt %d start",},\
/* 0x013b */{"copyback.c", "cpbk_fsm_xlc_erase", 472, "xlc erase %d",},\
/* 0x013c */{"copyback.c", "cpbk_pair_dump", 1206, "p %d s[0] %d s[1] %d s[2] %d t %d",},\
/* 0x013d */{"copyback.c", "cpbk_pair_dump", 1208, "f %x ib %d gcb %d",},\
/* 0x013e */{"copyback.c", "cpbk_pair_dump", 1210, "i_cnt %d clo_cnt %d rsvd %d",},\
/* 0x013f */{"copyback.c", "cpbk_pair_set_error", 1162, "xlc %d erase/prog fail",},\
/* 0x0140 */{"copyback.c", "force_idm2_main", 1233, "Usage: force_idm2 [0|1], 0 for normal, 1 for force idm2",},\
/* 0x0141 */{"copyback.c", "force_idm2_main", 1237, "force_idm2 change from %d to %d",},\
/* 0x0142 */{"copyback.c", "is_doing_cpbk", 1194, "%d is doing copyback!",},\
/* 0x0143 */{"slc_buffer_pool.c", "_sbp_lookup", 778, "error PDA %x",},\
/* 0x0144 */{"slc_buffer_pool.c", "_shadow_sbp_lookup", 810, "shadow pair %d inv\n",},\
/* 0x0145 */{"slc_buffer_pool.c", "_shadow_sbp_lookup", 817, "hit shadow pair %d\n",},\
/* 0x0146 */{"slc_buffer_pool.c", "sbp_capacity_update", 188, "ttl %d req %d free slc %d free xlc %d",},\
/* 0x0147 */{"slc_buffer_pool.c", "sbp_capacity_update", 193, "reset nr pair %d, th %d vld %d insert slc %d",},\
/* 0x0148 */{"slc_buffer_pool.c", "sbp_capacity_update", 207, "retired nr pair %d, th %d vld %d insert slc %d",},\
/* 0x0149 */{"slc_buffer_pool.c", "sbp_capacity_update", 228, "dec nr pair %d, th %d vp %d",},\
/* 0x014a */{"slc_buffer_pool.c", "sbp_dump", 908, "vp %d cp %d p %d thr %d",},\
/* 0x014b */{"slc_buffer_pool.c", "sbp_dump", 913, "v[%d] %x",},\
/* 0x014c */{"slc_buffer_pool.c", "sbp_dump", 917, "cp[%d] %x",},\
/* 0x014d */{"slc_buffer_pool.c", "sbp_insert_slc", 287, "insert SLC %d %d-%d, T %d, %d/%d",},\
/* 0x014e */{"slc_buffer_pool.c", "sbp_insert_xlc", 308, "insert XLC %d %d, %d/%d(%d)",},\
/* 0x014f */{"slc_buffer_pool.c", "sbp_pair_spb_close", 555, "pair %d closed %d",},\
/* 0x0150 */{"slc_buffer_pool.c", "sbp_refresh", 408, "xlc %d defect",},\
/* 0x0151 */{"slc_buffer_pool.c", "sbp_slc_gc_done", 715, "SLC GC done %d",},\
/* 0x0152 */{"slc_buffer_pool.c", "sbp_slc_gc_done", 724, "SLC GC FINISH",},\
/* 0x0153 */{"slc_buffer_pool.c", "sbp_slc_gc_trigger", 672, "SLC GC trigger %d (%d)",},\
/* 0x0154 */{"slc_buffer_pool.c", "sbp_slc_slot_chk", 362, "pair type %d no switchable pair",},\
/* 0x0155 */{"slc_buffer_pool.c", "shadow_pair_validation", 865, "shadow pair idx %d invalid, shadow %d, src %d",},\
/* 0x0156 */{"slc_buffer_pool.c", "shadow_pair_validation", 874, "shadow pair inv %d, slc idx %d %d",},\
/* 0x0157 */{"slc_buffer_pool.c", "shadow_sbp_dump", 930, "dump shadow SBP",},\
/* 0x0158 */{"slc_buffer_pool.c", "shadow_sbp_dump", 933, "v[%d] %x",},\
/* 0x0159 */{"slc_buffer_pool.c", "shadow_sbp_dump", 937, "s[0] %d s[1] %d s[2] %d t %d SN %x",},\
/* 0x015a */{"slc_buffer_pool.c", "shadow_sbp_dump", 940, "sn[0] %x sn[1] %x sn[2] %x",},\
/* 0x015b */{"slc_buffer_pool.c", "shadow_sbp_insert_pair", 844, "add shadow idx %d, %d %d %d %d SN %x",},\
/* 0x015c */{"slc_buffer_pool.c", "shadow_sbp_start", 260, "assign sram mem for shadow sns %x",},\
/* 0x015d */{"bg.c", "is_system_idle", 490, "under shutdown, dont resume ugc",},\
/* 0x015e */{"gc.c", "gc_cont_dtag_remove_evt", 1060, "gc cont dtag evt %x rm %d",},\
/* 0x015f */{"gc.c", "gc_cont_dtag_remove_evt", 1064, "gc cont dtag evt ctx %x not found",},\
/* 0x0160 */{"gc.c", "gc_dtag_evt_cb", 1271, "ctx was using %d",},\
/* 0x0161 */{"gc.c", "gc_dtag_evt_cb", 1278, "no GC anymore",},\
/* 0x0162 */{"gc.c", "gc_finish", 943, "gc_fsm end",},\
/* 0x0163 */{"gc.c", "gc_finish", 945, "data moving %d done, %d/%d",},\
/* 0x0164 */{"gc.c", "gc_finish", 956, "valid 0 release",},\
/* 0x0165 */{"gc.c", "gc_get_dtag_resource", 1328, "user GC suspend by dtag %d",},\
/* 0x0166 */{"gc.c", "gc_get_resource", 664, "gc suspend, ls_id %d req %x spb %d",},\
/* 0x0167 */{"gc.c", "gc_priority_schedule", 1250, "GC pri schedule %d",},\
/* 0x0168 */{"gc.c", "gc_priority_suspend", 1229, "GC pri wait for %d suspend",},\
/* 0x0169 */{"gc.c", "gc_priority_suspend", 1235, "GC pri wait %d",},\
/* 0x016a */{"gc.c", "gc_read", 704, "abort gc because met weak spb %d %d",},\
/* 0x016b */{"gc.c", "gc_read_err_handling", 1381, "gc rd err[%d] 0x%x %d spb id:0x%x",},\
/* 0x016c */{"gc.c", "gc_read_err_handling", 1409, "gc RR ok!",},\
/* 0x016d */{"gc.c", "gc_reset_err_buf", 1455, "FATAL: reset err buf [%d](%d) L %x P %x",},\
/* 0x016e */{"gc.c", "gc_transfer", 864, "%d suspend by priority",},\
/* 0x016f */{"gc.c", "gc_transfer", 874, "gc suspend, ls_id %d req %x spb %d",},\
/* 0x0170 */{"gc.c", "gc_transfer", 903, "GC was suspend %d",},\
/* 0x0171 */{"gc.c", "gc_write", 814, "GC real write count = 0",},\
/* 0x0172 */{"middle_ls_gc.c", "middle_build_write_lda_list", 381, "middle skipped %x for l %d",},\
/* 0x0173 */{"middle_ls_gc.c", "middle_gc_done", 401, "data moving %d done",},\
/* 0x0174 */{"middle_ls_gc.c", "middle_gc_scan_err_pda", 465, "err pda %x, found pda %x start %d i %d j %d",},\
/* 0x0175 */{"middle_ls_gc.c", "middle_gc_start_data_move", 297, "data moving %d",},\
/* 0x0176 */{"middle_ls_gc.c", "middle_gc_start_data_move", 304, "mgc finish",},\
/* 0x0177 */{"middle_ls_gc.c", "middle_ls_gc", 231, "middle GC %d",},\
/* 0x0178 */{"system_ls_gc.c", "system_build_write_lda_list", 172, "system skip %x for l %d",},\
/* 0x0179 */{"system_ls_gc.c", "system_gc_done", 191, "system gc spb %x vld %d, no mapping found!",},\
/* 0x017a */{"system_ls_gc.c", "system_gc_find_err_lda", 229, "sgc error found L %x P %x",},\
/* 0x017b */{"system_ls_gc.c", "system_ls_gc", 112, "system GC %d",},\
/* 0x017c */{"user_ls_gc.c", "user_build_rd_plist", 1262, "GC stop flag was detected",},\
/* 0x017d */{"user_ls_gc.c", "user_build_rd_plist", 1277, "gc first read",},\
/* 0x017e */{"user_ls_gc.c", "user_build_rd_plist", 1329, "GC write resource failed",},\
/* 0x017f */{"user_ls_gc.c", "user_build_wr_llist", 1450, "user err discard P %x",},\
/* 0x0180 */{"user_ls_gc.c", "user_build_wr_llist", 1474, "user discard l %x %x, %d, %x",},\
/* 0x0181 */{"user_ls_gc.c", "user_find_err_lda_rlut_read_done", 1674, "found cnt %d L %x for P %x",},\
/* 0x0182 */{"user_ls_gc.c", "user_gc_check_lut", 731, "rlut scan done",},\
/* 0x0183 */{"user_ls_gc.c", "user_gc_check_lut", 752, "reach end %x",},\
/* 0x0184 */{"user_ls_gc.c", "user_gc_check_lut", 789, "scanned rlut %d %d",},\
/* 0x0185 */{"user_ls_gc.c", "user_gc_data_move_done", 1744, "GC done index %x",},\
/* 0x0186 */{"user_ls_gc.c", "user_gc_data_move_done", 1757, "unset GC %d",},\
/* 0x0187 */{"user_ls_gc.c", "user_gc_data_move_done", 1785, "GC perf: %d du/%dms, perf(%d/%d)",},\
/* 0x0188 */{"user_ls_gc.c", "user_gc_data_move_done", 1791, "GC time too short",},\
/* 0x0189 */{"user_ls_gc.c", "user_gc_done", 1809, "gc rd fail cnt:%d",},\
/* 0x018a */{"user_ls_gc.c", "user_gc_done", 1822, "gc req aborted",},\
/* 0x018b */{"user_ls_gc.c", "user_gc_get_dtags", 660, "lack of DTAG",},\
/* 0x018c */{"user_ls_gc.c", "user_gc_lut_scan_action", 920, "uGC abt %d %d",},\
/* 0x018d */{"user_ls_gc.c", "user_gc_lut_scan_done", 855, "l2pp_ttl %d, l2pp_off %d, l2pp_cnt %d, rvc %d",},\
/* 0x018e */{"user_ls_gc.c", "user_gc_read_rlut", 705, "read rlut %d %d",},\
/* 0x018f */{"user_ls_gc.c", "user_gc_rlut_read_done", 1059, "uGC %d rlut %d err %d, cont by full scan lut",},\
/* 0x0190 */{"user_ls_gc.c", "user_gc_rlut_read_done", 1077, "reach last entry %d",},\
/* 0x0191 */{"user_ls_gc.c", "user_gc_rlut_read_done", 1093, "scan rlut %d %d",},\
/* 0x0192 */{"user_ls_gc.c", "user_gc_suspend", 577, "alreay suspend",},\
/* 0x0193 */{"user_ls_gc.c", "user_gc_vcnt_reset", 1371, "pvbmp cvrt trigger %d",},\
/* 0x0194 */{"user_ls_gc.c", "user_gc_vcnt_reset", 1380, "still wait for cvrt %d",},\
/* 0x0195 */{"user_ls_gc.c", "user_gc_vcnt_reset", 1394, "SPB %d %d %d",},\
/* 0x0196 */{"user_ls_gc.c", "user_gc_vcnt_reset", 1424, "spb %d vcnt %d - %d = %d",},\
/* 0x0197 */{"user_ls_gc.c", "user_ls_chk_abort_gc", 453, "abrot uGC. spb %d",},\
/* 0x0198 */{"user_ls_gc.c", "user_ls_gc", 531, "GC mem suspend",},\
/* 0x0199 */{"user_ls_gc.c", "user_ls_gc", 550, "user GC wait rlut %d",},\
/* 0x019a */{"user_ls_gc.c", "user_ls_gc_aborted", 1854, "uGC abort %d, (%d/%d)",},\
/* 0x019b */{"user_ls_gc.c", "user_ls_gc_init", 493, "valid bitmap %d",},\
/* 0x019c */{"user_ls_gc.c", "user_ls_gc_suspended", 1868, "uGC suspended. spb %d",},\
/* 0x019d */{"user_ls_gc.c", "user_ls_resume_gc", 426, "ugc(spb %d) was resumed . Only clear flag(0x%x)",},\
/* 0x019e */{"user_ls_gc.c", "user_ls_resume_gc", 433, "ugc was resumed. Continue to gc spb %d",},\
/* 0x019f */{"user_ls_gc.c", "user_write_acquire_resource", 1213, "GC umt fail",},\
/* 0x01a0 */{"user_ls_gc.c", "user_write_acquire_resource", 1223, "GC rlut entry reserved failed",},\
/* 0x01a1 */{"spb_info.c", "spb_info_init", 70, "spb log %d %d",},\
/* 0x01a2 */{"spb_info.c", "spb_info_init", 76, "spb log virgin",},\
/* 0x01a3 */{"rlut.c", "rlut_decapsulate", 1372, "rlut for spb_id %d",},\
/* 0x01a4 */{"rlut.c", "rlut_decapsulate", 1398, "rlut for slc %d tlc %d",},\
/* 0x01a5 */{"rlut.c", "rlut_descapsulate_check", 1424, "spb %d, sn %d, spb chk %d, sn %d, flags 0x%x",},\
/* 0x01a6 */{"rlut.c", "rlut_entry_setup", 1151, "dummy cnt %d",},\
/* 0x01a7 */{"rlut.c", "rlut_mgr_flush", 1274, "flush rlut %d",},\
/* 0x01a8 */{"rlut.c", "rlut_mgr_flush", 1292, "rlut %d f %x",},\
/* 0x01a9 */{"rlut.c", "rlut_mgr_flush_done", 1493, "rlut flush done %d",},\
/* 0x01aa */{"rlut.c", "rlut_mgr_force_flush", 547, "%d has RLUT entry %d in Que",},\
/* 0x01ab */{"rlut.c", "rlut_mgr_get_opt_entry", 1078, "opt rlut ent %p",},\
/* 0x01ac */{"rlut.c", "rlut_mgr_release_opt_entry", 1246, "release opt entry %p",},\
/* 0x01ad */{"rlut.c", "rlut_mgr_set_flush_spb", 1666, "rlut opt %p not set",},\
/* 0x01ae */{"rlut.c", "rlut_mgr_unset_flush_spb", 1699, "rlut resume %p",},\
/* 0x01af */{"rlut.c", "rlut_read_check_collision", 1721, "rlut read pending %d %p",},\
/* 0x01b0 */{"rlut.c", "rlut_read_done", 1535, "rlut ever rd err. %d %x ",},\
/* 0x01b1 */{"rlut.c", "rlut_user_dump", 916, "ru %x avail %d",},\
/* 0x01b2 */{"rlut.c", "rlut_user_dump", 920, "Uent %p spbid %d, fil %d, upd %d, %x",},\
/* 0x01b3 */{"rlut.c", "rlut_user_dump", 926, "Went %p spbid %d, fil %d, upd %d, %x",},\
/* 0x01b4 */{"rlut.c", "rlut_user_dump", 932, "Uent %p xlc %d, fil %d, upd %d, %x",},\
/* 0x01b5 */{"rlut.c", "rlut_user_dump", 938, "Went %p xlc %d, fil %d, upd %d, %x",},\
/* 0x01b6 */{"rlut.c", "rlut_user_flush_remove_active", 1624, "rlut av -%d, %d",},\
/* 0x01b7 */{"rlut.c", "rlut_user_flush_rlut", 760, "SPB %d RLUT %d@%d",},\
/* 0x01b8 */{"rlut.c", "rlut_user_get_entry", 1196, "spda 0x%x cut %d",},\
/* 0x01b9 */{"rlut.c", "rlut_user_recon_rlut", 842, "wait for rlut",},\
/* 0x01ba */{"rlut.c", "rlut_user_recon_rlut", 873, "pda 0x%x cross rlut(0x%x, %d) (%d %d)",},\
/* 0x01bb */{"rlut.c", "rlut_user_restart", 527, "SPB %d RLUT %d@%d",},\
/* 0x01bc */{"apu.c", "apu_switch", 848, "switch to normal mode",},\
/* 0x01bd */{"rdmp.c", "rdmx_switch", 690, "switch to nrm resource",},\
/* 0x01be */{"rdmt.c", "rdmt_entry_update", 610, "update err L %d",},\
/* 0x01bf */{"rdmt.c", "rdmt_entry_update", 627, "update err L %d",},\
/* 0x01c0 */{"rdmt.c", "rdmx_dump", 948, "free %d order %d",},\
/* 0x01c1 */{"rdmt.c", "rdmx_dump", 951, "spb[%d]%d",},\
/* 0x01c2 */{"rdmt.c", "rdmx_invalidate", 450, "seq invalid %d",},\
/* 0x01c3 */{"seqa.c", "seqa_dump", 482, "seq[%d] l %x p %x, c %d, s %d",},\
/* 0x01c4 */{"seqa.c", "seqa_dump", 487, "ins/cvrt/cvrt_end:%d/%d/%d",},\
/* 0x01c5 */{"seqa.c", "seqa_lookup", 214, "lda %d: ent(%d) slda %d pda %x cnt %d",},\
/* 0x01c6 */{"umt.c", "umt_dump", 345, "UMT f %x l_cnt %d ",},\
/* 0x01c7 */{"umt.c", "umt_dump", 351, " aspb[%d] fence %d",},\
/* 0x01c8 */{"umt.c", "umt_dump", 355, " aspb[%d] fence %d slot %d",},\
/* 0x01c9 */{"umt.c", "umt_err_insert", 145, "insert err L %x %d",},\
/* 0x01ca */{"umt.c", "umt_resources_dump", 424, "umt res: rdmt:%d seqa:%d ins ptr:%d cvrt_ptr:%d seq order cnt:%d",},\
/* 0x01cb */{"reconstruction.c", "determine_scan_sequence", 281, "determine sequence: spb id 0x%x",},\
/* 0x01cc */{"reconstruction.c", "recon_check_unit_status", 962, "status changed 1: %d",},\
/* 0x01cd */{"reconstruction.c", "recon_check_unit_status", 969, "status changed 2",},\
/* 0x01ce */{"reconstruction.c", "recon_close_page_allocator", 218, "remove pga spb %d(%d)",},\
/* 0x01cf */{"reconstruction.c", "recon_get_sn", 317, "read error %x",},\
/* 0x01d0 */{"reconstruction.c", "recon_handle_scan_result", 732, "give up by erase hit %d %x",},\
/* 0x01d1 */{"reconstruction.c", "recon_handle_scan_result", 750, "erased [%d]%x",},\
/* 0x01d2 */{"reconstruction.c", "recon_handle_scan_result", 760, "fail [%d]%x",},\
/* 0x01d3 */{"reconstruction.c", "recon_scan_rlut", 866, "end mark %x",},\
/* 0x01d4 */{"reconstruction.c", "recon_scan_rlut", 876, "k:%d lda 0x%x pda 0x%x",},\
/* 0x01d5 */{"reconstruction.c", "recon_scan_spb", 437, "scan SPB 0x%x start ptr 0x%x, vc %d int:%d",},\
/* 0x01d6 */{"reconstruction.c", "recon_scan_spb", 447, "last written ptr:0x%x",},\
/* 0x01d7 */{"reconstruction.c", "recon_scan_spb", 568, "pda:0x%x 0x%x lda:0x%x info:0x%x",},\
/* 0x01d8 */{"reconstruction.c", "recon_scan_spb", 580, "du_offset:%d pg_check_unit:%d unit_status:%d",},\
/* 0x01d9 */{"reconstruction.c", "recon_scan_spb", 650, "start ptr:0x%x erase_seq:%d vc:%d sn:0x%x",},\
/* 0x01da */{"user_ls.c", "user_convert_trigger", 783, "user flush rlut %d",},\
/* 0x01db */{"user_ls_recon.c", "user_ls_recovery", 152, "[%d]ready spb %d",},\
/* 0x01dc */{"spb_log_flush.c", "spb_log_critical_chk", 147, "spb log critical gc",},\
/* 0x01dd */{"system_log.c", "sys_log_critical_chk", 524, "system log critical gc",},\
/* 0x01de */{"system_log.c", "sys_log_dump", 542, "system log, %d(%d), %d-%d",},\
/* 0x01df */{"system_log.c", "sys_log_pages_flush", 734, "Hold on flush %d %d %d",},\
/* 0x01e0 */{"system_log.c", "sys_log_pages_flush", 759, "system log pend",},\
/* 0x01e1 */{"system_log.c", "sys_log_pages_flush", 783, "[%d/%d]%x %x",},\
/* 0x01e2 */{"system_log.c", "sys_log_spb_notify_cb", 687, "system log SPB %d next",},\
/* 0x01e3 */{"system_log.c", "sys_log_spb_notify_cb", 694, "system log resume",},\
/* 0x01e4 */{"system_log.c", "sys_log_spb_notify_cb", 698, "sys log virgin boot flush",},\
/* 0x01e5 */{"system_log.c", "sys_log_spb_notify_cb", 709, "system log SPB %d ready",},\
/* 0x01e6 */{"system_log.c", "sys_log_start", 432, "system log start trigger spb alloc",},\
/* 0x01e7 */{"log.c", "log_add_ready_spb", 516, "log ready SPB %d",},\
/* 0x01e8 */{"log.c", "log_atomic_check", 355, "log atomic discard %d-%d-%d",},\
/* 0x01e9 */{"log.c", "log_atomic_check", 370, "log atomic return page %d",},\
/* 0x01ea */{"log.c", "log_atomic_check_ex", 393, "log page rd err %d %d %d, %x",},\
/* 0x01eb */{"log.c", "log_atomic_check_ex", 405, "backup err %d, %x",},\
/* 0x01ec */{"log.c", "log_atomic_check_ex", 415, "log atomic return page %d, %d/%d",},\
/* 0x01ed */{"log.c", "log_blk_reconstruction", 258, "latest page %d, blk %d spb %d, error %d",},\
/* 0x01ee */{"log.c", "log_blk_reconstruction", 280, "sig err, %x %x %x %x",},\
/* 0x01ef */{"log.c", "log_blk_reconstruction", 293, "ready log SPB %d",},\
/* 0x01f0 */{"log.c", "log_blk_reconstruction", 309, "spb %d recon fail %d",},\
/* 0x01f1 */{"log.c", "log_blk_reconstruction", 329, "log scan start %x",},\
/* 0x01f2 */{"log.c", "log_blk_reconstruction", 338, "%d, %d >start %x",},\
/* 0x01f3 */{"log.c", "log_reconstruction", 212, "discard next %d",},\
/* 0x01f4 */{"log.c", "log_scan_blk_page", 448, "log scan [%d %d] to [%d %d]",},\
/* 0x01f5 */{"log.c", "log_scan_blk_page", 458, "scan lut[%d] %x",},\
/* 0x01f6 */{"log.c", "log_scan_blk_page", 463, "log page rd err %d %d %d, %x",},\
/* 0x01f7 */{"log.c", "log_scan_blk_page", 478, "log page erased",},\
/* 0x01f8 */{"log.c", "log_spb_reconstruction", 235, "log spb %d is eased SPB",},\
/* 0x01f9 */{"log.c", "spbs_decide_latest_spb", 542, "spb %d reused",},\
/* 0x01fa */{"spb_log.c", "spb_log_reconstruction", 108, "spb log flush id is 0",},\
/* 0x01fb */{"spb_log_flush.c", "spb_log_flush", 199, "spb log pend",},\
/* 0x01fc */{"spb_log_flush.c", "spb_log_flush_done", 274, "spb log flush err %x, %d",},\
/* 0x01fd */{"system_log.c", "sys_log_flush_done", 885, "sys log flush err %x, %d",},\
/* 0x01fe */{"system_log.c", "sys_log_flush_flush_header", 994, "sys log flush header at %x",},\
/* 0x01ff */{"ftl_hmb.c", "ftl_hmb_hist_check", 138, "hist[%d] l2pp %d T %d > %d",},\
/* 0x0200 */{"ftl_hmb.c", "ftl_hmb_pda_lookup_done", 283, "FTL hmb lookup error",},\
/* 0x0201 */{"ftl_hmb.c", "ftl_hmb_req_pend", 186, "hmb req %p pend, idx %d/%d",},\
/* 0x0202 */{"ftl_hmb.c", "ftl_hmb_req_resume", 250, "hmb error %p",},\
/* 0x0203 */{"ftl_hmb.c", "ftl_hmb_req_resume", 256, "__hmb req %p pend, idx %d/%d",},\
/* 0x0204 */{"ftl_hmb.c", "ftl_hmb_req_resume", 262, "req %p finished",},\
/* 0x0205 */{"ftl_hmb.c", "hmb_hw_submit", 206, "issue %d hmb push",},\
/* 0x0206 */{"bg.c", "bg_switch_main", 519, "switch bg from %d -> %d",},\
/* 0x0207 */{"defect_mgr.c", "grwn_defect_rebuild", 383, "rebuild grown defect %d",},\
/* 0x0208 */{"frb_log.c", "_frb_log_flush", 520, "frb log switch cur %d next %d",},\
/* 0x0209 */{"frb_log.c", "_frb_log_flush", 575, "frb log flush op %d pg %d at %x, id %d, spb %x sys %x",},\
/* 0x020a */{"frb_log.c", "chk_frb_curr_blk", 649, "frb empty cur %d next %d",},\
/* 0x020b */{"frb_log.c", "chk_frb_curr_blk", 665, "frb chk cur %d next %d",},\
/* 0x020c */{"frb_log.c", "frb_boot_virgin", 1344, "force ftl virgin",},\
/* 0x020d */{"frb_log.c", "frb_defect_restore", 1328, "force ftl virgin",},\
/* 0x020e */{"frb_log.c", "frb_drop_grwn", 1357, "frb drop grown defect",},\
/* 0x020f */{"frb_log.c", "frb_drop_sys_log_id", 857, "drop frb sys log id %d %d",},\
/* 0x0210 */{"frb_log.c", "frb_dump", 1250, "cur/next %d/%d fid %d f %x",},\
/* 0x0211 */{"frb_log.c", "frb_dump", 1254, "frb ver %d, build %x",},\
/* 0x0212 */{"frb_log.c", "frb_dump", 1258, "next pg %d/%d",},\
/* 0x0213 */{"frb_log.c", "frb_dump", 1261, "system log %d %d",},\
/* 0x0214 */{"frb_log.c", "frb_dump", 1265, "spb log %d %d",},\
/* 0x0215 */{"frb_log.c", "frb_dump", 1269, "grown defect version %d count %d history %d",},\
/* 0x0216 */{"frb_log.c", "frb_dump", 1274, "ftl boot option %x",},\
/* 0x0217 */{"frb_log.c", "frb_erase_callby_vu", 1280, "erase frb can not work SRB MR block",},\
/* 0x0218 */{"frb_log.c", "frb_erase_callby_vu", 1285, "erase frb erase done, sys reset",},\
/* 0x0219 */{"frb_log.c", "frb_erase_main", 1293, "erase frb %d %d",},\
/* 0x021a */{"frb_log.c", "frb_erase_main", 1296, "erase frb can not work SRB MR block",},\
/* 0x021b */{"frb_log.c", "frb_erase_main", 1301, "erase frb erase done, sys reset",},\
/* 0x021c */{"frb_log.c", "frb_header_update_cmpl", 1310, "frb header updated",},\
/* 0x021d */{"frb_log.c", "frb_log_flush", 460, "frb log flush pend %d with %x",},\
/* 0x021e */{"frb_log.c", "frb_log_recovery", 683, "frb head pg %d, next pg %x, fid %d",},\
/* 0x021f */{"frb_log.c", "frb_log_recovery", 702, "dtag %x, sig %x, fid %x, type %d",},\
/* 0x0220 */{"frb_log.c", "frb_log_recovery", 710, "ver: %d -> %d, plz upgrade",},\
/* 0x0221 */{"frb_log.c", "frb_log_recovery", 717, "Force erase pb %d . %d",},\
/* 0x0222 */{"frb_log.c", "frb_log_recovery", 723, "FTL build mismatch %x <-> %x, virgin boot",},\
/* 0x0223 */{"frb_log.c", "frb_log_recovery", 746, "grown defect info restart",},\
/* 0x0224 */{"frb_log.c", "frb_log_recovery", 752, "frb tbl upgraded Cap",},\
/* 0x0225 */{"frb_log.c", "frb_log_set_spare_cnt", 1079, "set spare %d",},\
/* 0x0226 */{"frb_log.c", "frb_log_start", 875, "ftl force virgin boot",},\
/* 0x0227 */{"frb_log.c", "frb_log_start", 884, "give up sys log spb %d %d %d %d",},\
/* 0x0228 */{"frb_log.c", "frb_log_start", 892, "ftl drop grown defect",},\
/* 0x0229 */{"frb_log.c", "frb_log_unmap_chk", 810, "verify frb unmap page fail",},\
/* 0x022a */{"frb_log.c", "frb_log_update_grwn_def", 1063, "grown defect number max, kick %x %x",},\
/* 0x022b */{"frb_log.c", "frb_pb_erase", 395, "frb erase pda %x id %d cmpl %x",},\
/* 0x022c */{"frb_log.c", "frb_restore_update_cmpl", 1319, "frb restore updated",},\
/* 0x022d */{"frb_log.c", "get_frb_pb_fid", 606, "frb %x, st %d sig %x t %d",},\
/* 0x022e */{"frb_log.c", "get_frb_pb_fid", 621, "frb 0x%x, st %d rda(0x%x %d %d %d)",},\
/* 0x022f */{"frb_log.c", "grwn_defect_dump", 1421, "grown defect version %d count %d history %d",},\
/* 0x0230 */{"frb_log.c", "grwn_defect_dump", 1428, "grown defect %d, type %d, spb %d, pda %x",},\
/* 0x0231 */{"frb_log.c", "set_ftl_capacity", 1377, "ftl capacity update %d %d",},\
/* 0x0232 */{"frb_log.c", "sim_rom_find_frb_pos", 1235, "sim rom set fake frb0 at spb %d pd %d",},\
/* 0x0233 */{"frb_log.c", "sim_rom_find_frb_pos", 1239, "sim rom set fake frb1 at spb %d pd %d",},\
/* 0x0234 */{"frb_log.c", "sim_rom_find_pri_n_sec", 1138, "sim rom search start frb pda %x",},\
/* 0x0235 */{"frb_log.c", "sim_rom_find_pri_n_sec", 1157, "sim rom no valid hearder",},\
/* 0x0236 */{"frb_log.c", "sim_rom_find_pri_n_sec", 1161, "sim rom frb valid header pg %x, fid %d",},\
/* 0x0237 */{"frb_log.c", "sim_rom_find_pri_n_sec", 1176, "sim rom pri %d sec %d",},\
/* 0x0238 */{"frb_log.c", "sim_rom_search_frb", 1212, "sim rom no find valid frb",},\
/* 0x0239 */{"frb_log.c", "unmap_pda_update", 1123, "upmap pda at %x,",},\
/* 0x023a */{"bg.c", "bg_evt_handler", 377, "BGC CHK",},\
/* 0x023b */{"bg.c", "bg_evt_handler", 387, "NO_BGC",},\
/* 0x023c */{"bg.c", "bg_evt_handler", 434, "bg done",},\
/* 0x023d */{"bg.c", "bg_evt_handler", 443, "bg pri %d done",},\
/* 0x023e */{"bg.c", "bg_st_switch", 319, "bg st chg %d->%d",},\
/* 0x023f */{"bg.c", "bg_timer_handler", 288, "BG ST: 0x%x, BG_EN: 0x%x",},\
/* 0x0240 */{"bg.c", "idle_apst", 195, "enter apst fail 2! %x %x",},\
/* 0x0241 */{"bg.c", "idle_apst", 215, "ENTER IDLE_APST",},\
/* 0x0242 */{"bg.c", "idle_apst", 216, "L1 SUP: 0x%x L1 STATE: 0x%x",},\
/* 0x0243 */{"bg.c", "idle_apst", 259, "DONE EXIT IDLE APST!",},\
/* 0x0244 */{"bg.c", "idle_apst", 265, "enter apst fail! %x %x",},\
/* 0x0245 */{"bg.c", "is_L11_L12_enable", 165, "L1.1 or L1.2 enabled",},\
/* 0x0246 */{"bg.c", "wear_level_done", 511, "spb %d wear level done",},\
};


#define FW_EVID_MAX 1111


#define FW_EVID_STR_FMT { \
/* 0x0000 */{"dtag.c", "_dtag_get", 297, "allocate Dtag(%d) avail(%d)",},\
/* 0x0001 */{"dtag.c", "_dtag_get_off", 267, "allocate Dtag(%d) avail(%d)",},\
/* 0x0002 */{"dtag.c", "_dtag_put", 129, "recycle Dtag(%d) avail(%d) evt(%d)",},\
/* 0x0003 */{"dtag.c", "_dtag_put_urgt", 157, "recycle Dtag(%d) avail(%d) evt(%d)",},\
/* 0x0004 */{"dtag.c", "dtag_add", 648, "mem(0x%p) or size(0x%x) should be 4096 align",},\
/* 0x0005 */{"dtag.c", "dtag_add", 661, "mem(0x%p) size(0x%x) #Dtags(%d)",},\
/* 0x0006 */{"dtag.c", "dtag_blackout", 677, "mem %p Dtag[%d] is taken",},\
/* 0x0007 */{"dtag.c", "dtag_blackout", 686, "mem(0x%p) size(0x%x) Blacked out, left #Dtags(%d)",},\
/* 0x0008 */{"dtag.c", "dtag_get_bulk", 602, "allocate Dtag(%d) avail(%d)",},\
/* 0x0009 */{"dtag.c", "dtag_get_cont", 372, "no suitable dtag for cont",},\
/* 0x000a */{"dtag.c", "dtag_get_cont", 396, "cont DTAG %d-%d",},\
/* 0x000b */{"dtag.c", "dtag_get_cont_urgt", 344, "cont DTAG %d-%d",},\
/* 0x000c */{"dtag.c", "dtag_get_urgt", 580, "allocate Dtag(%d) avail(%d)",},\
/* 0x000d */{"dtag.c", "dtag_put_cont", 430, "recycle cont Dtag(%d)-%d avail(%d) evt(%d)",},\
/* 0x000e */{"dtag.c", "dtag_register_evt", 697, "ctx = %p, evt = %d",},\
/* 0x000f */{"dtag.c", "dtag_remove_evt", 724, "dtag evt ctx %p removed",},\
/* 0x0010 */{"dtag.c", "dtag_remove_evt", 730, "dtag evt ctx %p not found",},\
/* 0x0011 */{"dtag.c", "io_dtag_get", 800, "io dtag %x, -%d, %d/%d",},\
/* 0x0012 */{"bf_mgr.c", "bm_abort_free_wr_load", 672, "abort dtag %d t %d",},\
/* 0x0013 */{"bf_mgr.c", "bm_data_merge", 919, "dpe ctx about to overflow %d %d",},\
/* 0x0014 */{"bf_mgr.c", "bm_dpe_dump_last_cmd", 2677, "last req dump: %d",},\
/* 0x0015 */{"bf_mgr.c", "bm_dpe_dump_last_cmd", 2679, "%x %x %x %x",},\
/* 0x0016 */{"bf_mgr.c", "bm_fetch_ss_cfp", 1499, "cfp fetch: start ....",},\
/* 0x0017 */{"bf_mgr.c", "bm_fetch_ss_cfp", 1506, "cfp fetch: done ....",},\
/* 0x0018 */{"bf_mgr.c", "bm_fetch_ss_cfp", 1510, "CFP Not Programmed: select(%d), reg_val(%x)",},\
/* 0x0019 */{"bf_mgr.c", "bm_handle_tcm_update", 1814, "%x rptr = %d, wptr = %d -> (%d)",},\
/* 0x001a */{"bf_mgr.c", "bm_isr", 1996, "sts = %x",},\
/* 0x001b */{"bf_mgr.c", "bm_pl_disp", 590, "Ctag(%d), Dtag(%d)",},\
/* 0x001c */{"bf_mgr.c", "bm_pop_dtag_llist", 2064, "no support",},\
/* 0x001d */{"bf_mgr.c", "bm_pop_dtag_llist", 2073, "free count %x",},\
/* 0x001e */{"bf_mgr.c", "bm_pop_wd_entry_llist", 2162, "no support",},\
/* 0x001f */{"bf_mgr.c", "bm_pop_wd_entry_llist", 2174, "free count %x",},\
/* 0x0020 */{"bf_mgr.c", "bm_program_ss_cfp", 1430, "cfp: start ....",},\
/* 0x0021 */{"bf_mgr.c", "bm_program_ss_cfp", 1434, "cfp: generated .... %x",},\
/* 0x0022 */{"bf_mgr.c", "bm_program_ss_cfp", 1438, "cfp: FP valid %x....",},\
/* 0x0023 */{"bf_mgr.c", "bm_program_ss_cfp", 1443, "cfp: fp_check_flag good .... %x",},\
/* 0x0024 */{"bf_mgr.c", "bm_program_ss_cfp", 1452, "CFP Programmed previously: select(%d), reg_val(%x)",},\
/* 0x0025 */{"bf_mgr.c", "bm_rd_dtag_commit", 756, "Du_ofst(%d) Ctag(%d) Dtag(%d)",},\
/* 0x0026 */{"bf_mgr.c", "bm_rd_err_recycle", 1634, "recycle err rd ent c(%d) o(%d) d(%d)",},\
/* 0x0027 */{"bf_mgr.c", "bm_reset", 2596, "wait bm idle",},\
/* 0x0028 */{"bf_mgr.c", "bm_reset", 2609, "reset aurl %d abort dtag cnt %d, bmq %d",},\
/* 0x0029 */{"bf_mgr.c", "bm_reset", 2619, "reset freew %d",},\
/* 0x002a */{"bf_mgr.c", "bm_slow_isr", 1941, "sram ecc error",},\
/* 0x002b */{"bf_mgr.c", "bm_slow_isr", 1951, "bm data parity error %x 0xc0043004 %x",},\
/* 0x002c */{"bf_mgr.c", "bm_slow_isr", 1967, "llist over flow %x",},\
/* 0x002d */{"bf_mgr.c", "bm_slow_isr", 1972, "unhandled ISR sts 0x%x",},\
/* 0x002e */{"bf_mgr.c", "bm_wait_aurl_idle", 2535, "fr %d rd %d",},\
/* 0x002f */{"bf_mgr.c", "bm_wait_aurl_idle", 2561, "+fr %d rd %d",},\
/* 0x0030 */{"bf_mgr.c", "bm_wd_err_recycle", 1869, "wr data err cnt:%d",},\
/* 0x0031 */{"bf_mgr.c", "bm_wr_data_entry_check", 2142, "ctag %d has WDE %d",},\
/* 0x0032 */{"bf_mgr.c", "dpe_rsp_handle", 1700, "DPE sts: %d code: %d",},\
/* 0x0033 */{"ncl.c", "ncl_init", 759, "NCL Init Done",},\
/* 0x0034 */{"ncl.c", "ncl_is_block_factory_defective", 501, "RDA [%x_%x_%x] is defect",},\
/* 0x0035 */{"ncl.c", "ncl_is_pda_factory_defective", 475, "PDA %x is defect[col %x = %x]",},\
/* 0x0036 */{"ncl.c", "ncl_pda_raw_operation", 375, "PDA %x RAW Dump %x_%x_%x_%x",},\
/* 0x0037 */{"ncl.c", "ncl_pda_read", 215, "PDA %x Read Dump %x_%x_%x_%x",},\
/* 0x0038 */{"ncl.c", "ncl_read_pasg_handler", 117, "NCL in-read done Ctag(%d) Du_off(%d) Dtag(%d)",},\
/* 0x0039 */{"ncl.c", "ncl_spb_defect_scan", 570, "SPB %d Blk %d off %d is defect",},\
/* 0x003a */{"ncl_cmd.c", "<global>", 3300, "timeout %d fcmd",},\
/* 0x003b */{"ncl_cmd.c", "<global>", 3313, "timeout:fcmd %p id %d req %p",},\
/* 0x003c */{"ncl_cmd.c", "<global>", 3344, "WA: FICU reset",},\
/* 0x003d */{"ncl_cmd.c", "ncl_cmd_acquire_du_tag_ptr", 342, "Dtag ptr is busy, FCMD %d",},\
/* 0x003e */{"ncl_cmd.c", "ncl_cmd_cb2_set_pdone_count", 2887, "copyback early done",},\
/* 0x003f */{"ncl_cmd.c", "ncl_cmd_check_timeout", 3223, "FCMD %d, op %d real timeout, outs %d, %d",},\
/* 0x0040 */{"ncl_cmd.c", "ncl_cmd_check_timeout", 3233, "WFCMD %d(%p) timeout, outs %d,%d",},\
/* 0x0041 */{"ncl_cmd.c", "ncl_cmd_check_timeout", 3247, "WA: FICU reset",},\
/* 0x0042 */{"ncl_cmd.c", "ncl_cmd_copyback_cmd_split", 2817, "index %d, width %d, len %d",},\
/* 0x0043 */{"ncl_cmd.c", "ncl_cmd_copyback_prog_completion", 2537, "cb prog done",},\
/* 0x0044 */{"ncl_cmd.c", "ncl_cmd_copyback_read_completion", 2673, "cb read done",},\
/* 0x0045 */{"ncl_cmd.c", "ncl_cmd_copyback_read_eh_completion", 2579, "cb %x reread err",},\
/* 0x0046 */{"ncl_cmd.c", "ncl_cmd_copyback_read_eh_completion", 2585, "cb reread good",},\
/* 0x0047 */{"ncl_cmd.c", "ncl_cmd_copyback_read_error_handling", 2630, "cb read err PDA %d: %x",},\
/* 0x0048 */{"ncl_cmd.c", "ncl_cmd_delay_completion", 1672, "delay complete cmd %p op %d, flags %x",},\
/* 0x0049 */{"ncl_cmd.c", "ncl_cmd_dump", 3172, "NCL cmd: %p, op %d",},\
/* 0x004a */{"ncl_cmd.c", "ncl_cmd_dump", 3183, "PDA %d: %x, type %d, sts %x",},\
/* 0x004b */{"ncl_cmd.c", "ncl_cmd_err_pda_update", 1021, "PDA[%d] %x, dup read, sts %d",},\
/* 0x004c */{"ncl_cmd.c", "ncl_cmd_err_pda_update", 1052, "CB error, op %d, sts %x",},\
/* 0x004d */{"ncl_cmd.c", "ncl_cmd_err_pda_update", 1063, "PDA[%d] %x error, op %d, st: %x",},\
/* 0x004e */{"ncl_cmd.c", "ncl_cmd_err_pda_update", 1088, "Dont find freq %p err PDA %x, op %d %x",},\
/* 0x004f */{"ncl_cmd.c", "ncl_cmd_handle_rr_pending_list", 1205, "handle running rr",},\
/* 0x0050 */{"ncl_cmd.c", "ncl_cmd_handle_rr_pending_list", 1222, "pend rr handle %p %d",},\
/* 0x0051 */{"ncl_cmd.c", "ncl_cmd_mu_qlc_extra_read_eh_completion", 1315, "ext RR sts %d",},\
/* 0x0052 */{"ncl_cmd.c", "ncl_cmd_mu_qlc_extra_read_error_handling", 1392, "qlc extra read err PDA %d: %x",},\
/* 0x0053 */{"ncl_cmd.c", "ncl_cmd_op_issue", 2914, "issue nest",},\
/* 0x0054 */{"ncl_cmd.c", "ncl_cmd_push_read_error_handling", 915, "Insert %p RR list",},\
/* 0x0055 */{"ncl_cmd.c", "ncl_cmd_read_pages_dispatch", 712, "read pg %d, idx %d cnt %d, pda %x",},\
/* 0x0056 */{"ncl_cmd.c", "ncl_cmd_timeout_dump", 3511, "fcmd %d, jiffies: 0x%x, cmd_list:0x%x 0x%x, 0x%x",},\
/* 0x0057 */{"ncl_cmd.c", "ncl_cmd_timeout_dump", 3517, "pending_cmds_list: %d: %p",},\
/* 0x0058 */{"ncl_cmd.c", "ncl_cmd_timeout_dump", 3523, "rr pending: %d: %p",},\
/* 0x0059 */{"ncl_cmd.c", "ncl_cmd_timeout_dump", 3529, "completion pending: %d: %p",},\
/* 0x005a */{"ncl_cmd.c", "ncl_cmd_timeout_dump", 3540, "timeout:fcmd %p id %d req %p, time %x",},\
/* 0x005b */{"ncl_cmd_simple.c", "ncl_cmd_simple_submit", 335, "op %d err",},\
/* 0x005c */{"ncl_cmd_eh.c", "ncl_eh_cmd_error_handling", 893, "start RR %p",},\
/* 0x005d */{"ncl_cmd_eh.c", "ncl_eh_complete_orig_cmd", 548, "Done RR %p, PDA %x cost_time %d(u) ret-type-phase %x, step %d, sts %d",},\
/* 0x005e */{"ncl_cmd_eh.c", "ncl_eh_cont_handling", 744, "process RR %p, idx %d/%d do %d",},\
/* 0x005f */{"ncl_cmd_eh.c", "ncl_eh_cont_handling", 764, "ERD PDA %x type %d, step %d/%d",},\
/* 0x0060 */{"ncl_cmd_eh.c", "ncl_eh_cont_handling", 784, "ERD PDA %x type %d",},\
/* 0x0061 */{"ncl_cmd_eh.c", "ncl_eh_erd_completion", 359, "ERD OOO, req %p, ERD %d, Orig %d",},\
/* 0x0062 */{"ncl_cmd_eh.c", "ncl_eh_erd_completion", 365, "ERD reread done, req %p, FCMD %d",},\
/* 0x0063 */{"ncl_cmd_eh.c", "ncl_eh_erd_completion", 370, "Start decoding",},\
/* 0x0064 */{"ncl_cmd_eh.c", "ncl_eh_erd_ipi_submit", 279, "ERD IPI pg %d row %x cnt %d",},\
/* 0x0065 */{"ncl_cmd_eh.c", "ncl_eh_erd_ipi_submit", 290, "Start decoding",},\
/* 0x0066 */{"ncl_cmd_eh.c", "ncl_eh_erd_submit", 398, "Enter ERD, row %x, CW %d, rec_CW %d, sts %x",},\
/* 0x0067 */{"ncl_cmd_eh.c", "ncl_eh_erd_submit", 413, "err CW %d, sts %d",},\
/* 0x0068 */{"ncl_cmd_eh.c", "ncl_eh_erd_submit", 456, "Leave ERD",},\
/* 0x0069 */{"ncl_cmd_eh.c", "ncl_eh_inc_reread", 310, "Incremental Re-read",},\
/* 0x006a */{"ncl_cmd_eh.c", "ncl_eh_read_completion", 607, "done RR %p, idx %d/%d, idx %d, pda %x sts %d",},\
/* 0x006b */{"ncl_profile.c", "ncl_profile_alloc_dtag", 732, "Profile DTag %d",},\
/* 0x006c */{"ncl_profile.c", "ncl_profile_completion", 411, "profile done",},\
/* 0x006d */{"ncl_profile.c", "ncl_profile_dump", 321, "Profile Item %d OP: %s, %s",},\
/* 0x006e */{"ncl_profile.c", "ncl_profile_dump", 324, "====>\t BS %d KB, Range: %d MB Depth: %d",},\
/* 0x006f */{"ncl_profile.c", "ncl_profile_dump", 328, "====>\t IOPS %d Bandwidth %d MB",},\
/* 0x0070 */{"ncl_profile.c", "ncl_profile_handling", 659, "Start Item %d OP: %s, %s",},\
/* 0x0071 */{"ncl_profile.c", "ncl_profile_handling", 662, "-->\t BS %d KB, Range: %d MB Depth: %d",},\
/* 0x0072 */{"ncl_profile.c", "ncl_profile_handling", 682, "\tSPB start %d PDA %x, count %d",},\
/* 0x0073 */{"ncl_profile.c", "ncl_profile_read_completion", 365, "RD Error %p",},\
/* 0x0074 */{"ncl_profile.c", "ncl_profile_read_completion", 367, "PDA Error %d: %x",},\
/* 0x0075 */{"ncl_profile.c", "ncl_profile_spb_erase", 295, "Erase SPB %d",},\
/* 0x0076 */{"ncl_profile.c", "ncl_profile_test", 567, "Looping...",},\
/* 0x0077 */{"ncl_console.c", "_ncl_get_tPROG", 579, "No enough dtag %d.",},\
/* 0x0078 */{"ncl_console.c", "_ncl_get_tPROG", 585, "No enough meta",},\
/* 0x0079 */{"ncl_console.c", "eccu_clk_main", 1840, "0: 106, 1: 133, 2: 266, 3: 533",},\
/* 0x007a */{"ncl_console.c", "eccu_clk_main", 1844, "Not support",},\
/* 0x007b */{"ncl_console.c", "eccu_clk_main", 1867, "eccu_clk: Error - wrong parameter(%d)",},\
/* 0x007c */{"ncl_console.c", "eccu_clk_main", 1871, "eccu_clk(%d MHz)",},\
/* 0x007d */{"ncl_console.c", "flash_io_clk_main", 1799, "0: 100, 1: 200, 2: 400, 3: 533, 4: 667",},\
/* 0x007e */{"ncl_console.c", "flash_io_clk_main", 1824, "flash_io_clk: Error - wrong parameter(%d)",},\
/* 0x007f */{"ncl_console.c", "flash_io_clk_main", 1828, "flash_io_clk(%d MHz)",},\
/* 0x0080 */{"ncl_console.c", "ncl_console_init", 2052, "NCL Debug Mode Enable",},\
/* 0x0081 */{"ncl_console.c", "ncl_get_fda", 2142, "PDA 0x%x, type: %d",},\
/* 0x0082 */{"ncl_console.c", "ncl_get_fda", 2143, "CH %d CE %d Lun %d Plane %d ROW %x",},\
/* 0x0083 */{"ncl_console.c", "ncl_get_fda", 2146, "block %d page %d du %d(%s)",},\
/* 0x0084 */{"ncl_console.c", "ncl_get_fda", 2155, "page %d type %d",},\
/* 0x0085 */{"ncl_console.c", "ncl_page_cache_write", 208, "No enough dtag %d.",},\
/* 0x0086 */{"ncl_console.c", "ncl_page_cache_write", 214, "No enough meta",},\
/* 0x0087 */{"ncl_console.c", "ncl_page_write", 117, "write pda was not page align %x, force page alignment.",},\
/* 0x0088 */{"ncl_console.c", "ncl_page_write", 125, "No enough dtag %d.",},\
/* 0x0089 */{"ncl_console.c", "ncl_page_write", 131, "No enough meta",},\
/* 0x008a */{"ncl_pmu.c", "ncl_pmu_suspend", 387, "No enough PMU buf",},\
/* 0x008b */{"ncl_read_refresh.c", "ncl_read_refresh_init", 297, "no pda_list",},\
/* 0x008c */{"ncl_read_refresh.c", "ncl_read_refresh_init", 303, "no pda_list",},\
/* 0x008d */{"tsb_ops.c", "nal_set_tsb_tsv_high_speed", 111, "tsv hs: ch %d ce %d expect: %x, real: %x",},\
/* 0x008e */{"tsb_ops.c", "nal_set_tsb_tsv_nand_interface", 75, "tsv inf: ch %d ce %d get: %x",},\
/* 0x008f */{"tsb_ops.c", "nal_set_tsb_tsv_nand_interface", 90, "tsv inf: ch %d ce %d expect: %x, real: %x",},\
/* 0x0090 */{"nal_features.c", "nal_ce_remapping", 440, "NAND CH %d's CE remapping",},\
/* 0x0091 */{"nal_features.c", "nal_ce_remapping", 450, "NAND CE %d -> CE %d",},\
/* 0x0092 */{"nal_features.c", "nal_execute_zq_calibration", 140, "ZQ %d/%d/%d Fail",},\
/* 0x0093 */{"nal_features.c", "nal_get_onfi_timing", 181, "nand timing err: ch %d ce %d, expect: %x, real: %x",},\
/* 0x0094 */{"nal_features.c", "nal_get_parameter_page", 412, "get param err %d",},\
/* 0x0095 */{"nal_features.c", "nal_handle_onfi_parameter_page", 261, "Invalid param %x.",},\
/* 0x0096 */{"nal_features.c", "nal_handle_onfi_parameter_page", 270, "RP CRC err",},\
/* 0x0097 */{"nal_features.c", "nal_handle_toggle_parameter_page", 324, "Invalid param %x.",},\
/* 0x0098 */{"nal_features.c", "nal_handle_toggle_parameter_page", 332, "RP %d CRC err",},\
/* 0x0099 */{"nal_features.c", "nal_handle_toggle_parameter_page", 336, "TSV ignores CRC err",},\
/* 0x009a */{"nal_features.c", "nal_scan_devices_id", 482, "NAND CH %d, CE %d (id %x) not exists",},\
/* 0x009b */{"nal_features.c", "nal_scan_devices_id", 495, "NAND dev ID error, CH %d, CE %d, ID: %x_%x",},\
/* 0x009c */{"nal_features.c", "nal_scan_devices_id", 522, "Max CE %d, CH %d",},\
/* 0x009d */{"nal_features.c", "nal_set_ddr23_conf", 80, "nand ddr conf err: ch %d ce %d expect: %x, real: %x",},\
/* 0x009e */{"nal_features.c", "nal_set_drive_strength", 208, "ds err: ch %d ce %d expect: %x, real: %x",},\
/* 0x009f */{"nal_init.c", "nal_init", 416, "NAND detection failure!",},\
/* 0x00a0 */{"nal_init.c", "nal_init", 421, "NAND Detection Done, Use %s conf",},\
/* 0x00a1 */{"nal_init.c", "nal_init", 432, "DEV CFG: CH %d,CE %d,LUN %d,PLN %d,BLK %d",},\
/* 0x00a2 */{"nal_init.c", "nal_init", 436, "PG %d, SZ %x, LUN Bit: %d, Plane Bit: %d, BLK SFT %d",},\
/* 0x00a3 */{"nal_init.c", "nal_init_channel_remapping", 293, "CH remapping %d -> %d",},\
/* 0x00a4 */{"nal_init.c", "nal_init_device_discovery", 103, "First CH %d",},\
/* 0x00a5 */{"nal_init.c", "nal_init_device_discovery", 113, "NAND 1.2v err!",},\
/* 0x00a6 */{"nal_init.c", "nal_init_device_discovery", 128, "NAND is CONV TOGGLE.",},\
/* 0x00a7 */{"nal_init.c", "nal_init_device_discovery", 159, "Reconf TSV to %x",},\
/* 0x00a8 */{"nal_init.c", "nal_init_device_discovery", 166, "ch/ce err!",},\
/* 0x00a9 */{"nal_init.c", "nal_init_device_discovery", 169, "T %d CH %d CE %d!",},\
/* 0x00aa */{"nal_init.c", "nal_init_geo", 206, "Force reduce blocks to %d(original 1/4).\n",},\
/* 0x00ab */{"eccu.c", "eccu_dsm_disable", 807, "Page RBER_H: %d, RBER_L: %d, DSM_CW_COUNT: %d, AVG_RBER: %d, MDec: ITER %d",},\
/* 0x00ac */{"eccu.c", "eccu_du_fmt_id_init", 428, "DU FMT %d par sz %x",},\
/* 0x00ad */{"eccu.c", "eccu_du_fmt_id_init", 440, "DU sz %x/%x",},\
/* 0x00ae */{"eccu.c", "eccu_du_fmt_id_init", 446, "DU %d sz error, pg size: %x",},\
/* 0x00af */{"eccu.c", "eccu_du_fmt_id_init", 458, "DU sz %x/%x, pad sz %x",},\
/* 0x00b0 */{"eccu.c", "eccu_dump_err_count", 932, "MDec: ITER %d 0to1: %d, 1to0: %d",},\
/* 0x00b1 */{"eccu.c", "eccu_dump_err_count", 936, "PDec: ITER %d 0to1: %d, 1to0: %d",},\
/* 0x00b2 */{"eccu.c", "eccu_hw_init", 884, "ECCU ver: %x",},\
/* 0x00b3 */{"fcmd.c", "fcmd_pda2row", 301, "pda %d %x to %x (%d)",},\
/* 0x00b4 */{"fcmd.c", "fcmd_set_ncb_format", 480, "FCMD ID %d(%d) CH %d CE %d lv %d/%d",},\
/* 0x00b5 */{"ndcu.c", "ndcu_execute_cmd", 570, "Retry CMD %x failure",},\
/* 0x00b6 */{"ndcu.c", "ndcu_execute_cmd", 653, "CMD %x in DDR",},\
/* 0x00b7 */{"ndcu.c", "ndcu_execute_cmd", 710, "Retry CMD %x@%d",},\
/* 0x00b8 */{"ndcu.c", "ndcu_pull_data", 536, "Mismatch %d, val %x",},\
/* 0x00b9 */{"ndcu.c", "ndcu_pull_data", 550, "FIFO is still rdy",},\
/* 0x00ba */{"ndcu.c", "ndcu_read_data_mode", 857, "Unknown device class",},\
/* 0x00bb */{"ndcu.c", "ndcu_read_id", 927, "read ID, CH %d CE %d data[%x %x]",},\
/* 0x00bc */{"ndcu.c", "ndcu_read_lun_status", 777, "LUN sts failed %x, ch %d, ce %d",},\
/* 0x00bd */{"ndcu.c", "ndcu_read_onfi_id", 916, "read ONFI ID, CH %d CE %d, data[%x]",},\
/* 0x00be */{"ndcu.c", "ndcu_read_toggle_id", 905, "read Toggle ID, CH %d CE %d data[%x%x]",},\
/* 0x00bf */{"ndcu.c", "ndcu_set_high_freq", 199, "Set type %x to %d MHz",},\
/* 0x00c0 */{"ndcu.c", "ndcu_set_timing_mode", 109, "Set Timing to %x, tm %d",},\
/* 0x00c1 */{"ndcu.c", "ndcu_wait_device_ready", 815, "read st failed %x, ch %d, ce %d",},\
/* 0x00c2 */{"ndcu_io.c", "ndcu_erase_slc_blk_demo", 113, "Erase page, ID CH: %d, CE: %d, result: %s",},\
/* 0x00c3 */{"ndcu_io.c", "ndcu_read_slc_page_demo", 159, "Read block, ID CH: %d, CE: %d, result: %s, data %x",},\
/* 0x00c4 */{"ndcu_io.c", "ndcu_wait_io_ready", 73, "read st failed %x",},\
/* 0x00c5 */{"ndcu_io.c", "ndcu_write_slc_page_demo", 206, "Write page, ID CH: %d, CE: %d, result: %s",},\
/* 0x00c6 */{"ndphy.c", "ndcu_phy_init", 704, "NAND PHY init",},\
/* 0x00c7 */{"ndphy.c", "ndcu_phy_init", 711, "NAND PHY Done",},\
/* 0x00c8 */{"ndphy.c", "ndphy_init_per_ch", 471, "CH %d PHY DLL Lock failed",},\
/* 0x00c9 */{"ndphy.c", "ndphy_init_per_ch_dll_lock", 382, "CH %d PHY DLL Lock failed",},\
/* 0x00ca */{"ndphy.c", "ndphy_loopback", 659, "NAND PHY loopback for channel %d",},\
/* 0x00cb */{"ndphy.c", "ndphy_loopback", 694, "Ch %d sts: %x",},\
/* 0x00cc */{"ndphy.c", "ndphy_set_phy_dll", 306, "PHY calc CH %d PHY DLL Lock failed",},\
/* 0x00cd */{"ficu.c", "_ficu_cmpl_fcmd_handling", 546, "TODO FICU err %x, sts %x",},\
/* 0x00ce */{"ficu.c", "ficu_clear_fcmd_error", 162, "FCMD err clean fail",},\
/* 0x00cf */{"ficu.c", "ficu_cmds_dump", 556, "FICU sts %x, CNT %x, Unc %x/%x",},\
/* 0x00d0 */{"ficu.c", "ficu_cmpl_fcmd_error_handling", 311, "FICU ERR: int sts %x, sts1 %x, sts2 %x, dec sts %x",},\
/* 0x00d1 */{"ficu.c", "ficu_cmpl_fcmd_error_handling", 318, "FCMD ID: %d FIID: %d LUTID: %d, TLC type: %d MP_ERR: %x",},\
/* 0x00d2 */{"ficu.c", "ficu_cmpl_fcmd_error_handling", 355, "ERR FCMD %p req %p, ous %d",},\
/* 0x00d3 */{"ficu.c", "ficu_cmpl_fcmd_error_handling", 367, "fcmd %p missing",},\
/* 0x00d4 */{"ficu.c", "ficu_cmpl_fcmd_error_handling", 372, "ERR col %x(%d), CH %d, dev %d, ROW %x, PDA %x",},\
/* 0x00d5 */{"ficu.c", "ficu_cmpl_fcmd_error_handling", 379, "NF err, fcmd %d, sts2 %x, power %x",},\
/* 0x00d6 */{"ficu.c", "ficu_cmpl_fcmd_error_handling", 386, "rd erased err",},\
/* 0x00d7 */{"ficu.c", "ficu_cmpl_fcmd_error_handling", 390, "rd decoding err",},\
/* 0x00d8 */{"ficu.c", "ficu_cmpl_fcmd_error_handling", 393, "rd dfu err",},\
/* 0x00d9 */{"ficu.c", "ficu_cmpl_fcmd_error_handling", 396, "rd raid err",},\
/* 0x00da */{"ficu.c", "ficu_cmpl_fcmd_error_handling", 399, "rd ovlmt err",},\
/* 0x00db */{"ficu.c", "ficu_cmpl_fcmd_error_handling", 402, "rd ncb err",},\
/* 0x00dc */{"ficu.c", "ficu_cmpl_fcmd_error_handling", 429, "wr enc err %x",},\
/* 0x00dd */{"ficu.c", "ficu_fcmd_completion", 121, "fcmd %p missing",},\
/* 0x00de */{"ficu.c", "ficu_get_finst_lut_id", 195, "FID: %d status: %x LUT_PTR %p",},\
/* 0x00df */{"ficu.c", "ficu_get_finst_lut_id", 211, "Don't find LUT ID",},\
/* 0x00e0 */{"ficu.c", "ficu_mode_disable", 840, "Abort %d CMD",},\
/* 0x00e1 */{"ficu.c", "ficu_mode_toggle", 941, "Error %d CMD",},\
/* 0x00e2 */{"ficu.c", "ficu_wait_sq_ready", 711, "err: full s-%d-queue",},\
/* 0x00e3 */{"mu_rr.c", "_nand_rr_erd_submit", 284, "ERD req %p, FCMD %d",},\
/* 0x00e4 */{"mu_rr.c", "nand_rr_erd_submit", 500, "ERD: Step %d, PB type: %d",},\
/* 0x00e5 */{"mu_rr.c", "nand_set_init_feature", 656, "NandSetFeature Mismatch, CH(%d), CE(%d), addr(0x%x), set_value(0x%x), get_value(0x%x)\n",},\
/* 0x00e6 */{"mu_rr.c", "nand_set_init_feature", 673, "NandSetFeature Mismatch, CH(%d), CE(%d), addr(0x%x), set_value(0x%x), get_value(0x%x)\n",},\
/* 0x00e7 */{"mu_rr.c", "nand_set_init_feature", 689, "NandSetFeature Mismatch, CH(%d), CE(%d), addr(0x%x), set_value(0x%x), get_value(0x%x)\n",},\
/* 0x00e8 */{"mu_rr.c", "nand_set_init_feature", 710, "NandSetFeature Mismatch, CH(%d), CE(%d), addr(0x%x), set_value(0x%x), get_value(0x%x)\n",},\
/* 0x00e9 */{"tsb_rr.c", "_nand_rr_erd_submit", 1369, "ERD req %p, FCMD %d",},\
/* 0x00ea */{"tsb_rr.c", "nand_rr_erd_submit", 1673, "ERD Step %d, PB Type: %d",},\
/* 0x00eb */{"sk_rr.c", "_nand_rr_erd_submit", 321, "ERD req %p, FCMD %d",},\
/* 0x00ec */{"sk_rr.c", "nand_get_sk_vref_setting", 366, "SLC OTP RRT invalid",},\
/* 0x00ed */{"sk_rr.c", "nand_get_sk_vref_setting", 374, "TLC OTP RRT invalid",},\
/* 0x00ee */{"sk_rr.c", "nand_rr_erd_submit", 722, "ERD Step %d, PB Type: %d",},\
/* 0x00ef */{"crypto_hw_init.c", "crypto_hw_config", 128, "Config reg=0x%x, val=0x%x",},\
/* 0x00f0 */{"crypto_hw_init.c", "crypto_hw_config", 137, "Config reg=0x%x, val=0x%x",},\
/* 0x00f1 */{"crypto_hw_init.c", "crypto_hw_config", 145, "Config reg=0x%x, val=0x%x",},\
/* 0x00f2 */{"crypto_hw_init.c", "crypto_hw_config", 154, "Config reg=0x%x, val=0x%x",},\
/* 0x00f3 */{"crypto_hw_init.c", "crypto_hw_config", 90, "..... Algoritm: SM4 .......",},\
/* 0x00f4 */{"crypto_hw_init.c", "crypto_hw_config", 92, "..... Algoritm: AES .......",},\
/* 0x00f5 */{"crypto_hw_init.c", "crypto_hw_prgm_one_key", 307, "key_index(%d), key_type(%d)",},\
/* 0x00f6 */{"crypto_hw_init.c", "crypto_hw_prgm_one_key", 318, "key1: Entry: 0 - 3",},\
/* 0x00f7 */{"crypto_hw_init.c", "crypto_hw_prgm_one_key", 326, "key1 (xts-ecb-256): Entry: 4 - 7",},\
/* 0x00f8 */{"crypto_hw_init.c", "crypto_hw_prgm_one_key", 333, "key1 (zeroes): Entry: 4 - 7",},\
/* 0x00f9 */{"crypto_hw_init.c", "crypto_hw_prgm_one_key", 342, "key2 (xts-128-256): Entry: 0 - 3",},\
/* 0x00fa */{"crypto_hw_init.c", "crypto_hw_prgm_one_key", 349, "key2 (zeroes): Entry: 0 - 3",},\
/* 0x00fb */{"crypto_hw_init.c", "crypto_hw_prgm_one_key", 357, "key2 (xts-256): Entry: 4 - 7",},\
/* 0x00fc */{"crypto_hw_init.c", "crypto_hw_prgm_one_key", 364, "key2 (zeroes): Entry: 4 - 7",},\
/* 0x00fd */{"crypto_hw_init.c", "crypto_hw_prgm_one_key", 376, "Reg=0x%x, val=0x%x",},\
/* 0x00fe */{"crypto_hw_init.c", "crypto_hw_prgm_one_key", 385, "KEY_DONE: Reg=0x%x, val=0x%x",},\
/* 0x00ff */{"crypto_hw_init.c", "crypto_hw_program_keys", 178, "......................",},\
/* 0x0100 */{"crypto_hw_init.c", "crypto_hw_program_keys", 214, "Reg=0x%x, val=0x%x",},\
/* 0x0101 */{"crypto_hw_init.c", "crypto_hw_program_keys", 225, "KEY_DONE: os=0x%x, val=0x%x",},\
/* 0x0102 */{"admin_cmd.c", "check_vsc_sig", 1190, "signature mismatch",},\
/* 0x0103 */{"admin_cmd.c", "nvme_vu_erase_eventlog", 1549, "Event log is writing/flushing",},\
/* 0x0104 */{"admin_cmd.c", "nvme_vu_get_grwn_defect", 1862, "get spb info data xfer: DMA xfer(%d)",},\
/* 0x0105 */{"admin_cmd.c", "nvme_vu_securerase", 3864, "VU_FRB_ERASE",},\
/* 0x0106 */{"admin_cmd.c", "nvme_vu_securerase", 3886, "PB (%d) Erase GO",},\
/* 0x0107 */{"admin_cmd.c", "nvme_vu_securerase", 3899, "PB (%d) Erase done",},\
/* 0x0108 */{"admin_cmd.c", "nvmet_abort", 3621, "QID(%d) CID(%d) out of (#%d), aborting",},\
/* 0x0109 */{"admin_cmd.c", "nvmet_abort", 3626, "req (%x) Ctag(%x) Op(%d) exec time (%d)ms",},\
/* 0x010a */{"admin_cmd.c", "nvmet_admin_aer_out", 4892, "Req (%x) AER masked",},\
/* 0x010b */{"admin_cmd.c", "nvmet_admin_cmd_in", 4854, "req(%x) rslt(%d)",},\
/* 0x010c */{"admin_cmd.c", "nvmet_admin_xfer_abort", 4179, "req(%x) opc %d aborted",},\
/* 0x010d */{"admin_cmd.c", "nvmet_admin_xfer_done", 4276, "req(%x) xfered sts=(%d)",},\
/* 0x010e */{"admin_cmd.c", "nvmet_asq_handle", 4010, "req(%x) Admin opcode(%x): %s",},\
/* 0x010f */{"admin_cmd.c", "nvmet_asq_handle", 4015, "SET_FACTCMD",},\
/* 0x0110 */{"admin_cmd.c", "nvmet_asq_handle", 4019, "GET_FACTCMD",},\
/* 0x0111 */{"admin_cmd.c", "nvmet_asq_handle", 4023, "GET_NANDCMD",},\
/* 0x0112 */{"admin_cmd.c", "nvmet_asq_handle", 4027, "GET_DISKCMD",},\
/* 0x0113 */{"admin_cmd.c", "nvmet_asq_handle", 4031, "NVME_OPC_VU_GET_FW_INFO",},\
/* 0x0114 */{"admin_cmd.c", "nvmet_asq_handle", 4035, "NVME_OPC_VU_ERASE_FW_BLK",},\
/* 0x0115 */{"admin_cmd.c", "nvmet_asq_handle", 4039, "NVME_OPC_VU_WARM_REBOOT",},\
/* 0x0116 */{"admin_cmd.c", "nvmet_asq_handle", 4043, "NVME_OPC_VU_SET_DISK_CAPACITY",},\
/* 0x0117 */{"admin_cmd.c", "nvmet_asq_handle", 4047, "NVME_OPC_VU_TEST_CMD_IN",},\
/* 0x0118 */{"admin_cmd.c", "nvmet_asq_handle", 4051, "NVME_OPC_VU_SET_WARN_CRI_THRE",},\
/* 0x0119 */{"admin_cmd.c", "nvmet_asq_handle", 4064, "NVME_OPC_VU_ERASE_EVENTLOG",},\
/* 0x011a */{"admin_cmd.c", "nvmet_asq_handle", 4068, "NVME_OPC_VU_FTL_VIRGIN",},\
/* 0x011b */{"admin_cmd.c", "nvmet_asq_handle", 4072, "NVME_OPC_VU_SETDEVICEINFO",},\
/* 0x011c */{"admin_cmd.c", "nvmet_asq_handle", 4076, "NVME_OPC_VU_CMD_F7",},\
/* 0x011d */{"admin_cmd.c", "nvmet_asq_handle", 4080, "TS_INJECTION CMD",},\
/* 0x011e */{"admin_cmd.c", "nvmet_asq_handle", 4084, "NVME_OPC_VU_ERRINJECTION",},\
/* 0x011f */{"admin_cmd.c", "nvmet_asq_handle", 4088, "NVME_OPC_VU_SMARTCLEAN",},\
/* 0x0120 */{"admin_cmd.c", "nvmet_asq_handle", 4092, "NVME_OPC_VU_GET_GRWN_DEFECT",},\
/* 0x0121 */{"admin_cmd.c", "nvmet_asq_handle", 4167, "req(%x) Admin opcode(%x) CE: SCT(%x) SC(%x)",},\
/* 0x0122 */{"admin_cmd.c", "nvmet_create_io_sq", 446, "create I/O SQ (%d) pairs CQ (%d)",},\
/* 0x0123 */{"admin_cmd.c", "nvmet_delete_io_cq", 329, "Delete I/O CQ (%d)",},\
/* 0x0124 */{"admin_cmd.c", "nvmet_delete_io_sq", 390, "Delete I/O SQ (%d)",},\
/* 0x0125 */{"admin_cmd.c", "nvmet_feat_set_arbitration", 2614, "Artbration (0x%x) -> (0x%x)",},\
/* 0x0126 */{"admin_cmd.c", "nvmet_feat_set_async_event_conf", 2914, "Async Event Conf (0x%x) -> (0x%x)",},\
/* 0x0127 */{"admin_cmd.c", "nvmet_feat_set_error_recovery", 2939, "Err recovery (0x%x) -> (0x%x)",},\
/* 0x0128 */{"admin_cmd.c", "nvmet_feat_set_host_memory", 3193, "Host Memory Buffer set, MR(%d) EN(%d) size(%d KB)",},\
/* 0x0129 */{"admin_cmd.c", "nvmet_feat_set_host_memory", 3217, "Pull HMDEL %x%x, cnt %d, %d bytes",},\
/* 0x012a */{"admin_cmd.c", "nvmet_feat_set_number_of_queues", 2594, "Request ncqr/nsqr (%d/%d) and Allocate sq/cq (%d/%d)",},\
/* 0x012b */{"admin_cmd.c", "nvmet_feat_set_power_management", 3003, "WH (%d) Power State (%d) -> (%d)",},\
/* 0x012c */{"admin_cmd.c", "nvmet_feat_set_tempture_threshold", 2698, "Tempture Threshold %d(%d) (0x%x) -> (0x%x)",},\
/* 0x012d */{"admin_cmd.c", "nvmet_feat_set_volatile_wr_cache", 3157, "Volatile Write Cache (0x%x) -> (0x%x)",},\
/* 0x012e */{"admin_cmd.c", "nvmet_feat_set_write_atomic", 2823, "Write Automic Normal (0x%x) -> (0x%x)",},\
/* 0x012f */{"admin_cmd.c", "nvmet_firmware_commit", 1083, "Commit ca:%d",},\
/* 0x0130 */{"admin_cmd.c", "nvmet_firmware_image_download", 1115, "NUMD(%d) OFFSET(%d) PRP1(%x) PRP2(%x)",},\
/* 0x0131 */{"admin_cmd.c", "nvmet_firmware_image_download", 1119, "download fw NUMD(%d) OFFSET(%d) not 4K alignment",},\
/* 0x0132 */{"admin_cmd.c", "nvmet_format_hmb_reset_done", 1956, "hmb reset done",},\
/* 0x0133 */{"admin_cmd.c", "nvmet_format_ns", 2015, "format %x",},\
/* 0x0134 */{"admin_cmd.c", "nvmet_get_feature", 3476, "get feature: fid=%x",},\
/* 0x0135 */{"admin_cmd.c", "nvmet_get_log_page", 1018, "LID(%d) NUMD(%d) PRP1(%x) PRP2(%x)",},\
/* 0x0136 */{"admin_cmd.c", "nvmet_get_log_page", 1040, "No support %d",},\
/* 0x0137 */{"admin_cmd.c", "nvmet_get_lp_cmd_effects_log", 975, "get cmd effects log xfer: DMA xfer(%d)",},\
/* 0x0138 */{"admin_cmd.c", "nvmet_get_lp_health_information", 748, "smart error %x",},\
/* 0x0139 */{"admin_cmd.c", "nvmet_get_lp_log_error", 660, "Valid(%d) Pos(%d)",},\
/* 0x013a */{"admin_cmd.c", "nvmet_get_spb_info", 1922, "get spb info data xfer: DMA xfer(%d)",},\
/* 0x013b */{"admin_cmd.c", "nvmet_identify", 2417, "CNS(%d) NSID(%d) CNTID(%d)",},\
/* 0x013c */{"admin_cmd.c", "nvmet_identify", 2425, "nvmet_identify: No such controller id %x",},\
/* 0x013d */{"admin_cmd.c", "nvmet_identify", 2438, "Identify: Invalid namespace (0x%x)",},\
/* 0x013e */{"admin_cmd.c", "nvmet_identify", 2468, "NSID(%d) isn't Active",},\
/* 0x013f */{"admin_cmd.c", "nvmet_identify", 2485, "Identify: Invalid namespace (0x%x)",},\
/* 0x0140 */{"admin_cmd.c", "nvmet_identify", 2525, "Identify: (NSL) Invalid namespace (%d)",},\
/* 0x0141 */{"admin_cmd.c", "nvmet_identify", 2561, "Identify: CNS(%d) DMA xfer(%d)",},\
/* 0x0142 */{"admin_cmd.c", "nvmet_queue_sanity_check", 297, "req(%x) qid(%x)",},\
/* 0x0143 */{"admin_cmd.c", "nvmet_queue_sanity_check", 305, "req(%x) qsize(%x)",},\
/* 0x0144 */{"admin_cmd.c", "nvmet_security_cmd", 3702, "req(%x) opcode(%x) len %x",},\
/* 0x0145 */{"admin_cmd.c", "nvmet_security_cmd", 3703, "protocol(%x) ComId(%x)",},\
/* 0x0146 */{"admin_cmd.c", "nvmet_security_mem_free", 3672, "req(%x) opcode(%x)",},\
/* 0x0147 */{"admin_cmd.c", "nvmet_security_mem_rdy", 3688, "req(%x) opcode(%x)",},\
/* 0x0148 */{"admin_cmd.c", "nvmet_set_feature", 3378, "set feature: fid=%x",},\
/* 0x0149 */{"admin_cmd.c", "nvmet_set_spb_info", 1336, "total spb cnt mismatch. should be %d but %d",},\
/* 0x014a */{"admin_cmd.c", "nvmet_set_spb_info", 1340, "total spb cnt match",},\
/* 0x014b */{"admin_cmd.c", "set_device_info", 1221, "Invalid option for setting device info!",},\
/* 0x014c */{"admin_cmd.c", "set_warn_cri_thre", 1248, "Invalid option for setting warning/critical threshold!",},\
/* 0x014d */{"admin_cmd.c", "setfactoryinfo", 3758, "opsetting: %d",},\
/* 0x014e */{"core.c", "bool", 224, "NS update cap(%x -> %x), lbads(%d -> %d)",},\
/* 0x014f */{"core.c", "err_injection_main", 1891, "smart_err_num(%d)\n",},\
/* 0x0150 */{"core.c", "err_injection_main", 1895, "error injection done\n",},\
/* 0x0151 */{"core.c", "fill_lookup_pda_done", 1524, "hmb lookup error",},\
/* 0x0152 */{"core.c", "nvmet_abort_all_running_reqs", 1203, "[%d] req 0x%p(%d) state(%d) abt #Dtags(%d), rt(%d)",},\
/* 0x0153 */{"core.c", "nvmet_abort_all_running_reqs", 1214, "all abort wreq 0x%p %d LBA 0x%x%d(%d)",},\
/* 0x0154 */{"core.c", "nvmet_abort_all_running_reqs", 1236, "all abort wreq cnt %d %d %d",},\
/* 0x0155 */{"core.c", "nvmet_abort_running_req", 411, "abort admin %x opc %d",},\
/* 0x0156 */{"core.c", "nvmet_abort_running_req", 486, "wr %x st %d fua %d xfer done",},\
/* 0x0157 */{"core.c", "nvmet_abort_running_req", 512, "trim req 0x%x state %d done in advance",},\
/* 0x0158 */{"core.c", "nvmet_abort_running_req", 530, "no handle op in %p %d %d",},\
/* 0x0159 */{"core.c", "nvmet_aer_error_status", 1383, "SQ(%d) Invalid Queue",},\
/* 0x015a */{"core.c", "nvmet_aer_smart_health", 1433, "available spare(%d) < thr(%d)",},\
/* 0x015b */{"core.c", "nvmet_clear_aer", 1000, "abort #(%d) AER commands",},\
/* 0x015c */{"core.c", "nvmet_clear_io_queue", 1029, "Outstanding #AER(%d)",},\
/* 0x015d */{"core.c", "nvmet_clear_io_queue", 1035, "abort #(%d) AER commands",},\
/* 0x015e */{"core.c", "nvmet_core_cmd_done", 719, "req(%p) Ctags(%d) resubmit ",},\
/* 0x015f */{"core.c", "nvmet_core_err_cmd_done", 651, "abort done",},\
/* 0x0160 */{"core.c", "nvmet_evt_cc_en", 1325, "\033[91mCC.EN (0->1)\x1b[0m",},\
/* 0x0161 */{"core.c", "nvmet_evt_handle_err_cmd", 855, "req(%p) Ctags(%d) sts=(0x%x)",},\
/* 0x0162 */{"core.c", "nvmet_evt_handle_err_cmd", 866, "slba %d, cnt %d",},\
/* 0x0163 */{"core.c", "nvmet_evt_handle_err_cmd", 871, "prp 1 %x %x",},\
/* 0x0164 */{"core.c", "nvmet_evt_handle_err_cmd", 876, "prp2 %x %x",},\
/* 0x0165 */{"core.c", "nvmet_evt_handle_err_cmd", 880, "PCIE timeout op %d left %d [%x %x]\n",},\
/* 0x0166 */{"core.c", "nvmet_evt_handle_err_cmd", 888, "cmd err sct %d sc %d",},\
/* 0x0167 */{"core.c", "nvmet_evt_shutdown", 1260, "shutdown abort",},\
/* 0x0168 */{"core.c", "nvmet_evt_shutdown", 1265, "\033[91mCC.EN (1->0)\x1b[0m, isr %d",},\
/* 0x0169 */{"core.c", "nvmet_evt_shutdown", 1288, "alreay flushed",},\
/* 0x016a */{"core.c", "nvmet_fe_shutdown_done", 1106, "skip shutdown cb %d",},\
/* 0x016b */{"core.c", "nvmet_init_apl", 2025, "FactoryInfo NG",},\
/* 0x016c */{"core.c", "nvmet_init_apl", 2029, "FactoryInfo OK",},\
/* 0x016d */{"core.c", "nvmet_preset_detach", 1716, "preset detach. r1(0x%x), r2(0x%x)",},\
/* 0x016e */{"core.c", "nvmet_preset_detach", 1733, "HMB detach by preset",},\
/* 0x016f */{"core.c", "nvmet_put_req", 175, "req %d ctag %d exceed %d ms",},\
/* 0x0170 */{"core.c", "nvmet_reqs_dump", 1148, "Running NVM(e) Cmd (%d)",},\
/* 0x0171 */{"core.c", "nvmet_reqs_dump", 1155, "sq req 0x%p(op %d) state %d ctag %d",},\
/* 0x0172 */{"core.c", "nvmet_reqs_dump", 1157, "auto_cpl %d auto_done %d ctag_done %d err %d",},\
/* 0x0173 */{"core.c", "nvmet_reqs_dump", 1166, "aborting req 0x%p(op %d) state %d ctag %d",},\
/* 0x0174 */{"core.c", "nvmet_reqs_dump", 1168, "auto_cpl %d auto_done %d ctag_done %d err %d",},\
/* 0x0175 */{"core.c", "nvmet_restore_feat", 292, "def feat used",},\
/* 0x0176 */{"core.c", "nvmet_set_factory_info_done", 941, "Ignore Capacity Change %d GB, max %d",},\
/* 0x0177 */{"core.c", "nvmet_set_factory_info_done", 945, "Capacity Change!! (%d -> %d)GB",},\
/* 0x0178 */{"core.c", "nvmet_set_factory_info_done", 957, "SET_FACTINFO_cmpl",},\
/* 0x0179 */{"core.c", "nvmet_sq_timer_chk", 563, "sq %d set priority",},\
/* 0x017a */{"core.c", "nvmet_sq_timer_chk", 583, "req 0x%p timeout(%d ms), ctag(%d), op(%d) cmd(0x%p) %d",},\
/* 0x017b */{"core.c", "nvmet_sq_timer_chk", 596, "skip aborting wreq",},\
/* 0x017c */{"core.c", "nvmet_start_warm_boot", 1809, "abort #(%d) AER commands",},\
/* 0x017d */{"core.c", "nvmet_start_warm_boot", 1823, "warm boot disable sq OK",},\
/* 0x017e */{"io_cmd.c", "nvmet_abort_locked_req", 1156, "abort locked req(%d) %p",},\
/* 0x017f */{"io_cmd.c", "nvmet_abort_pending_req", 1122, "abort pending req(%d) %p",},\
/* 0x0180 */{"io_cmd.c", "nvmet_bootpart_read", 1060, "BPR: ofst (%x), len (%x) -> mem (0x%p%p)",},\
/* 0x0181 */{"io_cmd.c", "nvmet_io_cmd_ex", 919, "priority iosq %d",},\
/* 0x0182 */{"io_cmd.c", "nvmet_read_qos", 458, "tgt %d, pnd %d, act %d, CID %d, sts %d",},\
/* 0x0183 */{"io_cmd.c", "nvmet_setup_discard", 579, "trim ad is zero, complete",},\
/* 0x0184 */{"io_cmd.c", "nvmet_setup_discard", 586, "trim: lack of dtag",},\
/* 0x0185 */{"io_cmd.c", "nvmet_setup_rw", 205, "req(%p) Ctag(%d) CID(%d) dir(%d) SLBA (0x%x) NLB (%d)",},\
/* 0x0186 */{"io_cmd.c", "nvmet_setup_rw", 212, "req(%p) Ctag(%d) CID(%d) dir(%d) SLBA (0x%x) NLB (%d)",},\
/* 0x0187 */{"io_cmd.c", "nvmet_setup_rw", 216, "Block I/O because of reaching tmt2",},\
/* 0x0188 */{"io_cmd.c", "nvmet_sq_handle", 687, "Block I/O because of reaching tmt2",},\
/* 0x0189 */{"io_cmd.c", "nvmet_sq_handle", 765, "No submit handler for NS(%d)",},\
/* 0x018a */{"io_cmd.c", "read_q_req", 426, "tgt %d, pnd %d, act %d, CID %d",},\
/* 0x018b */{"io_cmd.c", "read_q_reset", 330, "req q[%d] act %d -> 0\n",},\
/* 0x018c */{"io_cmd.c", "read_q_sched", 400, "tgt %d, pnd %d, act %d, CID %d, sts %d",},\
/* 0x018d */{"security_api.c", "dpe_sm2_cal_cmpl", 449, "..... Start",},\
/* 0x018e */{"security_api.c", "dpe_sm2_cal_cmpl", 452, "KG Result",},\
/* 0x018f */{"security_api.c", "dpe_sm2_cal_cmpl", 474, "[%d] Px:%x Py:%x",},\
/* 0x0190 */{"security_api.c", "dpe_sm2_cal_cmpl", 476, "Data mismatch",},\
/* 0x0191 */{"security_api.c", "dpe_sm2_cal_cmpl", 484, "SN (signature) Result",},\
/* 0x0192 */{"security_api.c", "dpe_sm2_cal_cmpl", 503, "[%d] R:%x S:%x",},\
/* 0x0193 */{"security_api.c", "dpe_sm2_cal_cmpl", 505, "Data mismatch",},\
/* 0x0194 */{"security_api.c", "dpe_sm2_cal_cmpl", 513, "VF (Verify) result:",},\
/* 0x0195 */{"security_api.c", "dpe_sm2_cal_cmpl", 515, "Result[%d] %x ",},\
/* 0x0196 */{"security_api.c", "dpe_sm2_cal_cmpl", 519, "PASS",},\
/* 0x0197 */{"security_api.c", "dpe_sm2_cal_cmpl", 521, "FAIL",},\
/* 0x0198 */{"security_api.c", "dpe_sm2_cal_cmpl", 526, "LP result: ",},\
/* 0x0199 */{"security_api.c", "dpe_sm2_cal_cmpl", 537, "[%d] lp_px:%x lp_py:%x",},\
/* 0x019a */{"security_api.c", "dpe_sm2_cal_cmpl", 539, "LP data error!",},\
/* 0x019b */{"security_api.c", "dpe_sm2_cal_cmpl", 551, "SM2 result error. No valid func_sel!",},\
/* 0x019c */{"security_api.c", "dpe_sm2_cal_cmpl", 558, "..... End",},\
/* 0x019d */{"security_api.c", "sec_gen_rand_number", 408, "Pull one random number",},\
/* 0x019e */{"security_api.c", "sec_gen_rand_number", 425, "%x",},\
/* 0x019f */{"security_api.c", "sec_gen_sha3_sm3_hash", 1126, ".... Start",},\
/* 0x01a0 */{"security_api.c", "sec_gen_sha3_sm3_hash", 1129, "sha3_256: sec_gen_sha3_256_hash() msg_len(%d)",},\
/* 0x01a1 */{"security_api.c", "sec_gen_sha3_sm3_hash", 1132, "sm3: sec_gen_sm3_hash()-msg_len(%d)",},\
/* 0x01a2 */{"security_api.c", "sec_gen_sha3_sm3_hash", 1155, ".... Done",},\
/* 0x01a3 */{"security_api.c", "sec_sha3_256_cal_cmpl", 1025, "sha3_256 message:",},\
/* 0x01a4 */{"security_api.c", "sec_sha3_256_cal_cmpl", 1027, "%x %x ",},\
/* 0x01a5 */{"security_api.c", "sec_sha3_256_cal_cmpl", 1032, "sha3_256 hw result: hash",},\
/* 0x01a6 */{"security_api.c", "sec_sha3_256_cal_cmpl", 1034, "%x %x ",},\
/* 0x01a7 */{"security_api.c", "sec_sha3_256_cal_cmpl", 1040, "sha3_256 Expected hash",},\
/* 0x01a8 */{"security_api.c", "sec_sha3_256_cal_cmpl", 1042, "%x %x ",},\
/* 0x01a9 */{"security_api.c", "sec_sm2_decrypt", 1437, "sec_sm2_decrypt(): LP (c1_x2_y2) done",},\
/* 0x01aa */{"security_api.c", "sec_sm2_decrypt", 1451, "sec_sm2_decrypt(): SM3 hash (t) done",},\
/* 0x01ab */{"security_api.c", "sec_sm2_decrypt", 1454, "sec_sm2_decrypt(): t = 0, FAILED",},\
/* 0x01ac */{"security_api.c", "sec_sm2_decrypt", 1464, "sec_sm2_decrypt(): XOR (pmsg) done",},\
/* 0x01ad */{"security_api.c", "sec_sm2_decrypt", 1477, "sec_sm2_decrypt(): SM3 hash (u) done",},\
/* 0x01ae */{"security_api.c", "sec_sm2_decrypt", 1482, "sec_sm2_decrypt(): u!=C3, FAILED",},\
/* 0x01af */{"security_api.c", "sec_sm2_decrypt", 1488, "sec_sm2_decrypt(): u==C3, PASSED",},\
/* 0x01b0 */{"security_api.c", "sec_sm2_encrypt", 1287, "sec_sm2_encrypt(): [K]G (C1) done",},\
/* 0x01b1 */{"security_api.c", "sec_sm2_encrypt", 1291, "sec_sm2_encrypt(): C1 = 0, FAILED",},\
/* 0x01b2 */{"security_api.c", "sec_sm2_encrypt", 1301, "sec_sm2_encrypt(): LP (t_x2_y2) done",},\
/* 0x01b3 */{"security_api.c", "sec_sm2_encrypt", 1303, "%x %x %x %x",},\
/* 0x01b4 */{"security_api.c", "sec_sm2_encrypt", 1315, "sec_sm2_encrypt(): SM3 hash (t) done",},\
/* 0x01b5 */{"security_api.c", "sec_sm2_encrypt", 1317, "sec_sm2_encrypt(): t = 0, FAILED",},\
/* 0x01b6 */{"security_api.c", "sec_sm2_encrypt", 1334, "sec_sm2_encrypt(): XOR (C2) done",},\
/* 0x01b7 */{"security_api.c", "sec_sm2_encrypt", 1346, "sec_sm2_encrypt(): SM3 hash (C3) done",},\
/* 0x01b8 */{"security_api.c", "sec_sm2_encrypt", 1357, "sec_sm2_encrypt(): cmsg = (C1 || C3 || C2) done",},\
/* 0x01b9 */{"security_api.c", "sec_sm2_gen_key_pair", 601, ".... Start",},\
/* 0x01ba */{"security_api.c", "sec_sm2_gen_key_pair", 624, ".... Done",},\
/* 0x01bb */{"security_api.c", "sec_sm2_get_pub_key", 660, ".... Start",},\
/* 0x01bc */{"security_api.c", "sec_sm2_get_pub_key", 683, ".... Done",},\
/* 0x01bd */{"security_api.c", "sec_sm2_lp", 867, ".... Start",},\
/* 0x01be */{"security_api.c", "sec_sm2_lp", 897, ".... Done",},\
/* 0x01bf */{"security_api.c", "sec_sm2_sign", 721, ".... Start",},\
/* 0x01c0 */{"security_api.c", "sec_sm2_sign", 755, ".... Done",},\
/* 0x01c1 */{"security_api.c", "sec_sm2_verify", 794, ".... Start",},\
/* 0x01c2 */{"security_api.c", "sec_sm2_verify", 827, ".... Done",},\
/* 0x01c3 */{"security_api.c", "sec_sm3_cal_cmpl", 941, "sm3 message:",},\
/* 0x01c4 */{"security_api.c", "sec_sm3_cal_cmpl", 944, "%x %x %x %x ",},\
/* 0x01c5 */{"security_api.c", "sec_sm3_cal_cmpl", 950, "%x ",},\
/* 0x01c6 */{"security_api.c", "sec_sm3_cal_cmpl", 952, "%x %x",},\
/* 0x01c7 */{"security_api.c", "sec_sm3_cal_cmpl", 958, "hw result: hash",},\
/* 0x01c8 */{"security_api.c", "sec_sm3_cal_cmpl", 960, "%x %x %x %x ",},\
/* 0x01c9 */{"security_api.c", "sec_sm3_cal_cmpl", 967, "Expected hash",},\
/* 0x01ca */{"security_api.c", "sec_sm3_cal_cmpl", 969, "%x %x %x %x ",},\
/* 0x01cb */{"security_api.c", "sec_ss_key_wp_uwp", 1603, ".... Start",},\
/* 0x01cc */{"security_api.c", "sec_ss_key_wp_uwp", 1616, ".... Done",},\
/* 0x01cd */{"security_api.c", "sec_ss_key_wp_uwp_cmpl", 1567, ".... Complete",},\
/* 0x01ce */{"security_api.c", "sec_ss_rn_gen", 1508, ".... Start",},\
/* 0x01cf */{"security_api.c", "sec_ss_rn_gen", 1516, ".... Done",},\
/* 0x01d0 */{"security_api.c", "sec_ss_rn_gen_cmpl", 1072, "... SS RN PASS. trng_chk_flag(%d)",},\
/* 0x01d1 */{"security_api.c", "sec_ss_spr_prgm", 1542, ".... Start",},\
/* 0x01d2 */{"security_api.c", "sec_ss_spr_prgm", 1551, ".... Done",},\
/* 0x01d3 */{"security_api.c", "sec_ss_spr_prgm_cmpl", 1089, "... SPR Program done",},\
/* 0x01d4 */{"security_api.c", "test_sec_sha3_256", 1854, "test_sec_sha3_256(): start",},\
/* 0x01d5 */{"security_api.c", "test_sec_sha3_256", 1857, "test_sec_sha3_256(): HASH value returned.................",},\
/* 0x01d6 */{"security_api.c", "test_sec_sha3_256", 1859, "%x %x %x %x",},\
/* 0x01d7 */{"security_api.c", "test_sec_sha3_256", 1863, "test_sec_sha3_256(): end",},\
/* 0x01d8 */{"security_api.c", "test_sec_sha3_256", 1865, "test_sec_sha3_256(): not started, msg len(%d)",},\
/* 0x01d9 */{"security_api.c", "test_sec_sm2_encrypt", 1930, ">> End of sec_sm2_gen_key_pair(): pri_key",},\
/* 0x01da */{"security_api.c", "test_sec_sm2_encrypt", 1932, "%x %x %x %x",},\
/* 0x01db */{"security_api.c", "test_sec_sm2_encrypt", 1935, ">> End of sec_sm2_gen_key_pair(): pub_key",},\
/* 0x01dc */{"security_api.c", "test_sec_sm2_encrypt", 1937, "%x %x %x %x",},\
/* 0x01dd */{"security_api.c", "test_sec_sm2_encrypt", 1964, "Decrypted message: Return status(%d)",},\
/* 0x01de */{"security_api.c", "test_sec_sm2_encrypt", 1966, "%x %x %x %x ",},\
/* 0x01df */{"security_api.c", "test_sec_sm2_encrypt", 1971, "SM2 encrypt() FAILED: reason(%d)",},\
/* 0x01e0 */{"security_api.c", "test_sec_sm2_gen_key_pair", 1643, ">> End of sec_sm2_gen_key_pair(): pri_key",},\
/* 0x01e1 */{"security_api.c", "test_sec_sm2_gen_key_pair", 1645, "%x %x %x %x",},\
/* 0x01e2 */{"security_api.c", "test_sec_sm2_gen_key_pair", 1648, ">> End of sec_sm2_gen_key_pair(): pub_key",},\
/* 0x01e3 */{"security_api.c", "test_sec_sm2_gen_key_pair", 1650, "%x %x %x %x",},\
/* 0x01e4 */{"security_api.c", "test_sec_sm2_get_pub_key", 1676, ">> End of sec_sm2_get_pub_key(): pri_key",},\
/* 0x01e5 */{"security_api.c", "test_sec_sm2_get_pub_key", 1678, "%x %x %x %x",},\
/* 0x01e6 */{"security_api.c", "test_sec_sm2_get_pub_key", 1681, ">> End of sec_sm2_get_pub_key(): pub_key",},\
/* 0x01e7 */{"security_api.c", "test_sec_sm2_get_pub_key", 1683, "%x %x %x %x",},\
/* 0x01e8 */{"security_api.c", "test_sec_sm2_lp", 1802, ">> End of sec_sm2_lp():",},\
/* 0x01e9 */{"security_api.c", "test_sec_sm2_sign", 1722, ">> End of sec_sm2_sign(): signature",},\
/* 0x01ea */{"security_api.c", "test_sec_sm2_sign", 1724, "%x %x %x %x",},\
/* 0x01eb */{"security_api.c", "test_sec_sm2_verify", 1768, ">> End of sec_sm2_verify():",},\
/* 0x01ec */{"security_api.c", "test_sec_sm3", 1822, "test_sec_sm3(): start",},\
/* 0x01ed */{"security_api.c", "test_sec_sm3", 1825, "test_sec_sm3(): HASH value returned.................",},\
/* 0x01ee */{"security_api.c", "test_sec_sm3", 1827, "%x %x %x %x",},\
/* 0x01ef */{"security_api.c", "test_sec_sm3", 1831, "test_sec_sm3(): end",},\
/* 0x01f0 */{"security_api.c", "test_sec_sm3", 1833, "test_sec_sm3(): not started, msg len(%d)",},\
/* 0x01f1 */{"security_api.c", "test_ss_key_wp_uwp", 2088, ".... Start",},\
/* 0x01f2 */{"security_api.c", "test_ss_key_wp_uwp", 2242, "..... NO VALID TEST VECTOR SELECTED",},\
/* 0x01f3 */{"security_api.c", "test_ss_key_wp_uwp", 2311, "CFP ..... ENABLED",},\
/* 0x01f4 */{"security_api.c", "test_ss_key_wp_uwp", 2314, "CFP ..... DISABLED",},\
/* 0x01f5 */{"security_api.c", "test_ss_key_wp_uwp", 2327, "CFP ..... ENABLED",},\
/* 0x01f6 */{"security_api.c", "test_ss_key_wp_uwp", 2330, "CFP ..... DISABLED",},\
/* 0x01f7 */{"security_api.c", "test_ss_key_wp_uwp", 2407, "CFP ..... ENABLED",},\
/* 0x01f8 */{"security_api.c", "test_ss_key_wp_uwp", 2410, "CFP ..... DISABLED",},\
/* 0x01f9 */{"security_api.c", "test_ss_key_wp_uwp", 2423, "CFP ..... ENABLED",},\
/* 0x01fa */{"security_api.c", "test_ss_key_wp_uwp", 2426, "CFP ..... DISABLED",},\
/* 0x01fb */{"security_api.c", "test_ss_key_wp_uwp", 2440, "..... NO VALID TEST VECTOR SELECTED",},\
/* 0x01fc */{"security_api.c", "test_ss_key_wp_uwp", 2452, "AES_256B_KWP_NO_SECURE ..... PASS",},\
/* 0x01fd */{"security_api.c", "test_ss_key_wp_uwp", 2454, "AES_256B_KWP_NO_SECURE ..... FAIL",},\
/* 0x01fe */{"security_api.c", "test_ss_key_wp_uwp", 2459, "AES_256B_KUWP_NO_SECURE ..... PASS",},\
/* 0x01ff */{"security_api.c", "test_ss_key_wp_uwp", 2461, "AES_256B_KUWP_NO_SECURE ..... FAIL",},\
/* 0x0200 */{"security_api.c", "test_ss_key_wp_uwp", 2466, "AES_256B_RAW_ENCRYPT ..... PASS",},\
/* 0x0201 */{"security_api.c", "test_ss_key_wp_uwp", 2468, "AES_256B_RAW_ENCRYPT ..... FAIL",},\
/* 0x0202 */{"security_api.c", "test_ss_key_wp_uwp", 2473, "AES_256B_RAW_DECRYPT ..... PASS",},\
/* 0x0203 */{"security_api.c", "test_ss_key_wp_uwp", 2475, "AES_256B_RAW_DECRYPT ..... FAIL",},\
/* 0x0204 */{"security_api.c", "test_ss_key_wp_uwp", 2480, "AES_256B_KWP_SECURE_NO_CFP ..... PASS",},\
/* 0x0205 */{"security_api.c", "test_ss_key_wp_uwp", 2482, "AES_256B_KWP_SECURE_NO_CFP ..... FAIL",},\
/* 0x0206 */{"security_api.c", "test_ss_key_wp_uwp", 2487, "AES_256B_KUWP_SECURE_NO_CFP ..... PASS",},\
/* 0x0207 */{"security_api.c", "test_ss_key_wp_uwp", 2489, "AES_256B_KUWP_SECURE_NO_CFP ..... FAIL",},\
/* 0x0208 */{"security_api.c", "test_ss_key_wp_uwp", 2494, "AES_256B_KWP_SECURE_CFP ..... PASS",},\
/* 0x0209 */{"security_api.c", "test_ss_key_wp_uwp", 2497, "AES_256B_KUWP_SECURE_CFP ..... PASS",},\
/* 0x020a */{"security_api.c", "test_ss_key_wp_uwp", 2504, "SM4_128B_KWP_NO_SECURE ..... PASS",},\
/* 0x020b */{"security_api.c", "test_ss_key_wp_uwp", 2506, "SM4_128B_KWP_NO_SECURE ..... FAIL",},\
/* 0x020c */{"security_api.c", "test_ss_key_wp_uwp", 2511, "SM4_128B_KUWP_NO_SECURE ..... PASS",},\
/* 0x020d */{"security_api.c", "test_ss_key_wp_uwp", 2513, "SM4_128B_KUWP_NO_SECURE ..... FAIL",},\
/* 0x020e */{"security_api.c", "test_ss_key_wp_uwp", 2518, "SM4_128B_RAW_ENCRYPT ..... PASS",},\
/* 0x020f */{"security_api.c", "test_ss_key_wp_uwp", 2520, "SM4_128B_RAW_ENCRYPT ..... FAIL",},\
/* 0x0210 */{"security_api.c", "test_ss_key_wp_uwp", 2525, "SM4_128B_RAW_DECRYPT ..... PASS",},\
/* 0x0211 */{"security_api.c", "test_ss_key_wp_uwp", 2527, "SM4_128B_RAW_DECRYPT ..... FAIL",},\
/* 0x0212 */{"security_api.c", "test_ss_key_wp_uwp", 2532, "SM4_128B_KWP_SECURE_NO_CFP ..... PASS",},\
/* 0x0213 */{"security_api.c", "test_ss_key_wp_uwp", 2534, "SM4_128B_KWP_SECURE_NO_CFP ..... FAIL",},\
/* 0x0214 */{"security_api.c", "test_ss_key_wp_uwp", 2539, "SM4_128B_KUWP_SECURE_NO_CFP ..... PASS",},\
/* 0x0215 */{"security_api.c", "test_ss_key_wp_uwp", 2541, "SM4_128B_KUWP_SECURE_NO_CFP ..... FAIL",},\
/* 0x0216 */{"security_api.c", "test_ss_key_wp_uwp", 2546, "SM4_128B_KWP_SECURE_CFP ..... PASS",},\
/* 0x0217 */{"security_api.c", "test_ss_key_wp_uwp", 2549, "SM4_128B_KUWP_SECURE_CFP ..... PASS",},\
/* 0x0218 */{"security_api.c", "test_ss_key_wp_uwp", 2553, "..... NO VALID TEST VECTOR SELECTED",},\
/* 0x0219 */{"security_api.c", "test_ss_rn_gen", 1990, ".... Start",},\
/* 0x021a */{"security_api.c", "test_ss_spr_prgm", 2012, ".... Start",},\
/* 0x021b */{"security_api.c", "trng_ctrl", 352, "Random number generated",},\
/* 0x021c */{"security_api.c", "trng_ctrl", 362, "Reseed done",},\
/* 0x021d */{"security_api.c", "trng_ctrl", 366, "cmd type error",},\
/* 0x021e */{"security_cmd.c", "convert_to_u64", 1167, "0x00: u64_data(H:0x%x, L:0x%x)",},\
/* 0x021f */{"security_cmd.c", "convert_to_u64", 1173, "0x81: u64_data(H:0x%x, L:0x%x)",},\
/* 0x0220 */{"security_cmd.c", "convert_to_u64", 1179, "0x82: u64_data(H:0x%x, L:0x%x)",},\
/* 0x0221 */{"security_cmd.c", "convert_to_u64", 1185, "0x84: u64_data(H:0x%x, L:0x%x)",},\
/* 0x0222 */{"security_cmd.c", "convert_to_u64", 1190, "0x88: u64_data(H:0x%x, L:0x%x)",},\
/* 0x0223 */{"security_cmd.c", "convert_to_u64", 1195, "0x83, 0x85-0x87: u64_data(H:0x%x, L:0x%x)",},\
/* 0x0224 */{"security_cmd.c", "nvmet_security_handle_cmd", 2912, "opcode %x, prot %x, comid %x",},\
/* 0x0225 */{"security_cmd.c", "nvmet_security_handle_cmd", 2960, "res %d",},\
/* 0x0226 */{"security_cmd.c", "opal_admin_sp_auth_lookup", 348, "UID(0x%x, 0x%x, 0x%x, 0x%x)",},\
/* 0x0227 */{"security_cmd.c", "opal_admin_sp_auth_lookup", 350, "UID(0x%x, 0x%x, 0x%x, 0x%x)",},\
/* 0x0228 */{"security_cmd.c", "opal_authenticate_start_session", 531, ": pin_len(0x%x), auth_pin(%d)",},\
/* 0x0229 */{"security_cmd.c", "opal_authenticate_start_session", 536, "Admin1 PIN authentication: passed",},\
/* 0x022a */{"security_cmd.c", "opal_authenticate_start_session", 539, "Admin1 PIN authentication: failed",},\
/* 0x022b */{"security_cmd.c", "opal_authenticate_start_session", 547, "SID PIN authentication: passed",},\
/* 0x022c */{"security_cmd.c", "opal_authenticate_start_session", 550, "SID PIN authentication: failed",},\
/* 0x022d */{"security_cmd.c", "opal_authenticate_start_session", 552, "Encryption Disabled ....",},\
/* 0x022e */{"security_cmd.c", "opal_authenticate_start_session", 565, "MSID PIN authentication: passed",},\
/* 0x022f */{"security_cmd.c", "opal_authenticate_start_session", 568, "MSID PIN authentication: failed",},\
/* 0x0230 */{"security_cmd.c", "opal_check_and_set_locking_range", 1122, "Set LR: row(0x%x), lr_start(0x%x, 0x%x), lr_length(0x%x, 0x%x)",},\
/* 0x0231 */{"security_cmd.c", "opal_check_and_set_locking_range", 1129, "Set LR: failed @1 .........",},\
/* 0x0232 */{"security_cmd.c", "opal_check_and_set_locking_range", 1143, "Set LR: passed .........",},\
/* 0x0233 */{"security_cmd.c", "opal_check_and_set_locking_range", 1152, "Set LR: failed @2 .........",},\
/* 0x0234 */{"security_cmd.c", "opal_dump_pin_data", 503, "Challenge PIN ......",},\
/* 0x0235 */{"security_cmd.c", "opal_dump_pin_data", 505, "0x%x ",},\
/* 0x0236 */{"security_cmd.c", "opal_dump_pin_data", 508, "PIN .....",},\
/* 0x0237 */{"security_cmd.c", "opal_dump_pin_data", 511, "0x%x ",},\
/* 0x0238 */{"security_cmd.c", "opal_gen_key", 858, "UID(0x%x, 0x%x, 0x%x, 0x%x)",},\
/* 0x0239 */{"security_cmd.c", "opal_gen_key", 860, "UID(0x%x, 0x%x, 0x%x, 0x%x)",},\
/* 0x023a */{"security_cmd.c", "opal_gen_key", 885, "opal_key_gen: key_index(%d)",},\
/* 0x023b */{"security_cmd.c", "opal_gen_key_method", 932, ": len(%d)",},\
/* 0x023c */{"security_cmd.c", "opal_get_method", 790, ": len(%d)",},\
/* 0x023d */{"security_cmd.c", "opal_get_method", 814, "Start Column: 0x%x",},\
/* 0x023e */{"security_cmd.c", "opal_get_method", 820, "End Column: 0x%x",},\
/* 0x023f */{"security_cmd.c", "opal_get_resp_fill_name_value", 2315, ": Err - col number not in list",},\
/* 0x0240 */{"security_cmd.c", "opal_get_resp_fill_name_value", 2328, ": Err - Get Method response.",},\
/* 0x0241 */{"security_cmd.c", "opal_l0_discovery", 2024, "LBA size = %d (%d)",},\
/* 0x0242 */{"security_cmd.c", "opal_l0_discovery", 2027, "NCAP(H:0x%x, L:0x%x)",},\
/* 0x0243 */{"security_cmd.c", "opal_l0_discovery", 2033, "LR Global Range Length(L:0x%x)",},\
/* 0x0244 */{"security_cmd.c", "opal_locking_sp_activate_method", 1049, ": len=%d",},\
/* 0x0245 */{"security_cmd.c", "opal_locking_sp_activate_method", 1072, "OPAL ACTIVATE: PASS",},\
/* 0x0246 */{"security_cmd.c", "opal_locking_sp_activate_method", 1075, "OPAL ACTIVATE: FAIL",},\
/* 0x0247 */{"security_cmd.c", "opal_locking_sp_auth_lookup", 365, "UID(0x%x, 0x%x, 0x%x, 0x%x)",},\
/* 0x0248 */{"security_cmd.c", "opal_locking_sp_auth_lookup", 367, "UID(0x%x, 0x%x, 0x%x, 0x%x)",},\
/* 0x0249 */{"security_cmd.c", "opal_locking_sp_get_method", 1008, "Start Column: 0x%x",},\
/* 0x024a */{"security_cmd.c", "opal_locking_sp_get_method", 1014, "End Column: 0x%x",},\
/* 0x024b */{"security_cmd.c", "opal_locking_sp_get_method", 984, ":len=%d",},\
/* 0x024c */{"security_cmd.c", "opal_method_lookup", 331, "UID(0x%x, 0x%x, 0x%x, 0x%x)",},\
/* 0x024d */{"security_cmd.c", "opal_method_lookup", 333, "UID(0x%x, 0x%x, 0x%x, 0x%x)",},\
/* 0x024e */{"security_cmd.c", "opal_set_get_method_params", 718, "UID(0x%x, 0x%x, 0x%x, 0x%x)",},\
/* 0x024f */{"security_cmd.c", "opal_set_get_method_params", 720, "UID(0x%x, 0x%x, 0x%x, 0x%x)",},\
/* 0x0250 */{"security_cmd.c", "opal_set_get_method_params", 735, "LR key index: 0x%x",},\
/* 0x0251 */{"security_cmd.c", "opal_set_get_method_params", 738, "LR values get: 0x%x",},\
/* 0x0252 */{"security_cmd.c", "opal_set_get_method_params", 752, ": LockingInfo",},\
/* 0x0253 */{"security_cmd.c", "opal_set_get_method_params", 760, ": C_pin_get",},\
/* 0x0254 */{"security_cmd.c", "opal_set_method", 1240, ": len(%d)",},\
/* 0x0255 */{"security_cmd.c", "opal_set_method", 1252, "set -- SID_PIN",},\
/* 0x0256 */{"security_cmd.c", "opal_set_method", 1261, "Row index: 0x%x",},\
/* 0x0257 */{"security_cmd.c", "opal_set_method", 1270, "Locking SP User index: 0x%x",},\
/* 0x0258 */{"security_cmd.c", "opal_set_method", 1278, "set -- MBR Done",},\
/* 0x0259 */{"security_cmd.c", "opal_set_method", 1323, "Column: j(0x%x),Num(0x%x),val(0x%x)",},\
/* 0x025a */{"security_cmd.c", "opal_set_method", 1334, "Start row: 0x%x",},\
/* 0x025b */{"security_cmd.c", "opal_set_method", 1339, "Start Column: size(0x%x)",},\
/* 0x025c */{"security_cmd.c", "opal_set_method", 1350, "- token t(0x%x)",},\
/* 0x025d */{"security_cmd.c", "opal_set_method", 1351, "- c_pin(%s)",},\
/* 0x025e */{"security_cmd.c", "opal_set_method", 1357, "- token t(0x%x)",},\
/* 0x025f */{"security_cmd.c", "opal_set_method", 1358, "Locking SP C_PIN_User%d(%s)",},\
/* 0x0260 */{"security_cmd.c", "opal_set_method", 1364, "MBR set column(2), value(0x%x)",},\
/* 0x0261 */{"security_cmd.c", "opal_set_method", 1378, "Set start and length values for LR(%d)",},\
/* 0x0262 */{"security_cmd.c", "opal_set_method", 1397, "FAILED LR%d set method ....",},\
/* 0x0263 */{"security_cmd.c", "opal_set_method", 1405, "opal_set_method. FAILED in parsing....",},\
/* 0x0264 */{"security_cmd.c", "opal_smuid_properties", 437, "0x%x 0x%x %s",},\
/* 0x0265 */{"security_cmd.c", "opal_smuid_properties", 444, "0x%x 0x%x %s",},\
/* 0x0266 */{"security_cmd.c", "opal_smuid_properties", 451, "0x%x 0x%x %s",},\
/* 0x0267 */{"security_cmd.c", "opal_smuid_properties", 458, "0x%x 0x%x %s",},\
/* 0x0268 */{"security_cmd.c", "opal_smuid_properties", 465, "0x%x 0x%x %s",},\
/* 0x0269 */{"security_cmd.c", "opal_smuid_properties", 472, "0x%x 0x%x %s",},\
/* 0x026a */{"security_cmd.c", "opal_start_session", 625, ": admin_sp",},\
/* 0x026b */{"security_cmd.c", "opal_start_session", 628, ": locking_sp",},\
/* 0x026c */{"security_cmd.c", "opal_start_session", 631, "Error UID:(H:0x%x, L:0x%x)",},\
/* 0x026d */{"security_cmd.c", "opal_start_session", 640, ": t(0x%x), tlen(0x%x)",},\
/* 0x026e */{"security_cmd.c", "opal_start_session", 650, ": t(0x%x), tlen(0x%x)",},\
/* 0x026f */{"security_cmd.c", "opal_start_session", 653, ": t(0x%x), tlen(0x%x)",},\
/* 0x0270 */{"security_cmd.c", "opal_start_session", 656, ": t(0x%x), tlen(0x%x)",},\
/* 0x0271 */{"security_cmd.c", "opal_start_session", 665, ": t(0x%x), tlen(0x%x)",},\
/* 0x0272 */{"security_cmd.c", "opal_start_session", 669, ": admin1_cpin_uid",},\
/* 0x0273 */{"security_cmd.c", "opal_start_session", 672, ": sid_cpin_uid",},\
/* 0x0274 */{"security_cmd.c", "opal_start_session", 676, "Error c_pin:(H:0x%x, L:0x%x)",},\
/* 0x0275 */{"security_cmd.c", "opal_start_session", 690, "HSN: 0x%x",},\
/* 0x0276 */{"security_cmd.c", "opal_start_session", 693, "HSN: 0x%x",},\
/* 0x0277 */{"security_cmd.c", "opal_start_session", 698, "HSN: 0x%x",},\
/* 0x0278 */{"security_cmd.c", "opal_thissp_authenticate_method", 1523, ":len=%d",},\
/* 0x0279 */{"security_cmd.c", "opal_tk_call", 2062, "uid %x, func %p",},\
/* 0x027a */{"security_cmd.c", "opal_tk_eos", 1441, ": len(%d)",},\
/* 0x027b */{"security_cmd.c", "uid_adminsp_func", 1667, "TODO",},\
/* 0x027c */{"security_cmd.c", "uid_authority_func", 1714, "TODO",},\
/* 0x027d */{"security_cmd.c", "uid_cpin_func", 1738, "method(%d),UID(%x %x %x %x)",},\
/* 0x027e */{"security_cmd.c", "uid_cpin_func", 1740, " UID(%x %x %x %x)",},\
/* 0x027f */{"security_cmd.c", "uid_cpin_sid_func", 1778, "method(%d),UID(%x %x %x %x)",},\
/* 0x0280 */{"security_cmd.c", "uid_cpin_sid_func", 1780, " UID(%x %x %x %x)",},\
/* 0x0281 */{"security_cmd.c", "uid_locking_range_func", 1819, "method(%d),UID(%x %x %x %x)",},\
/* 0x0282 */{"security_cmd.c", "uid_locking_range_func", 1821, " UID(%x %x %x %x)",},\
/* 0x0283 */{"security_cmd.c", "uid_locking_range_key_func", 1865, "method(%d),UID(%x %x %x %x)",},\
/* 0x0284 */{"security_cmd.c", "uid_locking_range_key_func", 1867, " UID(%x %x %x %x)",},\
/* 0x0285 */{"security_cmd.c", "uid_lockingsp_func", 1691, "method(%d),UID(%x %x %x %x)",},\
/* 0x0286 */{"security_cmd.c", "uid_lockingsp_func", 1693, " UID(%x %x %x %x)",},\
/* 0x0287 */{"security_cmd.c", "uid_mbr_control_func", 1895, "method(%d),UID(%x %x %x %x)",},\
/* 0x0288 */{"security_cmd.c", "uid_mbr_control_func", 1897, " UID(%x %x %x %x)",},\
/* 0x0289 */{"security_cmd.c", "uid_smuid_func", 1620, ": method(%d)",},\
/* 0x028a */{"security_cmd.c", "uid_thissp_func", 1652, ": method(%d)",},\
/* 0x028b */{"smart.c", "health_get_nvm_status", 122, "available spare(%d) < thr(%d)",},\
/* 0x028c */{"smart.c", "health_get_temperature", 208, "temp %d, (%d %d)",},\
/* 0x028d */{"smart.c", "health_get_temperature", 219, "temp[%d] %d, (%d %d)",},\
/* 0x028e */{"cache.c", "MERGER", 1525, "merge search hit %x %d",},\
/* 0x028f */{"cache.c", "MERGER", 1558, "cancel a triggered mgr? lda %x (%d %d)",},\
/* 0x0290 */{"cache.c", "MERGER", 1589, "set dtag %d to unmap",},\
/* 0x0291 */{"cache.c", "MERGER", 1595, "merge lda %x on err dtag",},\
/* 0x0292 */{"cache.c", "READER_ftl_trigger", 1329, "cache read xfer %d reader from ftl Q to dtag Q",},\
/* 0x0293 */{"cache.c", "READER_ftl_trigger", 1336, "ce %x wait dtag",},\
/* 0x0294 */{"cache.c", "READER_ftl_trigger", 1350, "ce %x ftl trigger",},\
/* 0x0295 */{"cache.c", "READER_ftl_trigger", 1356, "No reader wait ftl???",},\
/* 0x0296 */{"cache.c", "WRITER", 2217, "FF, nothing to flush, %d",},\
/* 0x0297 */{"cache.c", "WRITER_display", 2072, "WRITER(%d %d %d %d)",},\
/* 0x0298 */{"cache.c", "WRITER_display", 2079, "\text_lda(0x%x)",},\
/* 0x0299 */{"cache.c", "WRITER_display", 2086, "\tlda(0x%x)",},\
/* 0x029a */{"cache.c", "WRITER_flush", 1680, "writer flush forbid by bm reset",},\
/* 0x029b */{"cache.c", "WRITER_flush", 1720, "NS: flush meet lda %d: %x in err status",},\
/* 0x029c */{"cache.c", "WRITER_flush", 1839, "flush meet lda %d: %x in err status",},\
/* 0x029d */{"cache.c", "cache_ce_trim", 3369, "serves HR /w lda(0x%x)",},\
/* 0x029e */{"cache.c", "cache_data_res_dump", 4140, "[%d] Dtag(%d) type(%x) ptr=0x%x",},\
/* 0x029f */{"cache.c", "cache_data_res_dump", 4144, "[%d] CE LDA %x ref %d",},\
/* 0x02a0 */{"cache.c", "cache_data_res_dump", 4148, "[%d] RCU LDA %x ref %d",},\
/* 0x02a1 */{"cache.c", "cache_data_res_dump", 4152, "[%d] MEGER(%d) LDA %x state %d",},\
/* 0x02a2 */{"cache.c", "cache_data_res_dump", 4168, "Summary: CE(%d) RCU(%d) MERGER(%d) BWR/FREE(%d) UNMAP(%d)",},\
/* 0x02a3 */{"cache.c", "cache_data_res_dump", 4169, "Read Ahead: CERT(%d) FREE(%d)",},\
/* 0x02a4 */{"cache.c", "cache_dget", 734, "Alloc Dtag (%d)",},\
/* 0x02a5 */{"cache.c", "cache_dump_light", 3833, "DataRes: wm_high(%d), wm_low(%d), size(%d), credit(%d), balance(%d), unmap(1), free_wr(%d)",},\
/* 0x02a6 */{"cache.c", "cache_dump_light", 3838, "RCU(%d) MERGER(%d/%d), READER(%d/%d)",},\
/* 0x02a7 */{"cache.c", "cache_dump_light", 3844, "WRITER BUDDY (%d %d %d %d)",},\
/* 0x02a8 */{"cache.c", "cache_dump_light", 3850, "WRITER PH (%d %d %d %d)",},\
/* 0x02a9 */{"cache.c", "cache_dump_light", 3856, "WRITER flush size %d, ttl wr size %d, opt size %d, cache in flush 0x%x",},\
/* 0x02aa */{"cache.c", "cache_dump_light", 3862, "low wmk %d",},\
/* 0x02ab */{"cache.c", "cache_ff_wr_statis_dump", 3816, "wr mode %d statis %d (L:0x%x, H:0x%x)",},\
/* 0x02ac */{"cache.c", "cache_ff_wr_statis_dump", 3822, "ff src: resume (L:0x%x, H:0x%x)",},\
/* 0x02ad */{"cache.c", "cache_ff_wr_statis_dump", 3824, "ff src: cache flush (L:0x%x, H:0x%x)",},\
/* 0x02ae */{"cache.c", "cache_ff_wr_statis_dump", 3826, "ff src: cache off (L:0x%x, H:0x%x)",},\
/* 0x02af */{"cache.c", "cache_flush", 2285, "cache flush blk by resubmit %d",},\
/* 0x02b0 */{"cache.c", "cache_flush", 2309, "ff, cache flush, tag:%d",},\
/* 0x02b1 */{"cache.c", "cache_flush", 2318, "cache_in_flush = 0, tag:%d",},\
/* 0x02b2 */{"cache.c", "cache_force_flush_resume", 2246, "FF resume, flush all req, sn:%d",},\
/* 0x02b3 */{"cache.c", "cache_init", 4068, "Prefer Write #DU size (%d)",},\
/* 0x02b4 */{"cache.c", "cache_main", 4375, "recyclable CE(s) (%d): Recycled",},\
/* 0x02b5 */{"cache.c", "cache_mem_dump", 4224, "Cahe not init!",},\
/* 0x02b6 */{"cache.c", "cache_mem_dump", 4228, "CE(s) elements:",},\
/* 0x02b7 */{"cache.c", "cache_mem_dump", 4233, "[%d] CE(0x%p): lda(0x%x) Dtag(%d) Ref.(%d) state(%s)",},\
/* 0x02b8 */{"cache.c", "cache_mem_dump", 4235, "rd_rq_hd(%d) entry2(%d) w_m(%d) dtag_in_ra(%d)",},\
/* 0x02b9 */{"cache.c", "cache_mem_dump", 4243, "CE(s) Summary: utilization (%d-%d)/%d, recyclable(%d/%d)",},\
/* 0x02ba */{"cache.c", "cache_mem_dump", 4247, "Waiting Rd_req_CE(%d / %d)",},\
/* 0x02bb */{"cache.c", "cache_mslice_cmpl", 1421, "Ref put for Dtag(%d) and Dtag(%d)",},\
/* 0x02bc */{"cache.c", "cache_nrm_data_in", 2832, "replace err cache lda %x (%d %d)",},\
/* 0x02bd */{"cache.c", "cache_nrm_data_in", 2840, "Replace Dtag (%d) <- Dtag (%d)",},\
/* 0x02be */{"cache.c", "cache_nrm_data_in", 2857, "RCU Dtag (%d) ref(%d) <- Dtag (%d)",},\
/* 0x02bf */{"cache.c", "cache_nrm_data_in", 2871, "merge blocked lda(0x%x) read fire",},\
/* 0x02c0 */{"cache.c", "cache_nrm_data_in", 2909, "lda(0x%x) PR->R->W",},\
/* 0x02c1 */{"cache.c", "cache_par_data_in", 2995, "slice:Dtag(%d) ofst(%d) nlba(%d)",},\
/* 0x02c2 */{"cache.c", "cache_par_data_in", 3013, "Merge for lda(0x%x) immediately",},\
/* 0x02c3 */{"cache.c", "cache_par_data_in", 3051, "ua wr fls to avoid deadlock!%d",},\
/* 0x02c4 */{"cache.c", "cache_pasg_read_error", 911, "cache pasg error %d %d",},\
/* 0x02c5 */{"cache.c", "cache_pend_rd_res_chk", 2663, "read %d chek pend %d fail",},\
/* 0x02c6 */{"cache.c", "cache_pend_rd_res_trigger", 2673, "read % chek pend %d trigger",},\
/* 0x02c7 */{"cache.c", "cache_ra_abort", 1217, "ra(%d->%d) dtag(%d-%d), abt %d",},\
/* 0x02c8 */{"cache.c", "cache_ra_abort", 1221, "ttl_ras=%d ttl_hits=%d ttl_seq_cnt=%d ttl_exec_cnt=%d ttl_slower_cnt=%d ttl_lacks=%d",},\
/* 0x02c9 */{"cache.c", "cache_ra_dtags_refill", 1210, "ra dtag cert(%d) free(%d)",},\
/* 0x02ca */{"cache.c", "cache_ra_exec", 1106, "discard unhit, det(%d->%d) ra(%d->%d) dtag(%d-%d)",},\
/* 0x02cb */{"cache.c", "cache_ra_forcast", 1268, "ra(%d->%d) new seq @ %d",},\
/* 0x02cc */{"cache.c", "cache_read", 2379, "skip err lda %x",},\
/* 0x02cd */{"cache.c", "cache_read", 2443, "err lda %x",},\
/* 0x02ce */{"cache.c", "cache_ref_put", 3092, "(%d) Dtag (%d) lkp_t (%x)",},\
/* 0x02cf */{"cache.c", "cache_ref_put", 3171, "lda(0x%x) rDone",},\
/* 0x02d0 */{"cache.c", "cache_ref_put", 3186, "Merge is Done for lda(0x%x) <- Dtag(%d)",},\
/* 0x02d1 */{"cache.c", "cache_ref_put", 3190, "serves HR /w lda(0x%x)",},\
/* 0x02d2 */{"cache.c", "cache_ref_put", 3237, "Free wr size already 0!",},\
/* 0x02d3 */{"cache.c", "cache_rslice", 1014, "ce %x w ftl",},\
/* 0x02d4 */{"cache.c", "cache_rslice", 1029, "r lda(0x%x)->Dtag(%d)",},\
/* 0x02d5 */{"cache.c", "cache_start", 4101, "Cache get %d Dtags to DataRes",},\
/* 0x02d6 */{"cache.c", "cache_start", 4115, "cache optimal_io_size (%d)",},\
/* 0x02d7 */{"cache.c", "cache_trigger_read_on_ce", 2690, "skip err lda %x",},\
/* 0x02d8 */{"cache.c", "cache_trim", 3459, "mem is not enough to do unalign trim",},\
/* 0x02d9 */{"cache.c", "cache_trim_unalign_handle", 3294, "Unmap part of lda(0x%x) immediately",},\
/* 0x02da */{"cache.c", "cache_write", 2616, "Write lba(0x%x - %d), occupied #DU(%d)",},\
/* 0x02db */{"cache.c", "cache_write", 2632, "Recycle #CE %d",},\
/* 0x02dc */{"cache.c", "cache_write_cont", 2519, "(%d, %d), Freed %d",},\
/* 0x02dd */{"cache.c", "check_cache_deadlock", 4336, "dl, res size:%d, flush 2 req, free:%d %d",},\
/* 0x02de */{"cache.c", "check_cache_deadlock", 4343, "dl, res size:%d, flush 1 req, 1, free:%d %d",},\
/* 0x02df */{"cache.c", "check_cache_deadlock", 4351, "dl, res size:%d, flush 1 req, 2, free:%d %d",},\
/* 0x02e0 */{"cache.c", "force_cache_flush", 3897, ".... start",},\
/* 0x02e1 */{"cache.c", "force_cache_flush_cmpl", 3879, ".... Completed %d/%d",},\
/* 0x02e2 */{"cache.c", "force_cache_flush_io_block", 3918, ".... start",},\
/* 0x02e3 */{"cache.c", "force_cache_flush_io_block_cmpl", 3907, ".... Completed",},\
/* 0x02e4 */{"cache.c", "print_cache_mgr_info", 4261, "DataRes: wm_high(%d), wm_low(%d), size(%d), credit(%d), balance(%d), unmap(1), free_wr(%d)",},\
/* 0x02e5 */{"cache.c", "print_cache_mgr_info", 4266, "RCU(%d) MERGER(%d), READER(%d/%d)",},\
/* 0x02e6 */{"cache.c", "print_cache_mgr_info", 4271, "ttl wr size:%d ttl ph size:%d flush size:%d cache in flush:0x%x req free cnt:%d",},\
/* 0x02e7 */{"cache.c", "print_cache_mgr_info", 4286, "state %d, in_flush %d, lack_res %d, on_wr_slice %d",},\
/* 0x02e8 */{"cache.c", "print_cache_mgr_info", 4287, "ref_cnt %d, wait_merger_cnt %d, lda 0x%x, dtag:0x%x",},\
/* 0x02e9 */{"cache.c", "print_cache_mgr_info", 4291, "slice state %d, dtag:0x%x",},\
/* 0x02ea */{"cache.c", "print_debug_cache_info", 4308, "ttl_wr_size:%d, flush_size:%d, optimal_size:%d, res_size:%d, sn:%d",},\
/* 0x02eb */{"cache.c", "print_debug_cache_info", 4309, "credit:%d, RCU:%d, MERGER_1:%d, MERGER_2:%d",},\
/* 0x02ec */{"cache.c", "print_debug_cache_info", 4310, "READER_1:%d, READER_2:%d, balance:%d, free_wr:%d",},\
/* 0x02ed */{"cache.c", "print_debug_cache_info", 4311, "host flush:%d, blk_q:%d, req free cnt:%d",},\
/* 0x02ee */{"cache.c", "print_debug_cache_info", 4314, "ttl_wr_size:%d, flush_size:%d, optimal_size:%d, res_size:%d, sn:%d",},\
/* 0x02ef */{"cache.c", "print_debug_cache_info", 4315, "credit:%d, RCU:%d, MERGER_1:%d, MERGER_2:%d",},\
/* 0x02f0 */{"cache.c", "print_debug_cache_info", 4316, "READER_1:%d, READER_2:%d, balance:%d, free_wr:%d",},\
/* 0x02f1 */{"cache.c", "print_debug_cache_info", 4317, "host flush:%d, blk_q:%d, req free cnt:%d",},\
/* 0x02f2 */{"fdisk.c", "_req_to_slow_ftl_exec", 835, "wr req %x blk by flush %x st %d",},\
/* 0x02f3 */{"fdisk.c", "_req_to_slow_ftl_exec", 865, "flush req %x blk by flush %x",},\
/* 0x02f4 */{"fdisk.c", "_req_to_slow_ftl_exec", 894, "format req %x blk by flush %x",},\
/* 0x02f5 */{"fdisk.c", "_req_to_slow_ftl_exec", 904, "trim req %x blk by flush %x",},\
/* 0x02f6 */{"fdisk.c", "abort_pending_fw_dwnld_req", 1380, "pending dwnld cmd st %d %d, nr dtag %d",},\
/* 0x02f7 */{"fdisk.c", "abort_pending_fw_dwnld_req", 1388, "No pending dwnld cmd?!",},\
/* 0x02f8 */{"fdisk.c", "delay_cmpl_timer_chk", 2284, "req 0x%p UC(%d ms), ctag(%d), op(%d) [%d %d]",},\
/* 0x02f9 */{"fdisk.c", "dfs_flush", 291, "smart: oom",},\
/* 0x02fa */{"fdisk.c", "dfs_init", 2229, "device block init fail",},\
/* 0x02fb */{"fdisk.c", "dfs_start", 2256, "new stat file",},\
/* 0x02fc */{"fdisk.c", "dfs_start", 2266, "stat file was drop",},\
/* 0x02fd */{"fdisk.c", "fdisk_abort_flushing_req", 1957, "abort flush req %x %x",},\
/* 0x02fe */{"fdisk.c", "fdisk_abort_wr_dump", 1901, "flush req %x",},\
/* 0x02ff */{"fdisk.c", "fdisk_abort_wr_dump", 1903, "External #Dtags (%d)",},\
/* 0x0300 */{"fdisk.c", "fdisk_format_done", 321, "format done",},\
/* 0x0301 */{"fdisk.c", "fdisk_fua_done", 1293, "ctag %d req fua done",},\
/* 0x0302 */{"fdisk.c", "fdisk_fw_commit", 1574, "commit ca [%d] don't support",},\
/* 0x0303 */{"fdisk.c", "fdisk_fw_commit", 1587, "transfer fw not complete,can't commit",},\
/* 0x0304 */{"fdisk.c", "fdisk_fw_commit", 1605, "down load wait dtag cur status:%d",},\
/* 0x0305 */{"fdisk.c", "fdisk_fw_commit", 1616, "fdisk fwb rebuild start",},\
/* 0x0306 */{"fdisk.c", "fdisk_fw_commit", 1632, "commit load fwb error",},\
/* 0x0307 */{"fdisk.c", "fdisk_fw_commit", 1639, "commit fw complete",},\
/* 0x0308 */{"fdisk.c", "fdisk_fw_dwnld", 1422, "down load fw start",},\
/* 0x0309 */{"fdisk.c", "fdisk_fw_dwnld", 1434, "fw_dwnld addr = 0x%x, 0x%x",},\
/* 0x030a */{"fdisk.c", "fdisk_fw_dwnld", 1435, "Image SIG (0x%x) <- Exp. (0x%x) fail",},\
/* 0x030b */{"fdisk.c", "fdisk_fw_dwnld", 1457, "down load wait dtag cur status:%d",},\
/* 0x030c */{"fdisk.c", "fdisk_fw_dwnld", 1467, "xfer (%d) -> cur(%d)",},\
/* 0x030d */{"fdisk.c", "fdisk_fw_dwnld", 1485, "transfer fw image complete, but CRC error",},\
/* 0x030e */{"fdisk.c", "fdisk_fw_dwnld", 1501, "transfer fw image complete",},\
/* 0x030f */{"fdisk.c", "fdisk_fw_dwnld", 1504, "transfer fw image complete, but CRC error",},\
/* 0x0310 */{"fdisk.c", "fdisk_fw_dwnld", 1512, "alloc download buffer Row(0x%x)@CH/CE(%d/%d)",},\
/* 0x0311 */{"fdisk.c", "fdisk_init", 2383, "fdisk initialization",},\
/* 0x0312 */{"fdisk.c", "fdisk_init_done", 2191, "ftldisk init",},\
/* 0x0313 */{"fdisk.c", "fdisk_pdone_handler", 1229, "j:%d i:%d cnt:%d ctag %d dtag %d off %d",},\
/* 0x0314 */{"fdisk.c", "fdisk_read_error", 1255, "ctag %d %x rd err %d",},\
/* 0x0315 */{"fdisk.c", "fdisk_read_error", 1259, "ctag %d req can't find!!!",},\
/* 0x0316 */{"fdisk.c", "fdisk_reset_disk", 1990, "no dtag to abort write",},\
/* 0x0317 */{"fdisk.c", "fdisk_reset_disk", 2000, "------- WR credit(%d) DUMMY(%d,%d)",},\
/* 0x0318 */{"fdisk.c", "fdisk_reset_disk", 2016, "reset fdisk!%d %d %d",},\
/* 0x0319 */{"fdisk.c", "fdisk_reset_disk", 2030, "reset fdisk?%p %d",},\
/* 0x031a */{"fdisk.c", "fdisk_resubmit_req", 955, "req %x op %d resubmit pend",},\
/* 0x031b */{"fdisk.c", "fdisk_set_disk_capacity", 1755, "Ignore Capacity Change %d GB, max %d",},\
/* 0x031c */{"fdisk.c", "fdisk_set_disk_capacity", 1759, "Capacity Change!! (%d -> %d)GB",},\
/* 0x031d */{"fdisk.c", "fdisk_trim", 659, "discard trim 0x%x",},\
/* 0x031e */{"fdisk.c", "fdisk_trim", 688, "resume trim 0x%x",},\
/* 0x031f */{"fdisk.c", "fdisk_trim", 713, "pend trim 0x%x, %d",},\
/* 0x0320 */{"fdisk.c", "fdisk_wait_aborting_wr_done", 1945, "force reset %d %d",},\
/* 0x0321 */{"fdisk.c", "fdisk_wd_err_updt", 2060, "err wd pop c %d, duo %d, dtag %d",},\
/* 0x0322 */{"fdisk.c", "fdisk_wd_req_err", 2087, "ctag %d %d pop %d, wr_cre %d",},\
/* 0x0323 */{"fdisk.c", "fdisk_wd_req_err", 2123, "req %x fua %d %d dtags used by other write",},\
/* 0x0324 */{"fdisk.c", "ftl_flush_cmpl", 339, "shutdown req %x done",},\
/* 0x0325 */{"fdisk.c", "ftl_flush_cmpl", 351, "flush req already aborted %x",},\
/* 0x0326 */{"fdisk.c", "ftl_trim_cmpl", 549, "fe done trim(0x%x) st(0x%x) ftl_req(0x%x)",},\
/* 0x0327 */{"fdisk.c", "ftl_trim_unbind_req", 540, "trim req(0x%x) and ftl_req(0x%x) unbind",},\
/* 0x0328 */{"fdisk.c", "hst_abort_wr_done_filter", 1133, "ab wr %d cur wr %d count %d",},\
/* 0x0329 */{"fdisk.c", "hst_wr_ent_cmpl", 1078, "fua req %x err %d xfer done",},\
/* 0x032a */{"fdisk.c", "single_ncl_read_err_dump", 419, "pda 0x%x L 0x%x s %d",},\
/* 0x032b */{"fdisk.c", "smart_clean_main", 2186, "smart clean finish",},\
/* 0x032c */{"ramdisk.c", "check_unmap", 774, "PI G %x A %x R %x",},\
/* 0x032d */{"ramdisk.c", "ramdisk_cmp_wd_updt", 436, "req(%x) Ctag(%d) Dtag(%d)",},\
/* 0x032e */{"ramdisk.c", "ramdisk_cmp_wd_updt", 447, "cmp Du(%d) %d-%d",},\
/* 0x032f */{"ramdisk.c", "ramdisk_dyn_read_cont", 746, "Dyn(R)(c) Ctag(%d) Du(%d)",},\
/* 0x0330 */{"ramdisk.c", "ramdisk_init", 1016, "alloc Streaming Read #Dtags(%d)",},\
/* 0x0331 */{"ramdisk.c", "ramdisk_init", 1049, "Ramdisk Init done",},\
/* 0x0332 */{"ramdisk.c", "ramdisk_nrm_wd_updt", 320, "req(%x) Ctag(%d) Dtag(%d)",},\
/* 0x0333 */{"ramdisk.c", "ramdisk_part_wd_updt", 587, "req(%x) Ctag(%d) Dtag(%d)",},\
/* 0x0334 */{"ramdisk.c", "ramdisk_part_wd_updt", 615, "merge DU(%d) %d(%d)",},\
/* 0x0335 */{"ramdisk.c", "ramdisk_part_wd_updt", 622, "req(%x) Ctag(%d) Dtag(%d)",},\
/* 0x0336 */{"ramdisk.c", "ramdisk_part_wd_updt", 628, "merge DU(%d) %d(%d)",},\
/* 0x0337 */{"ramdisk.c", "ramdisk_trim", 830, "ramdisk finish dtag(%d)",},\
/* 0x0338 */{"ramdisk.c", "ramdisk_wd_err_updt", 705, "wd err upt recycle dtag(%d)",},\
/* 0x0339 */{"ramdisk.c", "ramdisk_wd_req_err", 671, "pop free dtag %d due error",},\
/* 0x033a */{"ramdisk.c", "ramdisk_wd_req_err", 673, "no free dtag",},\
/* 0x033b */{"ramdisk.c", "req_exec", 884, "(R) Ctag(%d) T(S) NLB(%d) Du(%d/%d)",},\
/* 0x033c */{"ramdisk.c", "req_exec", 908, "(R) Ctag(%d) T(D) NLB(%d) Du(%d/%d)",},\
/* 0x033d */{"ramdisk.c", "req_exec", 967, "(W) Ctag(%d) rDtags(%d/%d) NLB(%d)",},\
/* 0x033e */{"ramdisk.c", "set_map", 274, "PI G %x A %x R %x",},\
/* 0x033f */{"rawdisk.c", "rawdisk_collision", 1546, "lda(0x%x) is re-written, discard it",},\
/* 0x0340 */{"rawdisk.c", "rawdisk_collision", 1550, "lda(0x%x) is in write buffer",},\
/* 0x0341 */{"rawdisk.c", "rawdisk_erase", 594, "spb %d erase done",},\
/* 0x0342 */{"rawdisk.c", "rawdisk_fbbt_trans_bbt", 1939, "Trying mirror fbbt ...",},\
/* 0x0343 */{"rawdisk.c", "rawdisk_fbbt_trans_bbt", 1941, "Defect in MR read fail 2",},\
/* 0x0344 */{"rawdisk.c", "rawdisk_fbbt_trans_bbt", 1946, "SRB fbbt loaded",},\
/* 0x0345 */{"rawdisk.c", "rawdisk_format", 1624, "rawdisk format: PI %s",},\
/* 0x0346 */{"rawdisk.c", "rawdisk_fw_commit", 1426, "commit ca [%d] don't support\n",},\
/* 0x0347 */{"rawdisk.c", "rawdisk_fw_commit", 1439, "transfer fw not complete,can't commit\n",},\
/* 0x0348 */{"rawdisk.c", "rawdisk_fw_commit", 1450, "down load wait dtag cur status:%d",},\
/* 0x0349 */{"rawdisk.c", "rawdisk_fw_commit", 1465, "rawdisk srb rebuild start",},\
/* 0x034a */{"rawdisk.c", "rawdisk_fw_commit", 1481, "commit load srb error\n",},\
/* 0x034b */{"rawdisk.c", "rawdisk_fw_commit", 1488, "commit fw complete\n",},\
/* 0x034c */{"rawdisk.c", "rawdisk_fw_dwnld", 1312, "Image SIG (0x%x) <- Exp. (0x%x) fail",},\
/* 0x034d */{"rawdisk.c", "rawdisk_fw_dwnld", 1325, "down load wait dtag cur status:%d",},\
/* 0x034e */{"rawdisk.c", "rawdisk_fw_dwnld", 1351, "transfer fw image complete, but CRC error\n",},\
/* 0x034f */{"rawdisk.c", "rawdisk_fw_dwnld", 1361, "transfer fw image complete\n",},\
/* 0x0350 */{"rawdisk.c", "rawdisk_fw_dwnld", 1364, "transfer fw image complete, but CRC error\n",},\
/* 0x0351 */{"rawdisk.c", "rawdisk_fw_dwnld", 1371, "alloc download buffer Row(0x%x)@CH/CE(%d/%d)\n",},\
/* 0x0352 */{"rawdisk.c", "rawdisk_fw_dwnld", 1383, "xfer (%d) -> cur(%d)",},\
/* 0x0353 */{"rawdisk.c", "rawdisk_idle_flush", 1048, "%s",},\
/* 0x0354 */{"rawdisk.c", "rawdisk_init", 2159, "cur_spb(%d), nxt_spb(%d)",},\
/* 0x0355 */{"rawdisk.c", "rawdisk_init", 2161, "No good SPB, check defect table!",},\
/* 0x0356 */{"rawdisk.c", "rawdisk_init", 2170, "alloc Streaming Read #Dtags(%d)",},\
/* 0x0357 */{"rawdisk.c", "rawdisk_init", 2188, "Rawdisk init done.",},\
/* 0x0358 */{"rawdisk.c", "rawdisk_pickup_spb", 796, "cur_spb(%d), nxt_spb(%d)",},\
/* 0x0359 */{"rawdisk.c", "rawdisk_power_state_change", 1515, "change power state [%d] complete\n",},\
/* 0x035a */{"rawdisk.c", "rawdisk_read", 685, "op_type = %d, streaming(%d)",},\
/* 0x035b */{"rawdisk.c", "rawdisk_read_prep", 1013, "lda(0x%x) -> pda(0x%x)",},\
/* 0x035c */{"rawdisk.c", "rawdisk_srb_scan", 1842, "SRB hdr scan Row(0x%x)@CH/CE(%d/%d)",},\
/* 0x035d */{"rawdisk.c", "rawdisk_srb_scan", 1849, "SRB Signature -> 0x%x%x",},\
/* 0x035e */{"rawdisk.c", "rawdisk_srb_scan", 1854, "SRB hdr founded",},\
/* 0x035f */{"rawdisk.c", "rawdisk_srb_scan", 1861, "Trying mirror fbbt ...",},\
/* 0x0360 */{"rawdisk.c", "rawdisk_srb_scan", 1863, "SRB fbbt load fail",},\
/* 0x0361 */{"rawdisk.c", "rawdisk_unmap_pda", 1599, "lda(0x%x) is in unmapping area",},\
/* 0x0362 */{"rawdisk.c", "rawdisk_wd_err_updt", 2050, "wd err upt recycle dtag(%d)",},\
/* 0x0363 */{"rawdisk.c", "rawdisk_write_prep", 960, "lda(0x%x) -> pda(0x%x) Dtag(%d)",},\
/* 0x0364 */{"rawdisk.c", "rawdisk_write_prep_for_tsb_tlc", 871, "lda(0x%x) -> pda(0x%x) Dtag(%d)",},\
/* 0x0365 */{"rawdisk.c", "req_exec", 1776, "(W) Ctag(%d) rDtags(%d/%d) NLB(%d)",},\
/* 0x0366 */{"vdisk.c", "fwb_build", 711, "firmware commit to slot [%d]",},\
/* 0x0367 */{"vdisk.c", "fwb_build", 779, "Program %s Row(0x%x)@CH/CE(%d/%d)",},\
/* 0x0368 */{"vdisk.c", "fwb_build", 809, "Program %s Row(0x%x)@CH/CE(%d/%d)",},\
/* 0x0369 */{"vdisk.c", "get_section", 548, "get section 0x%x, len %d, offset %x",},\
/* 0x036a */{"vdisk.c", "get_section_data_from_img", 570, "[single DU %d] 0x%x - 0x%x",},\
/* 0x036b */{"vdisk.c", "get_section_data_from_img", 576, "[cross DU %d] 0x%x - 0x%x",},\
/* 0x036c */{"vdisk.c", "otp_build", 637, "OTP PKEY 0x%x saved",},\
/* 0x036d */{"vdisk.c", "pkey_verify", 690, "Row(0x%x)@CH/CE(%d/%d) fail",},\
/* 0x036e */{"vdisk.c", "rda_erase", 239, "Erasing block Row(0x%x)@CH/CE(%d/%d)",},\
/* 0x036f */{"vdisk.c", "rda_erase", 242, "result: %d",},\
/* 0x0370 */{"vdisk.c", "sb_verify", 912, "[%d] 0x%x - 0x%x",},\
/* 0x0371 */{"vdisk.c", "sb_verify", 914, "Row(0x%x)@CH/CE(%d/%d) fail",},\
/* 0x0372 */{"vdisk.c", "srb_bbt_scan", 438, "SLC Bad Block(%d)@CH/CE/LUN/PLN(%d/%d/%d/%d), PDA %x",},\
/* 0x0373 */{"vdisk.c", "srb_bbt_scan", 525, "Bad Block(%d)@CH/CE/LUN/PLN(%d/%d/%d/%d)",},\
/* 0x0374 */{"vdisk.c", "srb_build", 1512, "MR B(%d) PL(%d) LUN (%d) @CH/CE(%d/%d)",},\
/* 0x0375 */{"vdisk.c", "srb_build", 1515, "MR(m)  B(%d) PL(%d) LUN (%d) @CH/CE(%d/%d)",},\
/* 0x0376 */{"vdisk.c", "srb_build", 1541, "Using old MR parameters: %d",},\
/* 0x0377 */{"vdisk.c", "srb_build", 1680, "FTL B(%d) PL(%d) LUN (%d) @CH/CE(%d/%d)",},\
/* 0x0378 */{"vdisk.c", "srb_build", 1682, "FTL(m)  B(%d) PL(%d) LUN (%d) @CH/CE(%d/%d)",},\
/* 0x0379 */{"vdisk.c", "srb_build", 1685, "FWB B(%d) PL(%d) LUN (%d) @CH/CE(%d/%d)",},\
/* 0x037a */{"vdisk.c", "srb_build", 1687, "FWB(m) B(%d) PL(%d) LUN (%d) @CH/CE(%d/%d)",},\
/* 0x037b */{"vdisk.c", "srb_build", 1690, "DEVB B(%d) PL(%d) LUN (%d) @CH/CE(%d/%d)",},\
/* 0x037c */{"vdisk.c", "srb_build", 1692, "DEVB(m) B(%d) PL(%d) LUN (%d) @CH/CE(%d/%d)",},\
/* 0x037d */{"vdisk.c", "srb_build", 1695, "CUSTOMER B(%d) PL(%d) LUN (%d) @CH/CE(%d/%d), rowAddr:%d",},\
/* 0x037e */{"vdisk.c", "srb_build", 1697, "CUSTOMER(m) B(%d) PL(%d) LUN (%d) @CH/CE(%d/%d)",},\
/* 0x037f */{"vdisk.c", "srb_build", 1700, "EVT B(%d) PL(%d) LUN (%d) @CH/CE(%d/%d)",},\
/* 0x0380 */{"vdisk.c", "srb_build", 1702, "EVT(m)  B(%d) PL(%d) LUN (%d) @CH/CE(%d/%d)",},\
/* 0x0381 */{"vdisk.c", "srb_build", 1713, "FWB(buffer) B(%d) PL(%d) LUN (%d) @CH/CE(%d/%d)",},\
/* 0x0382 */{"vdisk.c", "srb_build", 1744, "SRBH(0~0x%x) C -> {SB(0x%x) SBD(0x%x) ECMF(0x%x) DCMF(0x%x) DBBT(0x%x)}",},\
/* 0x0383 */{"vdisk.c", "srb_build", 1746, "SRBH(m)(0~0x%x) C -> {SB(0x%x) SBD(0x%x) ECMF(0x%x) DCMF(0x%x) DBBT(0x%x)}",},\
/* 0x0384 */{"vdisk.c", "srb_build", 1806, "SRB Header CRC(0x%x)",},\
/* 0x0385 */{"vdisk.c", "srb_build", 1808, "SRB(m) Header CRC(0x%x)",},\
/* 0x0386 */{"vdisk.c", "srb_build", 1896, "Program _SRBH_ Row(0x%x~0x%x)@CH/CE(%d/%d)",},\
/* 0x0387 */{"vdisk.c", "srb_build", 1916, "Program _SRBH_(m) Row(0x%x~0x%x)@CH/CE(%d/%d)",},\
/* 0x0388 */{"vdisk.c", "srb_build", 1941, "Program _PKEY_Row(0x%x) dual Row (0x%x), length %d @CH/CE(%d/%d)",},\
/* 0x0389 */{"vdisk.c", "srb_build", 1945, "Program _PKEY(m)_Row(0x%x) dual Row (0x%x), length %d @CH/CE(%d/%d)",},\
/* 0x038a */{"vdisk.c", "srb_build", 1951, "Program _FW_Row(0x%x) dual Row (0x%x) Row(m)(0x%x) dual Row(m)(0x%x) @CH/CE(%d/%d) ",},\
/* 0x038b */{"vdisk.c", "srb_build", 1957, "Program _FW(m)_Row(0x%x) dual Row (0x%x) Row(m)(0x%x) dual Row(m)(0x%x) @CH/CE(%d/%d) ",},\
/* 0x038c */{"vdisk.c", "srb_build", 1962, "Shasta Loader Program Done.",},\
/* 0x038d */{"vdisk.c", "srb_build", 1966, "Shasta Firmware Program Done.",},\
/* 0x038e */{"vdisk.c", "srb_build", 1972, "Program _ECMF_ Row(0x%x ~ 0x%x)@CH/CE(%d/%d)",},\
/* 0x038f */{"vdisk.c", "srb_build", 1996, "Program _ECMF(m)_ Row(0x%x ~ 0x%x)@CH/CE(%d/%d)",},\
/* 0x0390 */{"vdisk.c", "srb_build", 2019, "Program _DCMF_ Row(0x%x~0x%x)@CH/CE(%d/%d)",},\
/* 0x0391 */{"vdisk.c", "srb_build", 2042, "Program _DCMF(m)_ Row(0x%x~0x%x)@CH/CE(%d/%d)",},\
/* 0x0392 */{"vdisk.c", "srb_build", 2068, "Dftb size(%d) -> #Dus(%d) #PGs(%d)",},\
/* 0x0393 */{"vdisk.c", "srb_build", 2070, "Program _DFTB_ Row(0x%x ~ 0x%x)@CH/CE(%d/%d)",},\
/* 0x0394 */{"vdisk.c", "srb_build", 2094, "Program _DFTB(m)_ Row(0x%x ~ 0x%x)@CH/CE(%d/%d)",},\
/* 0x0395 */{"vdisk.c", "srb_build", 2250, "Scan _DFTB_ Row(0x%x)@CH/CE(%d/%d) PDA(0x%x)",},\
/* 0x0396 */{"vdisk.c", "srb_build", 2272, "Scan _DFTB_(m) Row(0x%x)@CH/CE(%d/%d) PDA(0x%x)",},\
/* 0x0397 */{"vdisk.c", "srb_build", 2289, "MR Block Program Done",},\
/* 0x0398 */{"vdisk.c", "srb_scan", 1015, "SRB fbbt loaded",},\
/* 0x0399 */{"vdisk.c", "srb_scan", 1038, "SRB fbbt load fail",},\
/* 0x039a */{"vdisk.c", "srb_scan", 959, "SRB hdr scan Blk(%d) Row(0x%x)@CH/CE(%d/%d)",},\
/* 0x039b */{"vdisk.c", "srb_scan", 966, "SRB Signature -> 0x%x%x",},\
/* 0x039c */{"vdisk.c", "srb_scan", 971, "SRB hdr founded",},\
/* 0x039d */{"vdisk.c", "srb_scan", 978, "Loading fbbt if any ...",},\
/* 0x039e */{"vdisk.c", "srb_scan", 980, "SRB fbbt length(%x -> %x), consider incomplete.",},\
/* 0x039f */{"vdisk.c", "srb_scan", 987, "Trying mirror fbbt ...",},\
/* 0x03a0 */{"vdisk.c", "vdisk_fw_commit", 2760, "CRC(0x%x) vs. Real(0x%x), please retry!",},\
/* 0x03a1 */{"vdisk.c", "vdisk_fw_commit", 2766, "firmware CRC verified.",},\
/* 0x03a2 */{"vdisk.c", "vdisk_fw_commit", 2772, "There is no CRC information in FW, please retry!",},\
/* 0x03a3 */{"vdisk.c", "vdisk_fw_commit", 2790, "Image SIG (0x%x) -> Exp (0x%x) | AUs (%d)",},\
/* 0x03a4 */{"vdisk.c", "vdisk_fw_commit", 2793, "true GRIT image.",},\
/* 0x03a5 */{"vdisk.c", "vdisk_fw_dwnld", 2335, "Image SIG (0x%x) <- Exp. (0x%x) or (0x%x)",},\
/* 0x03a6 */{"vdisk.c", "vdisk_fw_dwnld", 2341, "xfer (%d) -> cur(%d)",},\
/* 0x03a7 */{"vdisk.c", "vdisk_init", 3685, "Enc size(%d) -> #Dus(%d) #PGs(%d)",},\
/* 0x03a8 */{"vdisk.c", "vdisk_init", 3690, "Dec size(%d) -> #Dus(%d) #PGs(%d)",},\
/* 0x03a9 */{"vdisk.c", "vdisk_init", 3765, "Vdisk init done!",},\
/* 0x03aa */{"hmb.c", "hmb_encry_get_key", 1136, "hmb key %x",},\
/* 0x03ab */{"ctrlr.c", "hal_nvmet_bootpart_get_cmd", 1091, "Boot Partition(%d) is not active\n",},\
/* 0x03ac */{"ctrlr.c", "hal_nvmet_create_cq", 964, "create CQ (%d) Qdepth (%d)",},\
/* 0x03ad */{"ctrlr.c", "hal_nvmet_create_sq", 872, "create SQ (%d), QDepth(%d/%d)",},\
/* 0x03ae */{"ctrlr.c", "hal_nvmet_delete_cq", 600, "Delete CQ (%d)",},\
/* 0x03af */{"ctrlr.c", "hal_nvmet_delete_sq", 763, "Delete SQ (%d)",},\
/* 0x03b0 */{"ctrlr.c", "hal_nvmet_delete_sq", 790, "pop empty cmd",},\
/* 0x03b1 */{"ctrlr.c", "hal_nvmet_delete_sq", 795, "discard %d SQ %d",},\
/* 0x03b2 */{"ctrlr.c", "hal_nvmet_delete_sq", 802, "SQ %d %d/%d",},\
/* 0x03b3 */{"ctrlr.c", "hal_nvmet_delete_sq", 806, "SQ %d %d/%d",},\
/* 0x03b4 */{"ctrlr.c", "hal_nvmet_get_sq_cmd", 456, "cmd(%p) qid(%d) opcode 0x%x, cid(%d) SQ rptr/wptr(%d/%d)",},\
/* 0x03b5 */{"ctrlr.c", "hal_nvmet_get_sq_cmd_review", 428, "cmd(%p) qid(%d) opcode 0x%x, cid(%d) SQ rptr/wptr(%d/%d)",},\
/* 0x03b6 */{"ctrlr.c", "hal_nvmet_get_sq_cmds", 486, "cmd(%p) qid(%d) opcode 0x%x, cid(%d) SQ rptr/wptr(%d/%d)",},\
/* 0x03b7 */{"ctrlr.c", "hal_nvmet_hw_sts", 373, "state is not matched, hw %x, fw %x\n",},\
/* 0x03b8 */{"ctrlr.c", "hal_nvmet_rebuild_sq", 1144, "enable SQ (%d), QDepth(%d)",},\
/* 0x03b9 */{"ctrlr.c", "hal_nvmet_update_cq", 555, "CQ(%d) CID(%d) rptr/wptr (%d/%d) CDW0 %x",},\
/* 0x03ba */{"ctrlr.c", "hal_nvmet_update_cq", 584, "(IN) %p cpl_ppnd_cnt = %d\n",},\
/* 0x03bb */{"ctrlr.c", "nvmet_abort_dma_queue", 1621, "DMA abort req %x %x",},\
/* 0x03bc */{"ctrlr.c", "nvmet_abort_dma_queue", 1641, "DMA abort req %x",},\
/* 0x03bd */{"ctrlr.c", "nvmet_config_xfer_payload", 1858, " No pcie clock ",},\
/* 0x03be */{"ctrlr.c", "nvmet_config_xfer_payload", 1868, "PCIE mps %d mrr %d",},\
/* 0x03bf */{"ctrlr.c", "nvmet_init_aqa_attrs", 1451, "ASQ/ACQ (0x%x%x/0x%x%x)",},\
/* 0x03c0 */{"ctrlr.c", "nvmet_init_aqa_attrs", 1457, "ASQ/ACQ Qdepth (%d/%d) -> (%d/%d)",},\
/* 0x03c1 */{"ctrlr.c", "nvmet_slow_isr", 2116, "DMA queue xfer error %x\n",},\
/* 0x03c2 */{"ctrlr.c", "nvmet_slow_isr", 2124, "SQ ptr err %x",},\
/* 0x03c3 */{"ctrlr.c", "nvmet_slow_isr", 2138, "CQ ptr err %x",},\
/* 0x03c4 */{"ctrlr.c", "nvmet_slow_isr", 2150, "[OUT] cpl_ppnd_cnt=%d",},\
/* 0x03c5 */{"ctrlr.c", "nvmet_slow_isr", 2153, "%p %p\n",},\
/* 0x03c6 */{"ctrlr.c", "nvmet_slow_isr", 2158, "cpl_ppnd_cmd(%p) id %d\n",},\
/* 0x03c7 */{"ctrlr.c", "nvmet_slow_isr", 2162, "WIP %p",},\
/* 0x03c8 */{"ctrlr.c", "nvmet_slow_isr", 2180, "NVMe Subsystem Reset ...",},\
/* 0x03c9 */{"cmd_proc.c", "cmd_proc_cmd_abort", 372, "Abort Ctag(%d)",},\
/* 0x03ca */{"cmd_proc.c", "cmd_proc_cmd_issue", 355, "Ctag(%d) <- (qid(%d) cmd(%p) %d)",},\
/* 0x03cb */{"cmd_proc.c", "cmd_proc_cmpl_isr", 408, "Ctag(%d) completion",},\
/* 0x03cc */{"cmd_proc.c", "cmd_proc_debug_dump", 184, "debug addr %x val %x",},\
/* 0x03cd */{"cmd_proc.c", "cmd_proc_err_paser", 209, "cmd: sts %x ctag %d, elba %d",},\
/* 0x03ce */{"cmd_proc.c", "cmd_proc_isr", 445, "unhandled ISR sts 0x%x",},\
/* 0x03cf */{"hmb_cmd.c", "_hmb_lkp_fmt2", 155, "no support %d lda lookup",},\
/* 0x03d0 */{"hmb.c", "_hmb_tbl_init", 1269, "TBL Seg[%d]: %x%x size %d MB",},\
/* 0x03d1 */{"hmb.c", "_hmb_tbl_init", 1278, "TBL seg[%d] %d MB",},\
/* 0x03d2 */{"hmb.c", "_hmb_tbl_init", 1284, "HMB table %d MB",},\
/* 0x03d3 */{"hmb.c", "hmb_auto_cmd_done_handler", 825, "auto lkp isr ptr %x, but not inited",},\
/* 0x03d4 */{"hmb.c", "hmb_auto_cmd_done_handler", 853, "Discard HMB RST, and invalid reqid %d",},\
/* 0x03d5 */{"hmb.c", "hmb_auto_cmd_done_handler", 864, "cmd is not handled, yet %d/%d",},\
/* 0x03d6 */{"hmb.c", "hmb_auto_cmd_done_handler", 876, "Discard HMB RST",},\
/* 0x03d7 */{"hmb.c", "hmb_auto_cmd_done_handler", 887, "Discard HMB RST %x %d/%d %d %d %d",},\
/* 0x03d8 */{"hmb.c", "hmb_auto_cmd_done_handler", 913, "hmb crc error 0x%x(%d/%d)",},\
/* 0x03d9 */{"hmb.c", "hmb_auto_lkp_rsp_dump", 769, "sq %d fid %d crc %d ent %d",},\
/* 0x03da */{"hmb.c", "hmb_cancel_cmds", 1157, "res ptr %d/%d",},\
/* 0x03db */{"hmb.c", "hmb_cancel_cmds", 1168, "hmb fw resp giveup %p(%d)",},\
/* 0x03dc */{"hmb.c", "hmb_cancel_cmds", 1179, "ptr %d/%d, otf %d",},\
/* 0x03dd */{"hmb.c", "hmb_cancel_cmds", 1191, "hmb fw cmd giveup %p(%d)",},\
/* 0x03de */{"hmb.c", "hmb_cmd_done", 555, "Hmb comand timeout",},\
/* 0x03df */{"hmb.c", "hmb_cmd_done", 558, "hmb cmd %d done, resp_code:%d",},\
/* 0x03e0 */{"hmb.c", "hmb_cmd_done", 562, "hmb crc error",},\
/* 0x03e1 */{"hmb.c", "hmb_cmd_done_handler", 724, "no new hmb resp %d-%d",},\
/* 0x03e2 */{"hmb.c", "hmb_detach", 1214, "hmb detached",},\
/* 0x03e3 */{"hmb.c", "hmb_discard_auto_lookup_result", 790, "hmb auto resp discard %d->%d",},\
/* 0x03e4 */{"hmb.c", "hmb_find_suit_seg", 408, "new seg[%d]: addr %x%x %d",},\
/* 0x03e5 */{"hmb.c", "hmb_find_suit_seg", 415, "new seg[%d]: addr %x%x %d",},\
/* 0x03e6 */{"hmb.c", "hmb_mem_set", 1527, "hmb [%d-%d] size %d",},\
/* 0x03e7 */{"hmb.c", "hmb_mem_set_cb", 1439, "hmb %d seg clear done",},\
/* 0x03e8 */{"hmb.c", "hmb_mem_set_cb", 1479, "req %p %p\n",},\
/* 0x03e9 */{"hmb.c", "hmb_pre_init", 1639, "Seg[%d]: %x%x size %d MB",},\
/* 0x03ea */{"hmb.c", "hmb_pre_init", 1650, "HMB CRC Seg: %d, %d b",},\
/* 0x03eb */{"hmb.c", "hmb_pre_init", 1656, "HMB META Seg: %d, %d b",},\
/* 0x03ec */{"hmb.c", "hmb_setup_preset", 1372, "HMB set timer hit prest",},\
/* 0x03ed */{"hmb.c", "hmb_setup_timer", 1388, "HMB set in timer",},\
/* 0x03ee */{"hmb.c", "hmb_setup_timer", 1391, "HMB set wait in timer",},\
/* 0x03ef */{"hmb.c", "hmb_tbl_init", 1400, "warm boot hmb table init",},\
/* 0x03f0 */{"hmb.c", "hmb_tbl_init", 1411, "HMB set directly",},\
/* 0x03f1 */{"hmb.c", "hmb_tbl_init", 1414, "HMB set wait timer trigger",},\
/* 0x03f2 */{"hmb_cmd.c", "hmb_lkp_rep_fmt2", 274, "HMB lookup/replace fmt2 cnt err %d",},\
/* 0x03f3 */{"hmb_cmd.c", "hmb_lkp_rep_fmt2", 288, "HMB lookup/replace no cmd",},\
/* 0x03f4 */{"srb.c", "cus_info_operation", 1340, "cus_info optype = %d, cus_flag = 0x%x, fcty_dft_cnt = %d, total_aging_dft_cnt = %d\n",},\
/* 0x03f5 */{"srb.c", "cus_info_operation", 1371, "cus_info flag NONONO set [%d]\n",},\
/* 0x03f6 */{"srb.c", "cus_info_operation", 1433, "cus_info No exist optype = %d, size = %d\n",},\
/* 0x03f7 */{"srb.c", "cus_info_operation", 1439, "cus_info read type = %d, size = %d\n",},\
/* 0x03f8 */{"srb.c", "cus_info_operation", 1441, "MAX defects permission is %d!\n",},\
/* 0x03f9 */{"srb.c", "cus_info_operation", 1460, "CUS read info PDA = 0x%x Row = 0x%x, count = %d",},\
/* 0x03fa */{"srb.c", "cus_info_operation", 1466, "cus_info read data(%d) > SRB_MR_DU_SZE(%d)",},\
/* 0x03fb */{"srb.c", "cus_info_operation", 1470, "cus_info read data(%d) =< SRB_MR_DU_SZE(%d)",},\
/* 0x03fc */{"srb.c", "cus_info_operation", 1486, "cus_info read desult data OPtype = %d, data = 0x%x",},\
/* 0x03fd */{"srb.c", "cus_info_operation", 1488, "cus_info write type = %d, size = %d",},\
/* 0x03fe */{"srb.c", "cus_info_operation", 1499, "cus_info Write data OPtype = %d, data = 0x%x, 0x%x",},\
/* 0x03ff */{"srb.c", "cus_info_operation", 1513, "CUS write info Row(0x%x)@CH/CE(%d/%d)",},\
/* 0x0400 */{"srb.c", "cus_info_operation", 1514, "CUS write info PDA = 0x%x\n",},\
/* 0x0401 */{"srb.c", "cus_info_operation", 1515, "CUS write info size(%d) -> #Dus(%d) #PGs(%d)",},\
/* 0x0402 */{"srb.c", "cus_info_operation", 1551, "CUS Wite Header index Row(0x%x)@CH/CE(%d/%d)",},\
/* 0x0403 */{"srb.c", "cus_info_operation", 1552, "CUS Wite Header index PDA = 0x%x size = %d",},\
/* 0x0404 */{"srb.c", "cus_search_pdft_header", 1227, "CusPriPos (%x) is invalid! Need re-manufacturing",},\
/* 0x0405 */{"srb.c", "cus_search_pdft_header", 1231, "PDFT header search %x %d",},\
/* 0x0406 */{"srb.c", "cus_search_pdft_header", 1234, "enter mr fail",},\
/* 0x0407 */{"srb.c", "cus_search_pdft_header", 1256, "PDFT header blank area start PDA = 0x%x, block_id = %d, page = %d",},\
/* 0x0408 */{"srb.c", "cus_search_pdft_header", 1269, "CUS_PDFT header search fail, return first page PDA = 0x%x",},\
/* 0x0409 */{"srb.c", "cus_search_pdft_header", 1281, "CUS_PDFT Finding Row(0x%x)@CH/CE(%1d/%1d) PDA = 0x%x, page = %3d\n",},\
/* 0x040a */{"srb.c", "cus_search_pdft_header", 1284, "CUS_PDFT can't find latest info Row(0x%x)@CH/CE(%1d/%1d) PDA = 0x%x, page = %3d",},\
/* 0x040b */{"srb.c", "cus_search_pdft_header", 1286, "flag = 0x%x, SG = 0x%x",},\
/* 0x040c */{"srb.c", "cus_search_pdft_header", 1289, "CUS_PDFT header search fail, return first page PDA = 0x%x",},\
/* 0x040d */{"srb.c", "fw_build_buffer_block", 564, "download Program Row(0x%x)@CH/CE(%d/%d) dus:%d",},\
/* 0x040e */{"srb.c", "fw_build_buffer_block", 579, "download Program Row(0x%x)@CH/CE(%d/%d) err",},\
/* 0x040f */{"srb.c", "fw_verify_image", 597, "CRC(0x%x) vs. Real(0x%x), please retry!",},\
/* 0x0410 */{"srb.c", "fw_verify_image", 602, "image nand(0x%x) vs. nand(%s), please retry!",},\
/* 0x0411 */{"srb.c", "fw_verify_image", 608, "firmware image verfied.",},\
/* 0x0412 */{"srb.c", "fw_verify_image", 613, "this firmware image not have CRC verify info.",},\
/* 0x0413 */{"srb.c", "srb_fwb_verify_after_upgrade", 514, "Row(0x%x)@CH/CE(%d/%d) fail",},\
/* 0x0414 */{"srb.c", "srb_fwb_verify_after_upgrade", 521, "verify fw image slot%d error after fw commit",},\
/* 0x0415 */{"srb.c", "srb_fwb_verify_after_upgrade", 526, "verify fw image slot%d dual error after fw commit",},\
/* 0x0416 */{"srb.c", "srb_fwb_verify_after_upgrade", 531, "verify fw image slot%d mirror error after fw commit",},\
/* 0x0417 */{"srb.c", "srb_fwb_verify_after_upgrade", 536, "verify fw image slot%d dual mirror error after fw commit",},\
/* 0x0418 */{"srb.c", "srb_loader_verify", 639, "verify image Row(0x%x)@CH/CE(%d/%d)",},\
/* 0x0419 */{"srb.c", "srb_loader_verify", 643, "Row(0x%x)@CH/CE(%d/%d) fail",},\
/* 0x041a */{"srb.c", "srb_loader_verify", 650, "Image sign:[0x%x != 0x%x] CRC:[0x%x != 0x%x] fail",},\
/* 0x041b */{"srb.c", "srb_loader_verify", 655, "Row[%x] 0x%x - 0x%x dus:0x%x",},\
/* 0x041c */{"srb.c", "srb_loader_verify", 675, "fw image CRC error",},\
/* 0x041d */{"srb.c", "srb_page_copy", 351, "copy source Row(0x%x)@CH/CE(%d/%d)",},\
/* 0x041e */{"srb.c", "srb_page_copy", 353, "copy Program Row(0x%x)@CH/CE(%d/%d)pageCnt(0x%x)",},\
/* 0x041f */{"srb.c", "srb_rebuild_fwb", 405, "Row(0x%x)@CH/CE(%d/%d) fail",},\
/* 0x0420 */{"srb.c", "srb_rebuild_fwb", 411, "firmware block signature:[0x%x] != [0x%x] fail",},\
/* 0x0421 */{"srb.c", "srb_rebuild_fwb", 421, "firmware commit invaild download slot:%d, active slot:%d",},\
/* 0x0422 */{"srb.c", "srb_rebuild_fwb", 485, "firmware slot%d rebuild start",},\
/* 0x0423 */{"srb.c", "srb_rebuild_fwb", 498, "Shasta fwb Program Done.",},\
/* 0x0424 */{"srb.c", "srb_scan_and_load", 264, "SRB hdr scan Row(0x%x)@CH/CE(%d/%d)",},\
/* 0x0425 */{"srb.c", "srb_scan_and_load", 270, "SRB Signature -> 0x%x%x",},\
/* 0x0426 */{"srb.c", "srb_scan_and_load", 271, "SRB Header CRC:[0x%x] [0x%x]",},\
/* 0x0427 */{"srb.c", "srb_scan_and_load", 276, "SRB hdr founded CRC:[0x%x]",},\
/* 0x0428 */{"srb.c", "srb_sus_flush_data", 1126, "sus flush data start prev num:%d",},\
/* 0x0429 */{"srb.c", "srb_sus_flush_data", 1155, "sus write lda:0x%x block:%d err",},\
/* 0x042a */{"srb.c", "srb_sus_flush_data", 1164, "sus write lda:0x%x block:%d err",},\
/* 0x042b */{"srb.c", "srb_sus_gc_block", 707, "srb sus GC get dtag fail, into wait gc status",},\
/* 0x042c */{"srb.c", "srb_sus_gc_block", 724, "sus block: %d dus:[0x%x] lda:0x%x read error",},\
/* 0x042d */{"srb.c", "srb_sus_gc_block", 749, "sus write lda:0x%x block:%d err",},\
/* 0x042e */{"srb.c", "srb_sus_gc_block", 758, "sus write lda:0x%x block:%d err",},\
/* 0x042f */{"srb.c", "srb_sus_init", 1593, "sus init srb signature err",},\
/* 0x0430 */{"srb.c", "srb_sus_read", 1011, "sus read lda:0x%x block:%d dus:0x%x err",},\
/* 0x0431 */{"srb.c", "srb_sus_read", 968, "sus status:[%d] read error",},\
/* 0x0432 */{"srb.c", "srb_sus_rebuild", 916, "sus rebuild error",},\
/* 0x0433 */{"srb.c", "srb_sus_rebuild", 925, "sus rebuild error",},\
/* 0x0434 */{"srb.c", "srb_sus_rebuild", 932, "sus rebuild error",},\
/* 0x0435 */{"srb.c", "srb_sus_rebuild", 949, "sus rebuild complete",},\
/* 0x0436 */{"srb.c", "srb_sus_rebuild_block", 796, "sus block[%d] read error",},\
/* 0x0437 */{"srb.c", "srb_sus_rebuild_block", 802, "sus block[%d] not have data",},\
/* 0x0438 */{"srb.c", "srb_sus_rebuild_block", 814, "sus cur block[0x%x] cur du page[0x%x]",},\
/* 0x0439 */{"srb.c", "srb_sus_rebuild_block", 840, "sus block[%d] row[0x%x] read error",},\
/* 0x043a */{"srb.c", "srb_sus_rebuild_block", 851, "sus block[%d] page[0x%x] du offset:%d SIGNATURE error",},\
/* 0x043b */{"srb.c", "srb_sus_test", 1629, "sus test start",},\
/* 0x043c */{"srb.c", "srb_sus_test", 1660, "sus test cur block[%d] cur du[0x%x] prev write:%d",},\
/* 0x043d */{"srb.c", "srb_sus_test", 1664, "sus read lda: %d != %d error",},\
/* 0x043e */{"srb.c", "srb_sus_test", 1667, "sus test complete",},\
/* 0x043f */{"srb.c", "srb_sus_write", 1036, "sus status:[%d] write error",},\
/* 0x0440 */{"srb.c", "srb_sus_write", 1052, "sus write get dtag error",},\
/* 0x0441 */{"srb.c", "srb_sus_write", 1087, "sus write lda:0x%x block:%d err",},\
/* 0x0442 */{"srb.c", "srb_sus_write", 1096, "sus write lda:0x%x block:%d err",},\
/* 0x0443 */{"device_fs.c", "find_old_dfs_file", 569, "discard file %x %x %x %x",},\
/* 0x0444 */{"device_fs.c", "find_old_dfs_file", 574, "old file %x %x %x %x",},\
/* 0x0445 */{"device_fs.c", "read_dfs_file", 624, "No Mem File %d",},\
/* 0x0446 */{"device_fs.c", "srb_dfs_scan", 941, "FS %p MG err",},\
/* 0x0447 */{"device_fs.c", "srb_dfs_scan", 965, "FS %p CRC err",},\
/* 0x0448 */{"device_fs.c", "srb_dfs_scan", 969, "FS %p ver up",},\
/* 0x0449 */{"device_fs.c", "srb_dfs_scan", 978, "Srb Dev FS: %d ROW: %x, PDA:%x\n",},\
/* 0x044a */{"device_fs.c", "srb_dfs_turn", 312, "DFS Turn %d->%d, skip %d",},\
/* 0x044b */{"device_fs.c", "srb_dfs_turn", 384, "FS %d rd err %d",},\
/* 0x044c */{"device_fs.c", "srb_dfs_turn", 388, "R File %d, Mem SZ %d, Read SZ %d/%d, off %d",},\
/* 0x044d */{"device_fs.c", "srb_dfs_turn", 432, "File %d, unread %d",},\
/* 0x044e */{"device_fs.c", "srb_dfs_turn", 463, "DFS wptr %x, log %x",},\
/* 0x044f */{"device_fs.c", "write_dfs_file", 763, "Write File %d NOSPC",},\
/* 0x0450 */{"device_fs.c", "write_dfs_file", 770, "No Mem File %d",},\
/* 0x0451 */{"evlog.c", "evlog_read_dfs", 546, "read %d %d %d %d get %x",},\
/* 0x0452 */{"evlog.c", "evlog_read_dfs", 561, "evlog sig invd %x",},\
/* 0x0453 */{"evlog.c", "evlog_read_internal_buffer", 452, "there is no log in buf",},\
/* 0x0454 */{"evlog.c", "evlog_read_to_host", 626, "evlog read internal",},\
/* 0x0455 */{"evlog.c", "evlog_read_to_host", 629, "evlog read dfs",},\
/* 0x0456 */{"evlog.c", "evlog_read_to_host", 636, "evlog read dfs bypass, read internal",},\
/* 0x0457 */{"evlog.c", "evlog_tmp_to_buf", 222, "evt %d dropped",},\
};


#define EVID_FMT_CRC32 0x51aec4c1

