--K9ACGD8U0B
local TBL_WORDLINE =
{
	{0,2},
	{1,4},
	{3,6},
	{5,8},
	{7,10},
	{9,12},
	{11,14},
	{13,16},
	{15,18},
	{17,20},
	{19,22},
	{21,24},
	{23,26},
	{25,28},
	{27,30},
	{29,32},
	{31,34},
	{33,36},
	{35,38},
	{37,40},
	{39,42},
	{41,44},
	{43,46},
	{45,48},
	{47,50},
	{49,52},
	{51,54},
	{53,56},
	{55,58},
	{57,60},
	{59,62},
	{61,64},
	{63,66},
	{65,68},
	{67,70},
	{69,72},
	{71,74},
	{73,76},
	{75,78},
	{77,80},
	{79,82},
	{81,84},
	{83,86},
	{85,88},
	{87,90},
	{89,92},
	{91,94},
	{93,96},
	{95,98},
	{97,100},
	{99,102},
	{101,104},
	{103,106},
	{105,108},
	{107,110},
	{109,112},
	{111,114},
	{113,116},
	{115,118},
	{117,120},
	{119,122},
	{121,124},
	{123,126},
	{125,128},
	{127,130},
	{129,132},
	{131,134},
	{133,136},
	{135,138},
	{137,140},
	{139,142},
	{141,144},
	{143,146},
	{145,148},
	{147,150},
	{149,152},
	{151,154},
	{153,156},
	{155,158},
	{157,160},
	{159,162},
	{161,164},
	{163,166},
	{165,168},
	{167,170},
	{169,172},
	{171,174},
	{173,176},
	{175,178},
	{177,180},
	{179,182},
	{181,184},
	{183,186},
	{185,188},
	{187,190},
	{189,192},
	{191,194},
	{193,196},
	{195,198},
	{197,200},
	{199,202},
	{201,204},
	{203,206},
	{205,208},
	{207,210},
	{209,212},
	{211,214},
	{213,216},
	{215,218},
	{217,220},
	{219,222},
	{221,224},
	{223,226},
	{225,228},
	{227,230},
	{229,232},
	{231,234},
	{233,236},
	{235,238},
	{237,240},
	{239,242},
	{241,244},
	{243,246},
	{245,248},
	{247,250},
	{249,252},
	{251,254},
	{253,255}
}
local wlcount = 128

local btnew = ByteArray.new
local btget = ByteArray.get
local btset = ByteArray.set
local bt2Str = ByteArray.tostring
local bt2Array = ByteArray.toarray
local btcopy = ByteArray.arraycopy

local pgetstr = Param.getString
local pgetint = Param.getInt
local pgetintx = Param.getIntEx
local pgetmask = Param.getMask

local band = Bit.band
local bor = Bit.bor
local bxor = Bit.bxor
local bnot = Bit.bnot
local ls = Bit.lshift
local rs = Bit.rshift

local trace = Debug.trace
--local msgbox = Debug.msgbox

local c_table =
{
    -- Automatically generated by GPTableGen.exe v.1.0
    --
    0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8
}

function ALLOC_SPACE(n, unit)
    return math.floor((n + unit - 1) / unit)
end

function curTime()
    return os.date("%H:%M:%S").."  "
end

function dbgprint(s)
    trace(curTime()..s)
end

function getbitcount(buf, len, bitvalue)
	local value
	local count = 0
	for i = 0, len-1 do
		value = btget(buf, i)
		count = count + c_table[value + 1]
	end

	if bitvalue == 0 then
		count = len - count
	end

	return count
end

function getbytebit()
	return c_table[byte + 1]
end

function countTable(mytab, ubou)
	local count = 0
	for i = 0, ubou - 1 do
		if mytab[i] ~= nil then
			count = count + 1
		end
	end

	return count
end

function setbitvalue(buff, bit, value)
	local byte = btget(buff, math.floor(bit / 8))
	if value == 1 then
		byte = bor(byte, ls(1, math.fmod(bit, 8)))
	else
		byte = band(byte, bnot(ls(1, math.fmod(bit, 8))));
	end
	btset(buff, math.floor(bit / 8), byte)
end


function GetWLOfPage(page)
	local wl = 1
	for wl=1, wlcount do
		for i=1, 3 do
			if TBL_WORDLINE[wl][i] == page then
				return wl
			end
		end
	end

	return -1
end

function UpdatePageMask(PageMask, PageCount)
	local wlcnt, wlMask = GetWordlinePageMask(PageMask, PageCount)
	local pgcnt, retPageMask = GetNormalPageMask(wlMask, PageCount)
	return retPageMask
end

function GetWordlinePageMask(PageMask, PageCount)
	dbgprint("=============start================")
	local PageMaskLen = ALLOC_SPACE(PageCount, 8)
	local RetPageMask = btnew(PageMaskLen, 0)
	local PageArray = {}

	for page=0, PageCount-1 do
		byte = btget(PageMask, math.floor(page / 8))
		if band(byte, ls(1, math.fmod(page, 8))) ~= 0 then
			PageArray[page] = page
		end
	end

	for wl=1, wlcount do
		bGoodWL = true
		for i=1, 2 do
			if TBL_WORDLINE[wl][i] ~= -1 then
				if PageArray[TBL_WORDLINE[wl][i]] == nil then
					bGoodWL = false
					break
				end
			end
		end

		if bGoodWL then
			setbitvalue(RetPageMask, wl-1, 1)
		end
	end

	dbgprint("=============end================")
	return wlcount, RetPageMask
end

function GetNormalPageMask(PageMask, PageCount)
	dbgprint("=============start================")
	local PageMaskLen = ALLOC_SPACE(PageCount, 8)
	local RetPageMask = btnew(PageMaskLen, 0)
	local nRet = 0

	for wl=0, wlcount-1 do
		byte = btget(PageMask, math.floor(wl / 8))
		if band(byte, ls(1, math.fmod(wl, 8))) ~= 0 then
			for i=0, 1 do
				if TBL_WORDLINE[wl+1][i+1] ~= -1 then
					setbitvalue(RetPageMask, TBL_WORDLINE[wl+1][i+1], 1)
					nRet = nRet + 1
				end
			end
		end
	end


	dbgprint("=============end================")
	return nRet, RetPageMask
end

function ConvertPageWordLineBuff(pPageBuffer, nBlock, nPhyPage, nValidPage)
	dbgprint("=============ConvertPageWordLineBuff start================")
	local wl = 0
	local byte
	local pWordLineBuffer = btnew(nBlock * wlcount, 0)

	local tb = {}
	for page=0, nPhyPage-1 do
		tb[page] = GetWLOfPage(page) - 1
	end

	for block=0, nBlock-1 do
		for page=0, nValidPage-1 do
			--wl = GetWLOfPage(page) - 1
			wl = tb[page]
			byte = btget(pPageBuffer, block * nPhyPage + page)
			btset(pWordLineBuffer, block * wlcount + wl, math.max(byte, btget(pWordLineBuffer, block * wlcount + wl)))
		end
	end

	dbgprint("=============end================")
	return wlcount, pWordLineBuffer
end