function ConvertQlc2Tlc(pScanBuff, nLen, nPhysicPage, nPageCount, nBlock)
	local pRetBuff = ByteArray.new(nLen, 0)
	ByteArray.arraycopy(pRetBuff, 0, pScanBuff, 0, nLen)
	for page = 120, nPageCount-1 do
		if (page <= 3048 and (page % 4) == 0) or (page >= 3050 and (page % 2) == 0) then
			for block = 0, nBlock-1 do
				ByteArray.set(pRetBuff, block * nPhysicPage + page, ByteArray.get(pScanBuff, block * nPhysicPage + page) + 128)
			end
		end
	end
	
	return pRetBuff
end