function ConvertQlc2Tlc(pScanBuff, nLen, nPhysicPage, nPageCount, nBlock)
	local pRetBuff = ByteArray.new(nLen, 0)
	ByteArray.arraycopy(pRetBuff, 0, pScanBuff, 0, nLen)
	for page = 133, nPageCount-1 do
		if (((page <= 2289 or (page >= 2401 and page <= 2445) or (page >= 2485 and page <= 4545 )) and (page % 4 == 1)) or ((page >= 4548 and page <= 4592) and (page % 4 == 0)) or ((page >= 4551 and page <= 4595) and (page % 4 == 3))) then
			for block = 0, nBlock-1 do
				ByteArray.set(pRetBuff, block * nPhysicPage + page, ByteArray.get(pScanBuff, block * nPhysicPage + page) + 128)
			end
		end
	end
	
	return pRetBuff
end
