function ConvertQlc2Tlc(pScanBuff, nLen, nPhysicPage, nPageCount, nBlock)
	local pRetBuff = ByteArray.new(nLen, 0)
	ByteArray.arraycopy(pRetBuff, 0, pScanBuff, 0, nLen)
	for page = 6912, nPageCount-1 do
		for block = 0, nBlock-1 do
				ByteArray.set(pRetBuff, block * nPhysicPage + page, ByteArray.get(pScanBuff, block * nPhysicPage + page) + 128)
		end
	end

	return pRetBuff
end


