#include <stdio.h>

typedef unsigned char		UCHAR;
typedef unsigned short      WORD;
typedef unsigned long       DWORD;	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////FTK_flash_setting////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////												

//HW Setting Byte	0x000~0x030
#pragma pack(1)
typedef struct{														//sizeof(FTK_flash_setting_hw_config_struct) == 0x30
	UCHAR ucB000_DataBusCurrent;									//Byte 0x000
	UCHAR ucB001_CtrlBusCurrent;
	UCHAR ucB002_CEBusCurrent;
	UCHAR ucB003_;
	
	UCHAR ucB004_ReadClock;
	UCHAR ucB005_WriteClock;
	UCHAR ucB006_ReadDutyCycle;
	UCHAR ucB007_WriteDutyCycle;
	UCHAR ucB008[0x08];
	UCHAR ucB010[0x20];
} FTK_flash_setting_hw_config_struct;

//Prog Mode		0x040~0x050
typedef struct{														//sizeof(FTK_flash_prog_mode_mask_struct) == 0x10
	UCHAR bEnFullPage		:1;									//Bit 0
	UCHAR bEnStrongPage		:1;									//Bit 1
	UCHAR bEnWeakPage		:1;									//Bit 2
	UCHAR bEnLastHalfPage	:1;									//Bit 3
	UCHAR bEnProgram3Time	:1;									//Bit 4
	UCHAR bEnFirstHalfPage	:1;									//Bit 5
	UCHAR bEnOBP_TLC		:1;									//Bit 6
	UCHAR bEnOBP_SLC		:1;									//Bit 7
	UCHAR ucRsv[0x0F];
} FTK_flash_prog_mode_mask_struct;

//Sample Block	0x060~0x0E0
typedef struct{
	//sizeof(FTK_flash_sample_blk_struct) == 0x100
	WORD wSampleBlkCnt;
	WORD wSampleBlk[0x7F];
	
} FTK_flash_sample_blk_struct;

//Test Rule		0x140~0x1C0
typedef struct
{
	UCHAR ucProgramPattern;										//Byte 0
	WORD  wRead_Page_Fail_Times_Thresholds;						//Byte 1,2
	UCHAR ucMaxRetryTimes;										//Byte 3
	UCHAR ucECCThresholdRatio;
	UCHAR ucRsv0;
	UCHAR ucRsv[0x7A];
} FTK_flash_test_rule;

//Test condition		0x1C0~0x200
typedef struct{
	DWORD dwMaxTestTime;										//second
	UCHAR bEnDieSortFastPageReadWrite	:1;
	UCHAR bRSV							:7;
	UCHAR bEnInversePatternCheck		:1;
	UCHAR bRSV2							:7;
	UCHAR ucRSV[0x0A];
	UCHAR ucRSV1[0x30];
} FTK_test_condition;

//Test Rule		0x200~0x230
typedef struct
{
	UCHAR ucBinLevelCnt;										//Byte 0x00
	UCHAR ucRsv[0x0F];											//Byte 0x01~0x0F
	DWORD dwBinLevelList[0x20];									//BYTE 0x10~0x50
} FTK_bin_level;
//Main flash setting struct
typedef struct
{	
	FTK_flash_setting_hw_config_struct	sHwConfig;					//HW Setting Byte	0x000~0x030
	FTK_flash_prog_mode_mask_struct		sProgModeMask;				//Prog Mode			0x030~0x040
	FTK_flash_sample_blk_struct			sSampleBlk;					//Sample Block		0x040~0x140	Max:127
	FTK_flash_test_rule					sTestRule;					//Test Rule			0x140~0x1C0
	FTK_test_condition					sTestCondition;				//test condition	0x1C0~0x200
	FTK_bin_level						sBinLevel;					//bin level			0x200~0x250
	
}ftk_flash_setting_struct;
#pragma pack()

void ReadFlashSetting(ftk_flash_setting_struct *sFlashSetting,char* pFileName);
void UpdateFlashSetting(ftk_flash_setting_struct *sFlashSetting,char* pFileName);
void UpdateSingleFile(char* pFileName);
int main()
{
	

	UpdateSingleFile("45DE94937650_Set.bin");
	UpdateSingleFile("98DE94937650_Set.bin");
	UpdateSingleFile("ECDE88BF90C6_Set.bin");
	UpdateSingleFile("ECDE98DE94C5_Set.bin");
	UpdateSingleFile("General_Set.bin");
	


	return 0;
}

void UpdateSingleFile(char* pFileName)
{
	ftk_flash_setting_struct sFlashSetting = {0};
	
	ReadFlashSetting(&sFlashSetting, pFileName);
	
	int multiple = 1;
	
	sFlashSetting.sBinLevel.ucBinLevelCnt = 0x0D;
	
	sFlashSetting.sBinLevel.dwBinLevelList[0]	= 0x3C01*multiple;
	sFlashSetting.sBinLevel.dwBinLevelList[1]	= 0x1E01*multiple;
	sFlashSetting.sBinLevel.dwBinLevelList[2]	= 0x0F01*multiple;
	sFlashSetting.sBinLevel.dwBinLevelList[3]	= 0x0781*multiple;
	sFlashSetting.sBinLevel.dwBinLevelList[4]	= 0x03C1*multiple;
	sFlashSetting.sBinLevel.dwBinLevelList[5]	= 0x01E1*multiple;
	sFlashSetting.sBinLevel.dwBinLevelList[6]	= 0x00F1*multiple;
	sFlashSetting.sBinLevel.dwBinLevelList[7]	= 0x0079*multiple;
	sFlashSetting.sBinLevel.dwBinLevelList[8]	= 0x003D*multiple;
	sFlashSetting.sBinLevel.dwBinLevelList[9]	= 0x001F*multiple;
	sFlashSetting.sBinLevel.dwBinLevelList[10]	= 0x000A*multiple;
	sFlashSetting.sBinLevel.dwBinLevelList[11]	= 0x0005*multiple;
	sFlashSetting.sBinLevel.dwBinLevelList[12]	= 0x0001*multiple;
	
	UpdateFlashSetting(&sFlashSetting, pFileName);
}

void ReadFlashSetting(ftk_flash_setting_struct *sFlashSetting,char* pFileName)
{
	FILE *pf = NULL;

	if ((pf = fopen(pFileName,"rb")) == NULL)
	{
		goto Error_Handle;
	}


	fread(sFlashSetting, sizeof(ftk_flash_setting_struct), 1, pf);

	if (pf != NULL)
	{
		fclose(pf);
		pf = NULL;
	}

Error_Handle:
	return ;
}

void UpdateFlashSetting(ftk_flash_setting_struct *sFlashSetting,char* pFileName)
{
	FILE *pf = NULL;
	
	if ((pf = fopen(pFileName,"wb")) == NULL)
	{
		goto Error_Handle;
	}
	
	fwrite(sFlashSetting, sizeof(ftk_flash_setting_struct), 1, pf);
	
	if (pf != NULL)
	{
		fclose(pf);
		pf = NULL;
	}
	
Error_Handle:
	return ;
}